/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.handlers;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import ganymedes01.etfuturum.tileentities.TileEntitySculkCatalyst;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class SculkEventHandler {
    public static final SculkEventHandler INSTANCE = new SculkEventHandler();
    private final Method getXpMethod = ReflectionHelper.findMethod(EntityLivingBase.class, null, (String[])new String[]{"getExperiencePoints", "func_70693_a"}, (Class[])new Class[]{EntityPlayer.class});
    private final Set<Entity> sculkAffectedEntities = Collections.newSetFromMap(new WeakHashMap());

    private TileEntitySculkCatalyst findNearbyCatalyst(Entity entity) {
        TileEntitySculkCatalyst candidate = null;
        double distance = 64.0;
        for (TileEntity te : entity.field_70170_p.field_147482_g) {
            double thisDistance;
            if (!(te instanceof TileEntitySculkCatalyst) || !((thisDistance = te.func_145835_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)) < distance)) continue;
            candidate = (TileEntitySculkCatalyst)te;
            distance = thisDistance;
        }
        return candidate;
    }

    @SubscribeEvent
    public void onXpOrbSpawn(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityXPOrb) {
            for (Entity mob : this.sculkAffectedEntities) {
                if (mob.field_70128_L || !(event.entity.func_70092_e(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v) < 0.01)) continue;
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.sculkAffectedEntities.size() > 0) {
            this.sculkAffectedEntities.removeIf(e -> e.field_70128_L);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDeath(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityLiving && !event.entityLiving.field_70170_p.field_72995_K && this.getXpMethod != null) {
            int experience;
            TileEntitySculkCatalyst catalyst = this.findNearbyCatalyst((Entity)event.entityLiving);
            if (catalyst == null) {
                return;
            }
            FakePlayer player = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)event.entityLiving.field_70170_p));
            player.func_70029_a(event.entityLiving.field_70170_p);
            try {
                experience = (Integer)this.getXpMethod.invoke((Object)event.entityLiving, player);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
                return;
            }
            catalyst.bloomWithExperience(experience);
            this.sculkAffectedEntities.add((Entity)event.entityLiving);
        }
    }
}

