/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.processor;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.IRecipeHandler;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import cpw.mods.fml.relauncher.ReflectionHelper;
import gregapi.NEI_RecipeMap;
import gregapi.data.FL;
import gregapi.recipes.Recipe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class GregTech6RecipeProcessor
implements IRecipeProcessor {
    @Override
    @Nonnull
    public Set<String> getAllOverlayIdentifier() {
        HashSet<String> identifiers = new HashSet<String>();
        for (Recipe.RecipeMap tMap : Recipe.RecipeMap.RECIPE_MAPS.values()) {
            if (!tMap.mNEIAllowed) continue;
            identifiers.add(tMap.mNameNEI);
        }
        return identifiers;
    }

    @Override
    @Nonnull
    public String getRecipeProcessorId() {
        return "GregTech6";
    }

    @Override
    @Nonnull
    public List<PositionedStack> getRecipeInput(IRecipeHandler recipe, int recipeIndex, String identifier) {
        ArrayList<PositionedStack> recipeInputs = new ArrayList<PositionedStack>();
        if (this.getAllOverlayIdentifier().contains(identifier)) {
            recipeInputs.addAll(recipe.getIngredientStacks(recipeIndex));
            recipeInputs.removeIf(positionedStack -> FL.getFluid((ItemStack)positionedStack.item, (boolean)true) != null || positionedStack.item.field_77994_a == 0);
            if (recipe instanceof NEI_RecipeMap) {
                Field mRecipeMapField = ReflectionHelper.findField(NEI_RecipeMap.class, (String[])new String[]{"mRecipeMap"});
                Recipe.RecipeMap mRecipeMap = null;
                try {
                    mRecipeMap = (Recipe.RecipeMap)mRecipeMapField.get(recipe);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (mRecipeMap != null) {
                    ItemStack lastItem = ((PositionedStack)recipeInputs.get((int)(recipeInputs.size() - 1))).items[0];
                    for (ItemStack stack : mRecipeMap.mRecipeMachineList) {
                        if (!ItemStack.func_77970_a((ItemStack)lastItem, (ItemStack)stack)) continue;
                        recipeInputs.remove(recipeInputs.size() - 1);
                        break;
                    }
                }
            }
            return recipeInputs;
        }
        return recipeInputs;
    }

    @Override
    @Nonnull
    public List<PositionedStack> getRecipeOutput(IRecipeHandler recipe, int recipeIndex, String identifier) {
        ArrayList<PositionedStack> recipeOutput = new ArrayList<PositionedStack>();
        if (this.getAllOverlayIdentifier().contains(identifier)) {
            recipeOutput.addAll(recipe.getOtherStacks(recipeIndex));
            recipeOutput.removeIf(positionedStack -> FL.getFluid((ItemStack)positionedStack.item, (boolean)true) != null || positionedStack.item.field_77994_a == 0);
            recipeOutput.removeIf(positionedStack -> positionedStack instanceof NEI_RecipeMap.FixedPositionedStack && ((NEI_RecipeMap.FixedPositionedStack)positionedStack).mChance > 0 && ((NEI_RecipeMap.FixedPositionedStack)positionedStack).mChance != ((NEI_RecipeMap.FixedPositionedStack)positionedStack).mMaxChance);
            return recipeOutput;
        }
        return recipeOutput;
    }
}

