/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.util.enderstorage;

import codechicken.enderstorage.EnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.storage.EnderItemStoragePlugin;
import codechicken.enderstorage.storage.item.EnderItemStorage;
import codechicken.enderstorage.storage.liquid.EnderLiquidStorage;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.util.enderstorage.EnderStorageFrequency;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.FluidStack;

public final class EnderStorageUtil {
    public static final int MAX_FREQUENCY = 4095;

    private EnderStorageUtil() {
    }

    public static ItemComponent getItem(Type type) {
        switch (type) {
            case CHEST: {
                return ItemComponent.create((Block)EnderStorage.blockEnderChest, 0).get();
            }
            case TANK: {
                return ItemComponent.create((Block)EnderStorage.blockEnderChest, 4096).get();
            }
            case POUCH: {
                return ItemComponent.create((Item)EnderStorage.itemEnderPouch, 0);
            }
        }
        throw new IllegalArgumentException("Unhandled Type: " + (Object)((Object)type));
    }

    public static ItemComponent getPersonalItem() {
        return ItemComponent.create(EnderStorage.personalItem, 0);
    }

    public static Optional<Type> getType(Component component) {
        if (component.type() != Component.ComponentType.ITEM) {
            return Optional.empty();
        }
        ItemComponent itemComponent = (ItemComponent)component;
        if (itemComponent.item() == EnderStorage.itemEnderPouch) {
            return Optional.of(Type.POUCH);
        }
        if (itemComponent.item() == Item.func_150898_a((Block)EnderStorage.blockEnderChest)) {
            switch (itemComponent.damage() >> 12) {
                case 0: {
                    return Optional.of(Type.CHEST);
                }
                case 1: {
                    return Optional.of(Type.TANK);
                }
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Map<EnderStorageFrequency, EnderItemStorage> getEnderChests(Owner owner) {
        String ownerParam = owner.stringParam();
        LinkedHashMap<EnderStorageFrequency, EnderItemStorage> map = new LinkedHashMap<EnderStorageFrequency, EnderItemStorage>();
        IntStream.rangeClosed(0, 4095).forEach(freq -> map.put(EnderStorageFrequency.create(freq), (EnderItemStorage)EnderStorageUtil.getManager().getStorage(ownerParam, freq, Type.CHEST.stringParam)));
        return map;
    }

    public static Map<EnderStorageFrequency, EnderLiquidStorage> getEnderTanks(Owner owner) {
        String ownerParam = owner.stringParam();
        LinkedHashMap<EnderStorageFrequency, EnderLiquidStorage> map = new LinkedHashMap<EnderStorageFrequency, EnderLiquidStorage>();
        IntStream.rangeClosed(0, 4095).map(EnderStorageUtil::reverseInt).forEach(freq -> map.put(EnderStorageFrequency.createReverse(freq), (EnderLiquidStorage)EnderStorageUtil.getManager().getStorage(ownerParam, freq, Type.TANK.stringParam)));
        return map;
    }

    public static int reverseInt(int i) {
        int a = i & 0xF;
        int b = i & 0xF0;
        int c = i & 0xF00;
        return a << 8 | b | c >> 8;
    }

    public static int getChestSize() {
        return EnderItemStoragePlugin.sizes[EnderItemStoragePlugin.configSize];
    }

    public static boolean isEmpty(EnderItemStorage storage) {
        for (int i = 0; i < EnderStorageUtil.getChestSize(); ++i) {
            if (storage.func_70301_a(i) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(EnderLiquidStorage storage) {
        FluidStack fluidStack = storage.getFluid();
        return fluidStack == null || fluidStack.amount == 0;
    }

    private static EnderStorageManager getManager() {
        return EnderStorageManager.instance((!Minecraft.func_71410_x().func_71356_B() ? 1 : 0) != 0);
    }

    public static enum Type {
        CHEST("item"),
        TANK("liquid"),
        POUCH("item");

        public final String stringParam;

        private Type(String stringParam) {
            this.stringParam = stringParam;
        }
    }

    public static enum Owner {
        GLOBAL,
        PERSONAL;


        public String stringParam() {
            switch (this) {
                case GLOBAL: {
                    return "global";
                }
                case PERSONAL: {
                    return Minecraft.func_71410_x().field_71439_g.getDisplayName();
                }
            }
            throw new IllegalStateException("Unhandled Owner: " + (Object)((Object)this));
        }
    }
}

