/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.crusher;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.PoweredTask;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.crusher.CrusherRecipeManager;
import crazypants.enderio.machine.crusher.GrindingMultiplierNBT;
import crazypants.enderio.machine.crusher.IGrindingMultiplier;
import crazypants.enderio.machine.crusher.PacketGrindingBall;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import crazypants.enderio.network.PacketHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileCrusher
extends AbstractPoweredTaskEntity {
    protected IGrindingMultiplier gb;
    protected int currGbUse = 0;
    protected int maxGbUse = 0;
    protected int lastSendGbScaled = 0;
    private boolean useGrindingBall;

    public TileCrusher() {
        super(new SlotDefinition(2, 4));
    }

    @Override
    public String func_145825_b() {
        return ModObject.blockSagMill.unlocalisedName;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockSagMill.unlocalisedName;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return CrusherRecipeManager.instance.isValidInput(new MachineRecipeInput(i, itemstack));
    }

    public int getBallDurationScaled(int scale) {
        return this.maxGbUse > 0 ? (int)((float)scale * (1.0f - (float)this.currGbUse / (float)this.maxGbUse)) : 0;
    }

    @Override
    protected double usePower() {
        double res = super.usePower();
        boolean sendGB = false;
        if (this.gb != null && this.useGrindingBall) {
            this.currGbUse = (int)((double)this.currGbUse + res);
            if (this.currGbUse >= this.gb.getDurationMJ()) {
                this.currGbUse = 0;
                this.maxGbUse = 0;
                this.gb = null;
                sendGB = true;
            } else {
                int newScaled = this.getBallDurationScaled(16);
                if (newScaled != this.lastSendGbScaled) {
                    sendGB = true;
                }
            }
        }
        if (this.gb == null) {
            this.gb = CrusherRecipeManager.getInstance().getGrindballFromStack(this.inventory[1]);
            if (this.gb != null) {
                this.maxGbUse = this.gb.getDurationMJ();
                this.func_70298_a(1, 1);
                this.func_70296_d();
                sendGB = false;
            }
        }
        if (sendGB) {
            PacketHandler.sendToAllAround(new PacketGrindingBall(this), (TileEntity)this);
            this.lastSendGbScaled = this.getBallDurationScaled(16);
        }
        return res;
    }

    @Override
    protected void taskComplete() {
        IPoweredTask ct = this.currentTask;
        super.taskComplete();
        if (this.gb != null && this.useGrindingBall && ct != null && ct.getBonusType() == RecipeBonusType.MULTIPLY_OUTPUT) {
            float chance = this.random.nextFloat();
            for (float mul = this.gb.getGrindingMultiplier() - 1.0f; mul > 0.0f; mul -= 1.0f) {
                if (!(chance <= mul)) continue;
                this.currentTask = ct;
                super.taskComplete();
            }
        }
    }

    @Override
    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        PoweredTask res;
        this.useGrindingBall = false;
        if (this.gb != null) {
            boolean bl = this.useGrindingBall = !CrusherRecipeManager.getInstance().isExcludedFromBallBonus(this.getRecipeInputs());
            if (this.useGrindingBall) {
                res = new PoweredTask(nextRecipe, chance / this.gb.getChanceMultiplier(), this.getRecipeInputs());
                res.setRequiredEnergy(res.getRequiredEnergy() * this.gb.getPowerMultiplier());
            } else {
                res = new PoweredTask(nextRecipe, chance, this.getRecipeInputs());
            }
        } else {
            res = new PoweredTask(nextRecipe, chance, this.getRecipeInputs());
        }
        return res;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.gb = GrindingMultiplierNBT.readFromNBT(nbtRoot);
        this.currGbUse = nbtRoot.func_74762_e("currGbUse");
        this.maxGbUse = this.gb != null ? this.gb.getDurationMJ() : 0;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        if (this.gb != null) {
            GrindingMultiplierNBT.writeToNBT(this.gb, nbtRoot);
        }
        nbtRoot.func_74768_a("currGbUse", this.currGbUse);
        this.lastSendGbScaled = this.getBallDurationScaled(16);
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public String getSoundName() {
        return "machine.sagmill";
    }

    @Override
    public float getVolume() {
        return super.getVolume() * 0.125f;
    }
}

