/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.vecmath.VecmathUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.GuiContainerBaseEIO;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.capbank.ContainerCapBank;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.machine.capbank.packet.PacketGuiChange;
import crazypants.enderio.machine.capbank.packet.PacketNetworkStateRequest;
import crazypants.enderio.machine.gui.GuiButtonIoConfig;
import crazypants.enderio.machine.gui.GuiOverlayIoConfig;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.PowerDisplayUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiCapBank
extends GuiContainerBaseEIO {
    private static final CapBankClientNetwork NULL_NETWORK = new CapBankClientNetwork(-1);
    protected static final int INPUT_BUTTON_ID = 18;
    protected static final int OUTPUT_BUTTON_ID = 37;
    protected static final int CONFIG_ID = 377996104;
    private static final int POWER_X = 29;
    private static final int POWER_Y = 9;
    private static final int POWER_WIDTH = 10;
    private static final int POWER_HEIGHT = 68;
    protected static final int BOTTOM_POWER_Y = 77;
    private int inputX = 102;
    private int inputY = 18;
    private int outputX = 102;
    private int outputY = 36;
    private int rightMargin = 32;
    private final TileCapBank capBank;
    private RedstoneModeButton inputRsButton;
    private RedstoneModeButton outputRsButton;
    private TextFieldEnder maxInputTF;
    private TextFieldEnder maxOutputTF;
    private final GuiOverlayIoConfig configOverlay;
    private final GuiButtonIoConfig configB;
    private CapBankClientNetwork network;
    private int initialStateCount = -1;
    private boolean initState = true;
    private final ContainerCapBank container;

    public GuiCapBank(Entity player, InventoryPlayer playerInv, TileCapBank te) {
        super((Container)new ContainerCapBank(playerInv, te), "capacitorBank");
        this.capBank = te;
        this.container = (ContainerCapBank)this.field_147002_h;
        this.updateState();
        this.field_146999_f = 218;
        this.addToolTip(new GuiToolTip(new Rectangle(5, 9, 10, 68), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(PowerDisplayUtil.formatPower(GuiCapBank.this.network.getEnergyStoredL()) + " " + PowerDisplayUtil.ofStr());
                this.text.add(EnumChatFormatting.WHITE + PowerDisplayUtil.formatPower(GuiCapBank.this.network.getMaxEnergyStoredL()) + " " + EnumChatFormatting.GRAY + PowerDisplayUtil.abrevation());
                float change = GuiCapBank.this.network.getAverageChangePerTick();
                String color = EnumChatFormatting.WHITE.toString();
                if (change > 0.0f) {
                    color = EnumChatFormatting.GREEN.toString() + "+";
                } else if (change < 0.0f) {
                    color = EnumChatFormatting.RED.toString();
                }
                this.text.add(String.format("%s%s%s" + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr(), color, PowerDisplayUtil.formatPower(Math.round(change)), " " + EnumChatFormatting.GRAY.toString()));
            }
        });
        int x = this.field_146999_f - this.rightMargin - 16 - 21;
        int y = this.inputY;
        this.inputRsButton = new RedstoneModeButton((IGuiScreen)this, -1, x, y, new IRedstoneModeControlable(){

            @Override
            public void setRedstoneControlMode(RedstoneControlMode mode) {
                GuiCapBank.this.network.setInputControlMode(mode);
                GuiCapBank.this.sendUpdateToServer();
            }

            @Override
            public RedstoneControlMode getRedstoneControlMode() {
                return GuiCapBank.this.network.getInputControlMode();
            }
        });
        this.inputRsButton.setTooltipKey("enderio.gui.capBank.inputRs");
        this.outputRsButton = new RedstoneModeButton((IGuiScreen)this, -1, x, y += 18, new IRedstoneModeControlable(){

            @Override
            public void setRedstoneControlMode(RedstoneControlMode mode) {
                GuiCapBank.this.network.setOutputControlMode(mode);
                GuiCapBank.this.sendUpdateToServer();
            }

            @Override
            public RedstoneControlMode getRedstoneControlMode() {
                return GuiCapBank.this.network.getOutputControlMode();
            }
        });
        this.outputRsButton.setTooltipKey("enderio.gui.capBank.outputRs");
        ArrayList<BlockCoord> coords = new ArrayList<BlockCoord>();
        if (this.network != null && this.network.getMembers().size() < 200) {
            for (TileCapBank cb : this.network.getMembers()) {
                coords.add(cb.getLocation());
            }
        }
        if (coords.isEmpty()) {
            coords.add(te.getLocation());
        }
        this.configOverlay = new GuiOverlayIoConfig(coords){

            @Override
            protected String getLabelForMode(IoMode mode) {
                if (mode == IoMode.PUSH) {
                    return EnderIO.lang.localize("gui.capBank.outputMode");
                }
                if (mode == IoMode.PULL) {
                    return EnderIO.lang.localize("gui.capBank.inputMode");
                }
                return super.getLabelForMode(mode);
            }
        };
        this.addOverlay(this.configOverlay);
        this.configB = new GuiButtonIoConfig((IGuiScreen)this, 377996104, x, y += 20, te, this.configOverlay);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        x = this.inputX - 24;
        y = this.inputY;
        this.maxInputTF = new TextFieldEnder(fontRenderer, x, y, 68, 16);
        this.maxInputTF.func_146203_f(10);
        this.maxInputTF.setCharFilter(TextFieldEnder.FILTER_NUMERIC);
        x = this.outputX - 24;
        y = this.outputY;
        this.maxOutputTF = new TextFieldEnder(fontRenderer, x, y, 68, 16);
        this.maxOutputTF.func_146203_f(10);
        this.maxOutputTF.setCharFilter(TextFieldEnder.FILTER_NUMERIC);
        this.textFields.add(this.maxInputTF);
        this.textFields.add(this.maxOutputTF);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.configB.onGuiInit();
        this.inputRsButton.onGuiInit();
        this.outputRsButton.onGuiInit();
    }

    protected void func_73869_a(char par1, int par2) {
        super.func_73869_a(par1, par2);
        this.updateInputOutput();
    }

    private void updateInputOutput() {
        int output;
        int input = PowerDisplayUtil.parsePower((GuiTextField)this.maxInputTF);
        if (input >= 0 && this.network.getMaxInput() != input) {
            this.setMaxInput(input);
        }
        if ((output = PowerDisplayUtil.parsePower((GuiTextField)this.maxOutputTF)) >= 0 && this.network.getMaxOutput() != output) {
            this.setMaxOutput(output);
        }
    }

    private void setMaxOutput(int output) {
        if (output != this.network.getMaxOutput()) {
            this.network.setMaxOutput(output);
            this.maxOutputTF.func_146180_a(PowerDisplayUtil.formatPower(this.network.getMaxOutput()));
            this.sendUpdateToServer();
        }
    }

    private void setMaxInput(int input) {
        if (input != this.network.getMaxInput()) {
            this.network.setMaxInput(input);
            this.maxInputTF.func_146180_a(PowerDisplayUtil.formatPower(this.network.getMaxInput()));
            this.sendUpdateToServer();
        }
    }

    protected void sendUpdateToServer() {
        if (this.network != NULL_NETWORK) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGuiChange(this.capBank));
        }
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        this.requestStateUpdate();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f - 21, this.field_147000_g);
        if (this.container.hasBaublesSlots()) {
            this.func_73729_b(sx, sy + 83, 197, 83, 24, 77);
        }
        int i1 = this.getEnergyStoredScaled(68);
        this.func_73729_b(sx + 29, sy + 77 - i1, 197, 0, 10, i1);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(i);
            guibutton.func_146112_a(this.field_146297_k, 0, 0);
        }
        int midX = sx + this.field_146999_f / 2;
        String str = EnderIO.lang.localize("gui.capBank.maxIo") + " " + PowerDisplayUtil.formatPower(this.network.getMaxIO()) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
        FontRenderer fontRenderer = this.getFontRenderer();
        int swid = fontRenderer.func_78256_a(str);
        int x = midX - swid / 2;
        int y = this.field_147009_r + 5;
        this.func_73731_b(fontRenderer, str, x, y, -1);
        str = EnderIO.lang.localize("gui.capBank.maxInput") + ":";
        swid = fontRenderer.func_78256_a(str);
        x = this.field_147003_i + this.inputX - swid - 3;
        y = this.field_147009_r + this.inputY + 2;
        this.func_73731_b(fontRenderer, str, x, y, -1);
        str = EnderIO.lang.localize("gui.capBank.maxOutput") + ":";
        swid = fontRenderer.func_78256_a(str);
        x = this.field_147003_i + this.outputX - swid - 3;
        y = this.field_147009_r + this.outputY + 2;
        this.func_73731_b(fontRenderer, str, x, y, -1);
        super.func_146976_a(par1, par2, par3);
    }

    public void drawHoveringText(List par1List, int par2, int par3, FontRenderer font) {
        GL11.glPushAttrib((int)8256);
        super.drawHoveringText(par1List, par2 + 24, par3, font);
        GL11.glPopAttrib();
    }

    public int getGuiLeft() {
        return this.field_147003_i + 24;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public int getXSize() {
        return this.field_146999_f - 42;
    }

    public int getOverlayOffsetX() {
        return 21;
    }

    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    private int getEnergyStoredScaled(int scale) {
        return (int)VecmathUtil.clamp((double)Math.round((double)scale * this.network.getEnergyStoredRatio()), (double)0.0, (double)scale);
    }

    private void requestStateUpdate() {
        if (EnderIO.proxy.getTickCount() % 2L == 0L && !this.updateState()) {
            this.network.requestPowerUpdate(this.capBank, 2);
        }
    }

    private boolean updateState() {
        if (!this.initState) {
            return false;
        }
        if (this.capBank.getNetwork() == null) {
            this.network = NULL_NETWORK;
            return true;
        }
        if (this.network == null || this.network == NULL_NETWORK) {
            this.network = (CapBankClientNetwork)this.capBank.getNetwork();
            this.initialStateCount = this.network.getStateUpdateCount();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkStateRequest(this.capBank));
            return true;
        }
        if (this.network.getStateUpdateCount() == this.initialStateCount) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkStateRequest(this.capBank));
            return true;
        }
        if (this.network.getStateUpdateCount() > this.initialStateCount) {
            this.container.updateInventory();
            this.updateFieldsFromState();
            this.initState = false;
            return true;
        }
        return false;
    }

    private void updateFieldsFromState() {
        this.maxInputTF.func_146180_a(PowerDisplayUtil.formatPower(this.network.getMaxInput()));
        this.maxOutputTF.func_146180_a(PowerDisplayUtil.formatPower(this.network.getMaxOutput()));
        this.inputRsButton.setMode(this.network.getInputControlMode());
        this.outputRsButton.setMode(this.network.getOutputControlMode());
    }
}

