/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.mechworks.landmine.behavior;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tconstruct.mechworks.landmine.Helper;
import tconstruct.mechworks.landmine.LandmineStack;
import tconstruct.mechworks.landmine.behavior.BehaviorBlockThrow;
import tconstruct.mechworks.landmine.behavior.BehaviorDefault;
import tconstruct.mechworks.landmine.behavior.BehaviorDummy;
import tconstruct.mechworks.landmine.behavior.BehaviorExplosive;
import tconstruct.mechworks.landmine.behavior.BehaviorFirecharge;
import tconstruct.mechworks.landmine.behavior.BehaviorFirework;
import tconstruct.mechworks.landmine.behavior.BehaviorPotion;
import tconstruct.mechworks.landmine.behavior.BehaviorPreventExplode;
import tconstruct.mechworks.landmine.behavior.BehaviorProjectile;
import tconstruct.mechworks.landmine.behavior.BehaviorShears;
import tconstruct.mechworks.landmine.behavior.BehaviorSpawnEgg;

public abstract class Behavior {
    public static HashMap<LandmineStack, Behavior> behaviorsListItems = new HashMap();
    public static HashMap<LandmineStack, Behavior> behaviorsListBlocks = new HashMap();
    protected static Behavior defaultBehavior;
    public static Behavior dummy;
    public static Behavior utilityMode;
    public static Behavior explosive;
    public static Behavior firework;
    public static Behavior blockThrow;
    public static Behavior potion;
    public static Behavior fireball;
    public static Behavior spawn;
    public static Behavior shoot;
    public static Behavior shear;

    public static void registerBuiltInBehaviors() {
        defaultBehavior = new BehaviorDefault();
        Behavior.addBehavior(new LandmineStack(Items.field_151055_y), dummy);
        Behavior.addBehavior(new LandmineStack(Items.field_151137_ax), utilityMode);
        Behavior.addBehavior(new LandmineStack(Blocks.field_150478_aa), blockThrow);
        Behavior.addBehavior(new LandmineStack(Items.field_151016_H), explosive);
        Behavior.addBehavior(new LandmineStack(Blocks.field_150335_W), explosive);
        Behavior.addBehavior(new LandmineStack(Items.field_151152_bP), firework);
        Behavior.addBehavior(new LandmineStack((Item)Items.field_151068_bn), potion);
        Behavior.addBehavior(new LandmineStack(Items.field_151059_bz), fireball);
        Behavior.addBehavior(new LandmineStack(Items.field_151063_bx), spawn);
        Behavior.addBehavior(new LandmineStack(Items.field_151032_g), shoot);
        Behavior.addBehavior(new LandmineStack(Items.field_151126_ay), shoot);
        Behavior.addBehavior(new LandmineStack(Items.field_151079_bi), shoot);
        Behavior.addBehavior(new LandmineStack((Item)Items.field_151097_aZ), shear);
        for (Object ob : Block.field_149771_c) {
            Block b;
            if (!(ob instanceof Block) || !(b = (Block)ob).func_149688_o().func_76218_k() || !b.func_149686_d() || b.func_149744_f() || b instanceof ITileEntityProvider || behaviorsListBlocks.containsKey(new LandmineStack(b))) continue;
            Behavior.addBehavior(new LandmineStack(b), blockThrow);
        }
    }

    public static Behavior getBehaviorFromStack(ItemStack par1ItemStack) {
        block5: {
            block4: {
                if (par1ItemStack == null) {
                    return null;
                }
                if (!(par1ItemStack.func_77973_b() instanceof ItemBlock)) break block4;
                if (behaviorsListBlocks.isEmpty()) break block5;
                for (int i = 0; i < behaviorsListBlocks.size(); ++i) {
                    LandmineStack st = (LandmineStack)behaviorsListBlocks.keySet().toArray()[i];
                    if (!st.equals(par1ItemStack)) continue;
                    return (Behavior)behaviorsListBlocks.values().toArray()[i];
                }
                break block5;
            }
            if (!behaviorsListItems.isEmpty()) {
                for (int i = 0; i < behaviorsListItems.size(); ++i) {
                    LandmineStack st = (LandmineStack)behaviorsListItems.keySet().toArray()[i];
                    if (!st.equals(par1ItemStack)) continue;
                    return (Behavior)behaviorsListItems.values().toArray()[i];
                }
            }
        }
        return null;
    }

    public static Behavior getDefaulBehavior() {
        return defaultBehavior;
    }

    public static void addBehavior(LandmineStack par1LandmineStack, Behavior par2Behavior) {
        if (par1LandmineStack.isBlock) {
            if (!behaviorsListBlocks.containsKey(par1LandmineStack)) {
                behaviorsListBlocks.put(par1LandmineStack, par2Behavior);
            }
        } else if (!behaviorsListItems.containsKey(par1LandmineStack)) {
            behaviorsListItems.put(par1LandmineStack, par2Behavior);
        }
    }

    public abstract void executeLogic(World var1, int var2, int var3, int var4, ItemStack var5, Entity var6, boolean var7);

    public int getStackLimit(ItemStack par1ItemStack) {
        return 1;
    }

    public void getInformation(ItemStack par1ItemStack, List par2List) {
    }

    public boolean effectStacks() {
        return true;
    }

    public EnumFacing getFacing(World par1World, int par2, int par3, int par4) {
        ForgeDirection dir = Helper.convertMetaToForgeOrientation(par1World.func_72805_g(par2, par3, par4));
        switch (dir) {
            case UP: {
                return EnumFacing.DOWN;
            }
            case WEST: {
                return EnumFacing.WEST;
            }
            case EAST: {
                return EnumFacing.EAST;
            }
            case SOUTH: {
                return EnumFacing.NORTH;
            }
            case NORTH: {
                return EnumFacing.SOUTH;
            }
        }
        return EnumFacing.UP;
    }

    public boolean doesBehaviorPreventRemovalOfBlock(ItemStack par1ItemStack) {
        return false;
    }

    public boolean isOffensive(ItemStack par1ItemStack) {
        return true;
    }

    public boolean isBehaviorExchangableWithOffensive(ItemStack par1ItemStack) {
        return true;
    }

    public boolean shouldItemBeRemoved(ItemStack par1ItemStack, boolean willBlockGetRemoved) {
        return true;
    }

    public static int arrayIndexOfStack(ArrayList<ItemStack> stacks, ItemStack item) {
        Iterator<ItemStack> i1 = stacks.iterator();
        int index = 0;
        while (i1.hasNext()) {
            ItemStack stack = i1.next();
            if (stack.func_77969_a(item)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static boolean arrayContainsEqualStack(ArrayList<ItemStack> stacks, ItemStack item) {
        for (ItemStack stack : stacks) {
            if (!stack.func_77969_a(item)) continue;
            return true;
        }
        return false;
    }

    public boolean overridesDefault() {
        return false;
    }

    static {
        dummy = new BehaviorDummy();
        utilityMode = new BehaviorPreventExplode();
        explosive = new BehaviorExplosive();
        firework = new BehaviorFirework();
        blockThrow = new BehaviorBlockThrow();
        potion = new BehaviorPotion();
        fireball = new BehaviorFirecharge();
        spawn = new BehaviorSpawnEgg();
        shoot = new BehaviorProjectile();
        shear = new BehaviorShears();
    }
}

