/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.dropoff;

import com.cleanroommc.bogosorter.BogoSorter;
import com.cleanroommc.bogosorter.common.config.BogoSorterConfig;
import com.cleanroommc.bogosorter.common.dropoff.DropOffInvButton;
import com.cleanroommc.bogosorter.mixins.early.minecraft.GuiContainerAccessor;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraftforge.client.event.GuiScreenEvent;

public class DropOffButtonHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!BogoSorterConfig.dropOff.enableDropOff) {
            return;
        }
        GuiScreen screen = event.gui;
        if (!BogoSorterConfig.dropOff.button.showButton || screen instanceof GuiContainerCreative) {
            return;
        }
        try {
            if (screen instanceof GuiInventory) {
                GuiInventory inv = (GuiInventory)screen;
                event.buttonList.add(new DropOffInvButton((GuiContainer)inv));
            }
        }
        catch (NullPointerException e) {
            BogoSorter.LOGGER.error("Erroring adding dropoff button to player inventory \n" + e);
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!BogoSorterConfig.dropOff.enableDropOff) {
            return;
        }
        GuiScreen screen = event.gui;
        if (!BogoSorterConfig.dropOff.button.showButton) {
            return;
        }
        if (screen instanceof GuiInventory) {
            for (GuiButton guiButton : ((GuiContainerAccessor)event.gui).getButtonList()) {
                if (!(guiButton instanceof DropOffInvButton)) continue;
                DropOffInvButton invButton = (DropOffInvButton)guiButton;
                invButton.drawTooltip(event.mouseX, event.mouseY);
            }
        }
    }
}

