/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.island;

import chylex.hee.block.BlockPersegrit;
import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.item.ItemKnowledgeNote;
import chylex.hee.mechanics.enhancements.EnhancementHandler;
import chylex.hee.mechanics.enhancements.types.EnderPearlEnhancements;
import chylex.hee.system.collections.WeightedList;
import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.system.collections.weight.ObjectWeightPair;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.CollectionUtil;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.loot.IItemPostProcessor;
import chylex.hee.world.loot.LootItemStack;
import chylex.hee.world.loot.WeightedLootList;
import chylex.hee.world.structure.island.biome.feature.AbstractIslandStructure;
import chylex.hee.world.structure.util.pregen.ITileEntityGenerator;
import chylex.hee.world.util.Direction;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;

public class StructureHiddenCellar
extends AbstractIslandStructure
implements ITileEntityGenerator {
    private static final byte[] horCheckX = new byte[]{-1, 0, 1, -1, 1, -1, 0, 1};
    private static final byte[] horCheckZ = new byte[]{-1, -1, -1, 0, 0, 1, 1, 1};
    private static final Block[] endermanSolidBlocks = new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150335_W, Blocks.field_150435_aG, Blocks.field_150423_aK, Blocks.field_150440_ba, Blocks.field_150391_bh};
    private static final WeightedLootList normalChest = new WeightedLootList(new LootItemStack(Items.field_151079_bi).setAmount(2, 6).setWeight(20), new LootItemStack(ItemList.end_powder).setAmount(3, 8).setWeight(20), new LootItemStack(ItemList.stardust).setAmount(4, 10).setWeight(17), new LootItemStack((Block)Blocks.field_150349_c).setAmount(1, 2).setWeight(10), new LootItemStack((Block)Blocks.field_150391_bh).setAmount(1, 2).setWeight(10), new LootItemStack(ItemList.knowledge_note).setWeight(8), new LootItemStack(Blocks.field_150346_d).setAmount(1, 4).setWeight(4), new LootItemStack((Block)Blocks.field_150354_m).setAmount(1, 4).setWeight(4), new LootItemStack(Blocks.field_150351_n).setAmount(1, 4).setWeight(4), new LootItemStack(Blocks.field_150435_aG).setAmount(1, 4).setWeight(4)).addItemPostProcessor(new IItemPostProcessor(){

        @Override
        public ItemStack processItem(ItemStack is, Random rand) {
            if (is.func_77973_b() == ItemList.knowledge_note) {
                ItemKnowledgeNote.setRandomNote(is, rand, 4);
            }
            return is;
        }
    });
    public static final WeightedLootList[] normalChestVariation = new WeightedLootList[]{normalChest.copy().addAll(new LootItemStack[]{new LootItemStack(ItemList.arcane_shard).setAmount(1, 2).setWeight(8)}), normalChest.copy().addAll(new LootItemStack[]{new LootItemStack(ItemList.obsidian_fragment).setAmount(1, 3).setWeight(9), new LootItemStack(ItemList.auricion).setAmount(1, 2).setWeight(6)})};
    private static final WeightedLootList rareChest = new WeightedLootList(new LootItemStack(ItemList.enhanced_ender_pearl).setAmount(3, 9).setWeight(20), new LootItemStack(ItemList.end_powder).setAmount(5, 12).setWeight(12), new LootItemStack(Items.field_151045_i).setAmount(2, 5).setWeight(10), new LootItemStack(ItemList.knowledge_note).setWeight(7), new LootItemStack(Items.field_151079_bi).setAmount(3, 9).setWeight(5), new LootItemStack(ItemList.temple_caller).setWeight(5)).addItemPostProcessor(new IItemPostProcessor(){

        @Override
        public ItemStack processItem(ItemStack is, Random rand) {
            if (is.func_77973_b() == ItemList.knowledge_note) {
                ItemKnowledgeNote.setRandomNote(is, rand, 6);
            } else if (is.func_77973_b() == ItemList.enhanced_ender_pearl) {
                ArrayList<EnderPearlEnhancements> availableTypes = CollectionUtil.newList(EnderPearlEnhancements.values());
                int a = 0;
                while ((long)a < 1L + Math.abs(Math.round(rand.nextDouble() * rand.nextGaussian() * 3.2))) {
                    is = EnhancementHandler.addEnhancement(is, (Enum)availableTypes.remove(rand.nextInt(availableTypes.size())));
                    if (availableTypes.isEmpty()) break;
                    ++a;
                }
            }
            return is;
        }
    });
    public static final WeightedLootList[] rareChestVariation = new WeightedLootList[]{rareChest.copy().addAll(new LootItemStack[0]), rareChest.copy().addAll(new LootItemStack[]{new LootItemStack(ItemList.auricion).setWeight(5)})};
    private EnchantedIslandVariation variation;
    private final List<BlockPosM> patternBlocks = new ArrayList<BlockPosM>();
    private static final WeightedList<ObjectWeightPair<EnumRoomContent>> roomContentList = new WeightedList((IWeightProvider[])new ObjectWeightPair[]{ObjectWeightPair.of(EnumRoomContent.NONE, 55), ObjectWeightPair.of(EnumRoomContent.CONNECTING_LINES, 9), ObjectWeightPair.of(EnumRoomContent.SPIKES, 9), ObjectWeightPair.of(EnumRoomContent.PERSEGRIT_CUBE, 8), ObjectWeightPair.of(EnumRoomContent.LOTS_OF_CHESTS, 7), ObjectWeightPair.of(EnumRoomContent.FLOATING_CUBES, 5), ObjectWeightPair.of(EnumRoomContent.CHEST_PILLARS, 4), ObjectWeightPair.of(EnumRoomContent.CHAOTIC_PERSEGRIT, 4)});

    public void setVariation(EnchantedIslandVariation variation) {
        this.variation = variation;
    }

    @Override
    protected boolean generate(Random rand) {
        this.patternBlocks.clear();
        int height = 4 + rand.nextInt(4);
        for (int attempt = 0; attempt < 50; ++attempt) {
            int x = this.getRandomXZ(rand, 32);
            int y = 10 + rand.nextInt(30);
            int z = this.getRandomXZ(rand, 32);
            RoomInfo info = this.genRoom(x, z, 3 + rand.nextInt(6), y, height, rand);
            if (info == null) continue;
            ArrayList<RoomInfo> rooms = new ArrayList<RoomInfo>();
            rooms.add(info);
            int roomsLeft = 5 + rand.nextInt(16);
            for (int roomAttemptsLeft = 70 + rand.nextInt(110); roomAttemptsLeft > 0 && roomsLeft > 0; --roomAttemptsLeft) {
                int dist;
                RoomInfo newRoom;
                RoomInfo room = (RoomInfo)rooms.get(rand.nextInt(rooms.size()));
                int side = room.getUseableSide(rand);
                if (side == -1) continue;
                int offX = Direction.offsetX[side];
                int offZ = Direction.offsetZ[side];
                int hWidth = 3 + rand.nextInt(6);
                if (hWidth == 3) {
                    hWidth = 2;
                }
                if ((newRoom = this.genRoom(room.x + offX * (dist = room.halfWidth + hWidth + 2 + rand.nextInt(7)), room.z + offZ * dist, hWidth, y, height, rand)) == null) continue;
                room.canUseSide[side] = false;
                newRoom.canUseSide[Direction.rotateOpposite[side]] = false;
                rooms.add(newRoom);
                this.genHall(room.x + (room.halfWidth - 1) * offX - offZ * 2, room.z + (room.halfWidth - 1) * offZ - offX * 2, newRoom.x - (hWidth - 1) * offX + offZ * 2, newRoom.z - (hWidth - 1) * offZ + offX * 2, y, height, rand);
            }
            for (RoomInfo room : rooms) {
                this.genRoomContent(room, y, height, rand);
            }
            this.genPatterns(rand);
            return true;
        }
        return false;
    }

    private RoomInfo genRoom(int x, int z, int halfWidth, int bottomY, int height, Random rand) {
        int halfHeight;
        if (halfWidth == 3) {
            halfWidth = 2;
        }
        if (this.world.getBlock(x, bottomY + (halfHeight = height >> 1) * 2 + 2, z) != Blocks.field_150377_bs) {
            return null;
        }
        for (int horCheck = 0; horCheck < 8; ++horCheck) {
            for (int yCheck = -1; yCheck <= 1; ++yCheck) {
                if (this.world.getBlock(x + horCheckX[horCheck] * halfWidth, bottomY + halfHeight + yCheck * (halfHeight + 1), z + horCheckZ[horCheck] * halfWidth) == Blocks.field_150377_bs) continue;
                return null;
            }
        }
        int x1 = x - halfWidth;
        int z1 = z - halfWidth;
        int x2 = x + halfWidth;
        int z2 = z + halfWidth;
        for (int xx = x1; xx <= x2; ++xx) {
            for (int zz = z1; zz <= z2; ++zz) {
                for (int yy = bottomY; yy <= bottomY + height; ++yy) {
                    boolean edge = xx == x1 || xx == x2 || zz == z1 || zz == z2 || yy == bottomY || yy == bottomY + height;
                    this.world.setBlock(xx, yy, zz, edge ? BlockList.persegrit : Blocks.field_150350_a);
                    if (!edge || rand.nextInt(60) != 0) continue;
                    this.patternBlocks.add(new BlockPosM(xx, yy, zz));
                }
            }
        }
        return new RoomInfo(x, z, halfWidth);
    }

    private void genRoomContent(RoomInfo room, int bottomY, int height, Random rand) {
        int x = room.x;
        int z = room.z;
        byte halfWidth = room.halfWidth;
        if (halfWidth == 2) {
            return;
        }
        EnumRoomContent type = roomContentList.getRandomItem(rand).getObject();
        switch (type) {
            case CONNECTING_LINES: {
                ArrayList<BlockPosM> toPersegrit = new ArrayList<BlockPosM>();
                int width = halfWidth * 2 - 2;
                int addX = 0;
                int addY = 0;
                int addZ = 0;
                block9: for (int lines = 3 + (halfWidth * (height - 2) >> 1) + rand.nextInt(6 + halfWidth * 2 + height); lines > 0; --lines) {
                    int dir = rand.nextInt(4);
                    addZ = 0;
                    addY = 0;
                    addX = 0;
                    if (dir == 0) {
                        addX = rand.nextBoolean() ? -1 : 1;
                    } else if (dir == 1) {
                        addZ = rand.nextBoolean() ? -1 : 1;
                    } else {
                        addY = rand.nextBoolean() ? -1 : 1;
                    }
                    for (int a = 0; a < 10; ++a) {
                        int b;
                        int zz;
                        int yy;
                        int xx = x + rand.nextInt(width) - (width >> 1);
                        if (this.world.getBlock(xx - 1, yy = bottomY + 1 + rand.nextInt(height - 1), zz = z + rand.nextInt(width) - (width >> 1)) == Blocks.field_150357_h || this.world.getBlock(xx + 1, yy, zz) == Blocks.field_150357_h || this.world.getBlock(xx, yy - 1, zz) == Blocks.field_150357_h || this.world.getBlock(xx, yy + 1, zz) == Blocks.field_150357_h || this.world.getBlock(xx, yy, zz - 1) == Blocks.field_150357_h || this.world.getBlock(xx, yy, zz + 1) == Blocks.field_150357_h || !this.world.isAir(xx, yy, zz)) continue;
                        boolean found = false;
                        for (b = 0; b <= width + 2; ++b) {
                            if (this.world.getBlock(xx -= addX, yy -= addY, zz -= addZ) != BlockList.persegrit) continue;
                            if (Math.abs(xx - x) > halfWidth || Math.abs(zz - z) > halfWidth) break;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        found = false;
                        for (b = 0; b <= width + 2; ++b) {
                            if (this.world.getBlock(xx += addX, yy += addY, zz += addZ) != BlockList.persegrit) continue;
                            if (Math.abs(xx - x) > halfWidth || Math.abs(zz - z) > halfWidth) break;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        for (b = 0; b <= width + 2 && this.world.getBlock(xx -= addX, yy -= addY, zz -= addZ) != BlockList.persegrit; ++b) {
                            this.world.setBlock(xx, yy, zz, Blocks.field_150357_h);
                            toPersegrit.add(new BlockPosM(xx, yy, zz));
                        }
                        continue block9;
                    }
                }
                for (BlockPosM loc : toPersegrit) {
                    this.world.setBlock(loc.x, loc.y, loc.z, BlockList.persegrit);
                    if (rand.nextInt(60) != 0) continue;
                    this.patternBlocks.add(loc);
                }
                break;
            }
            case SPIKES: {
                int width = halfWidth * 2 - 2;
                for (int spikes = 2 + halfWidth + rand.nextInt(4 + 3 * halfWidth); spikes > 0; --spikes) {
                    int zz;
                    int yy;
                    int xx = x + rand.nextInt(width) - (width >> 1);
                    if (!this.world.isAir(xx, yy = bottomY + (rand.nextBoolean() ? 1 : height - 1), zz = z + rand.nextInt(width) - (width >> 1))) continue;
                    int addY = yy == bottomY + 1 ? 1 : -1;
                    for (int spikeHeight = 1 + rand.nextInt(height - 3); !(spikeHeight <= 0 || xx != x - (halfWidth - 1) && !this.world.isAir(xx - 1, yy + addY, zz) || xx != x - (halfWidth + 1) && !this.world.isAir(xx + 1, yy + addY, zz) || zz != z - (halfWidth - 1) && !this.world.isAir(xx, yy + addY, zz - 1) || zz != z - (halfWidth - 1) && !this.world.isAir(xx, yy + addY, zz + 1) || !this.world.isAir(xx, yy + addY, zz)); --spikeHeight) {
                        this.world.setBlock(xx, yy, zz, BlockList.persegrit);
                        yy += addY;
                    }
                }
                break;
            }
            case PERSEGRIT_CUBE: {
                int cubeHalfWidth = Math.max(1, halfWidth - 3 - rand.nextInt(2));
                for (int yy = bottomY + 1; yy <= bottomY + height - 1; ++yy) {
                    for (int a = -cubeHalfWidth; a <= cubeHalfWidth; ++a) {
                        this.world.setBlock(x + a, yy, z - cubeHalfWidth, BlockList.persegrit);
                        if (rand.nextInt(60) == 0) {
                            this.patternBlocks.add(new BlockPosM(x + a, yy, z - cubeHalfWidth));
                        }
                        this.world.setBlock(x + a, yy, z + cubeHalfWidth, BlockList.persegrit);
                        if (rand.nextInt(60) == 0) {
                            this.patternBlocks.add(new BlockPosM(x + a, yy, z + cubeHalfWidth));
                        }
                        this.world.setBlock(x - cubeHalfWidth, yy, z + a, BlockList.persegrit);
                        if (rand.nextInt(60) == 0) {
                            this.patternBlocks.add(new BlockPosM(x - cubeHalfWidth, yy, z + a));
                        }
                        this.world.setBlock(x + cubeHalfWidth, yy, z + a, BlockList.persegrit);
                        if (rand.nextInt(60) != 0) continue;
                        this.patternBlocks.add(new BlockPosM(x + cubeHalfWidth, yy, z + a));
                    }
                }
                break;
            }
            case LOTS_OF_CHESTS: {
                int width = halfWidth * 2 - 2;
                block19: for (int chests = 10 + rand.nextInt(8 + 3 * halfWidth) + 4 * halfWidth; chests > 0; --chests) {
                    for (int attempt = 0; attempt < 4; ++attempt) {
                        int zz;
                        int yy;
                        int xx = x + rand.nextInt(width) - (width >> 1);
                        if (!this.world.isAir(xx, yy = bottomY + 1, zz = z + rand.nextInt(width) - (width >> 1))) {
                            for (int yTest = 0; yTest < height - 3 && !this.world.isAir(xx, ++yy, zz); ++yTest) {
                            }
                            if (!this.world.isAir(xx, yy, zz)) continue;
                        }
                        int normal = 0;
                        int trapped = 0;
                        for (int dir = 0; dir < 4; ++dir) {
                            Block block = this.world.getBlock(xx + Direction.offsetX[dir], yy, zz + Direction.offsetZ[dir]);
                            if (block == Blocks.field_150486_ae) {
                                ++normal;
                                continue;
                            }
                            if (block != Blocks.field_150447_bR) continue;
                            ++trapped;
                        }
                        if (normal == 0 && trapped == 0) {
                            this.world.setBlock(xx, yy, zz, (Block)(rand.nextBoolean() ? Blocks.field_150486_ae : Blocks.field_150447_bR), rand.nextInt(4));
                        } else if (normal == 1 && trapped == 0) {
                            this.world.setBlock(xx, yy, zz, Blocks.field_150447_bR, rand.nextInt(4));
                        } else {
                            if (normal != 0 || trapped != true) continue;
                            this.world.setBlock(xx, yy, zz, (Block)Blocks.field_150486_ae, rand.nextInt(4));
                        }
                        if (rand.nextInt(10) != 0) continue block19;
                        if (rand.nextInt(6) == 0) {
                            this.world.setTileEntityGenerator(xx, yy, zz, "CellarChestRare|" + this.variation.ordinal(), this);
                            continue block19;
                        }
                        this.world.setTileEntityGenerator(xx, yy, zz, "CellarChestNormal|" + this.variation.ordinal(), this);
                        continue block19;
                    }
                }
                break;
            }
            case FLOATING_CUBES: {
                block23: for (int cubes = 5 + rand.nextInt(10); cubes > 0; --cubes) {
                    int ySpace;
                    Block randBlock = endermanSolidBlocks[rand.nextInt(endermanSolidBlocks.length)];
                    int size = 1 + rand.nextInt(3 + rand.nextInt(2));
                    int xzSpace = halfWidth * 2 - size;
                    if (xzSpace < 1 || (ySpace = height - size) < 1) continue;
                    for (int attempt = 0; attempt < 20; ++attempt) {
                        int pz;
                        int py;
                        int px;
                        int xx = x - halfWidth + 1 + rand.nextInt(xzSpace);
                        int yy = bottomY + 1 + rand.nextInt(ySpace);
                        int zz = z - halfWidth + 1 + rand.nextInt(xzSpace);
                        boolean canGenerate = true;
                        for (px = xx - 1; px <= xx + size; ++px) {
                            for (py = yy - 1; py <= yy + size; ++py) {
                                for (pz = zz - 1; pz <= zz + size; ++pz) {
                                    Block block = this.world.getBlock(px, py, pz);
                                    if (block == Blocks.field_150350_a || block == BlockList.persegrit) continue;
                                    canGenerate = false;
                                    px += 99;
                                    py += 99;
                                    pz += 99;
                                }
                            }
                        }
                        if (!canGenerate) continue;
                        for (px = xx; px < xx + size; ++px) {
                            for (py = yy; py < yy + size; ++py) {
                                for (pz = zz; pz < zz + size; ++pz) {
                                    this.world.setBlock(px, py, pz, randBlock);
                                }
                            }
                        }
                        continue block23;
                    }
                }
                break;
            }
            case CHEST_PILLARS: {
                for (int amount = 2 + room.halfWidth * (room.halfWidth - 2) + rand.nextInt(5 + room.halfWidth * 3); amount > 0; --amount) {
                    int xx = x - halfWidth + 1 + rand.nextInt(halfWidth * 2 - 2);
                    int zz = z - halfWidth + 1 + rand.nextInt(halfWidth * 2 - 2);
                    int yy = bottomY + 2 + rand.nextInt(height - 3);
                    if (!this.world.isAir(xx - 1, bottomY + 1, zz) || !this.world.isAir(xx + 1, bottomY + 1, zz) || !this.world.isAir(xx, bottomY + 1, zz - 1) || !this.world.isAir(xx, bottomY + 1, zz + 1)) continue;
                    this.world.setBlock(xx, yy, zz, (Block)Blocks.field_150486_ae);
                    if (rand.nextInt(5) <= 1) {
                        this.world.setTileEntityGenerator(xx, yy, zz, (rand.nextInt(4) == 0 ? "CellarChestRare" : "CellarChestNormal") + "|" + this.variation.ordinal(), this);
                    }
                    --yy;
                    while (yy >= bottomY + 1) {
                        this.world.setBlock(xx, yy, zz, BlockList.persegrit);
                        --yy;
                    }
                }
                break;
            }
            case CHAOTIC_PERSEGRIT: {
                int width = halfWidth * 2 - 2;
                for (int amount = MathUtil.ceil(Math.sqrt(room.halfWidth * room.halfWidth * (height - 1)) * (0.85 + rand.nextDouble() * 0.5)); amount > 0; --amount) {
                    this.world.setBlock(x + rand.nextInt(width) - (width >> 1), bottomY + 1 + rand.nextInt(height - 1), z + rand.nextInt(width) - (width >> 1), BlockList.persegrit);
                }
                break;
            }
        }
    }

    private void genHall(int x1, int z1, int x2, int z2, int bottomY, int height, Random rand) {
        int xMax = Math.max(x1, x2);
        for (int xx = Math.min(x1, x2); xx <= xMax; ++xx) {
            int zMax = Math.max(z1, z2);
            for (int zz = Math.min(z1, z2); zz <= zMax; ++zz) {
                for (int yy = bottomY; yy <= bottomY + height; ++yy) {
                    boolean edge;
                    boolean bl = edge = xx == x1 || xx == x2 || zz == z1 || zz == z2 || yy == bottomY || yy == bottomY + height;
                    if (edge && this.world.getBlock(xx, yy, zz) == Blocks.field_150350_a) continue;
                    this.world.setBlock(xx, yy, zz, edge ? BlockList.persegrit : Blocks.field_150350_a);
                    if (!edge || rand.nextInt(60) != 0) continue;
                    this.patternBlocks.add(new BlockPosM(xx, yy, zz));
                }
            }
        }
    }

    private void genPatterns(Random rand) {
        ArrayList<BlockPosM> connections = new ArrayList<BlockPosM>();
        block0: for (BlockPosM loc : this.patternBlocks) {
            int x = loc.x;
            int y = loc.y;
            int z = loc.z;
            int addX = 0;
            int addY = 0;
            int addZ = 0;
            int iterations = 6 + rand.nextInt(30 + rand.nextInt(60));
            if (!this.isWall(x, y, z)) {
                if (rand.nextBoolean()) {
                    addX = rand.nextInt(2) * 2 - 1;
                } else {
                    addZ = rand.nextInt(2) * 2 - 1;
                }
            } else if (this.world.getBlock(x - 1, y, z) != BlockList.persegrit || this.world.getBlock(x + 1, y, z) != BlockList.persegrit) {
                if (rand.nextInt(3) != 0) {
                    addY = rand.nextInt(2) * 2 - 1;
                } else {
                    addZ = rand.nextInt(2) * 2 - 1;
                }
            } else if (this.world.getBlock(x, y, z - 1) != BlockList.persegrit || this.world.getBlock(x, y, z + 1) != BlockList.persegrit) {
                if (rand.nextInt(3) != 0) {
                    addY = rand.nextInt(2) * 2 - 1;
                } else {
                    addX = rand.nextInt(2) * 2 - 1;
                }
            }
            for (int iteration = 0; iteration <= iterations; ++iteration) {
                if (this.isCorner(x += addX, y += addY, z += addZ)) {
                    if (addX != 0) {
                        addZ = this.world.getBlock(x, y, z - 1) == BlockList.persegrit ? -1 : 1;
                        addX = 0;
                    } else if (addZ != 0) {
                        addX = this.world.getBlock(x - 1, y, z) == BlockList.persegrit ? -1 : 1;
                        addZ = 0;
                    }
                } else if (rand.nextInt(12) == 0) {
                    int newAddX = 0;
                    int newAddY = 0;
                    int newAddZ = 0;
                    if (!this.isWall(x, y, z)) {
                        if (rand.nextBoolean()) {
                            newAddX = rand.nextBoolean() ? -1 : 1;
                        } else {
                            newAddZ = rand.nextBoolean() ? -1 : 1;
                        }
                    } else if (this.world.getBlock(x - 1, y, z) != BlockList.persegrit || this.world.getBlock(x + 1, y, z) != BlockList.persegrit) {
                        if (rand.nextBoolean()) {
                            newAddY = rand.nextInt(2) * 2 - 1;
                        } else {
                            newAddZ = rand.nextInt(2) * 2 - 1;
                        }
                    } else if (this.world.getBlock(x, y, z - 1) != BlockList.persegrit || this.world.getBlock(x, y, z + 1) != BlockList.persegrit) {
                        if (rand.nextBoolean()) {
                            newAddX = rand.nextInt(2) * 2 - 1;
                        } else {
                            newAddY = rand.nextInt(2) * 2 - 1;
                        }
                    }
                    if (!this.isCorner(x + newAddX, y + newAddY, z + newAddZ)) {
                        addX = newAddX;
                        addY = newAddY;
                        addZ = newAddZ;
                    }
                }
                if (this.world.getBlock(x, y, z) != BlockList.persegrit) continue block0;
                this.world.setBlock(x, y, z, BlockList.persegrit, 15);
                connections.add(new BlockPosM(x, y, z));
            }
        }
        for (BlockPosM loc : connections) {
            this.world.setBlock(loc.x, loc.y, loc.z, BlockList.persegrit, BlockPersegrit.getConnectionMeta(this.world, rand, loc.x, loc.y, loc.z));
        }
    }

    private boolean isCorner(int x, int y, int z) {
        Block pg = BlockList.persegrit;
        Block l = this.world.getBlock(x - 1, y, z);
        Block r = this.world.getBlock(x + 1, y, z);
        Block u = this.world.getBlock(x, y, z - 1);
        Block d = this.world.getBlock(x, y, z + 1);
        Block b = this.world.getBlock(x, y - 1, z);
        Block t = this.world.getBlock(x, y + 1, z);
        return (l == pg && r == pg || u == pg && d == pg) && (b == pg && t != pg || b != pg && t == pg) || t == pg && b == pg && (l == pg && r != pg || u == pg && d != pg || l != pg && r == pg || u != pg && d == pg);
    }

    private boolean isWall(int x, int y, int z) {
        return this.world.getBlock(x, y - 1, z) == BlockList.persegrit || this.world.getBlock(x, y + 1, z) == BlockList.persegrit;
    }

    @Override
    public void onTileEntityRequested(String key, TileEntity tile, Random rand) {
        block3: {
            block2: {
                if (!key.startsWith("CellarChestNormal|")) break block2;
                WeightedLootList loot = normalChestVariation[DragonUtil.tryParse(key.split("\\|")[1], 0)];
                TileEntityChest chest = (TileEntityChest)tile;
                for (int amount = 0; amount < 1 + rand.nextInt(4 + rand.nextInt(3)); ++amount) {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), loot.generateIS(rand));
                }
                break block3;
            }
            if (!key.startsWith("CellarChestRare|")) break block3;
            WeightedLootList loot = rareChestVariation[DragonUtil.tryParse(key.split("\\|")[1], 0)];
            TileEntityChest chest = (TileEntityChest)tile;
            for (int amount = 0; amount < 3 + rand.nextInt(6); ++amount) {
                chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), loot.generateIS(rand));
            }
        }
    }

    public static enum EnchantedIslandVariation {
        HOMELAND,
        LABORATORY;

    }

    private final class RoomInfo {
        final int x;
        final int z;
        final byte halfWidth;
        final boolean[] canUseSide = new boolean[]{true, true, true, true};

        RoomInfo(int x, int z, int halfWidth) {
            this.x = x;
            this.z = z;
            this.halfWidth = (byte)halfWidth;
        }

        int getUseableSide(Random rand) {
            if (!(this.canUseSide[0] || this.canUseSide[1] || this.canUseSide[2] || this.canUseSide[3])) {
                return -1;
            }
            for (int attempt = 0; attempt < 8; ++attempt) {
                int side = rand.nextInt(4);
                if (!this.canUseSide[side]) continue;
                return side;
            }
            for (int side = 0; side < 4; ++side) {
                if (!this.canUseSide[side]) continue;
                return side;
            }
            return -1;
        }
    }

    private static enum EnumRoomContent {
        NONE,
        CONNECTING_LINES,
        SPIKES,
        PERSEGRIT_CUBE,
        LOTS_OF_CHESTS,
        FLOATING_CUBES,
        CHAOTIC_PERSEGRIT,
        CHEST_PILLARS;

    }
}

