/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.gui.helpers;

public final class AnimatedFloat {
    private final Easing easing;
    private float time;
    private float startValue;
    private float endValue;
    private float duration;
    private float currentValue;
    private boolean isAnimating;

    public AnimatedFloat(Easing easing) {
        this.easing = easing;
        this.isAnimating = false;
    }

    public void startAnimation(float startValue, float endValue) {
        this.startAnimation(startValue, endValue, 1.0f);
    }

    public void startAnimation(float startValue, float endValue, float duration) {
        if (this.isAnimating) {
            return;
        }
        this.time = 0.0f;
        this.startValue = this.currentValue = startValue;
        this.endValue = endValue;
        this.duration = duration;
        this.isAnimating = true;
    }

    public void update(float timeAdd) {
        float f;
        if (!this.isAnimating) {
            return;
        }
        this.time += timeAdd / this.duration;
        if (f > 1.0f) {
            this.time = 1.0f;
            this.isAnimating = false;
        }
        this.currentValue = this.easing.getValue(this.time, this.startValue, this.endValue - this.startValue);
    }

    public void finish() {
        if (this.isAnimating) {
            this.isAnimating = false;
            this.currentValue = this.endValue;
        }
    }

    public void set(float newValue) {
        if (this.isAnimating) {
            this.isAnimating = false;
        }
        this.currentValue = newValue;
    }

    public boolean isAnimating() {
        return this.isAnimating;
    }

    public float value() {
        return this.currentValue;
    }

    public static enum Easing {
        LINEAR,
        CUBIC;


        public float getValue(float time, float startValue, float fullStep) {
            switch (this) {
                case CUBIC: {
                    float f;
                    time *= 2.0f;
                    if (f < 1.0f) {
                        return fullStep / 2.0f * time * time * time + startValue;
                    }
                    return fullStep / 2.0f * ((time -= 2.0f) * time * time + 2.0f) + startValue;
                }
            }
            return startValue + fullStep * time;
        }
    }
}

