/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.common.gui.rendering;

import elan.tweaks.common.ext.TesselatorExtKt;
import elan.tweaks.common.gui.dto.Rgba;
import elan.tweaks.common.gui.dto.Vector3D;
import elan.tweaks.common.gui.textures.TextureInstance;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0014\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lelan/tweaks/common/gui/rendering/TextureRenderer;", "", "<init>", "()V", "textureManager", "Lnet/minecraft/client/renderer/texture/TextureManager;", "kotlin.jvm.PlatformType", "getTextureManager", "()Lnet/minecraft/client/renderer/texture/TextureManager;", "textureManager$delegate", "Lkotlin/Lazy;", "drawBlending", "", "texture", "Lelan/tweaks/common/gui/textures/TextureInstance;", "origin", "Lelan/tweaks/common/gui/dto/Vector3D;", "colorMask", "Lelan/tweaks/common/gui/dto/Rgba;", "bindAndDraw", "tessellate", "position", "ThaumcraftResearchTweaks"})
public final class TextureRenderer {
    @NotNull
    public static final TextureRenderer INSTANCE = new TextureRenderer();
    @NotNull
    private static final Lazy textureManager$delegate = LazyKt.lazy(TextureRenderer::textureManager_delegate$lambda$0);

    private TextureRenderer() {
    }

    private final TextureManager getTextureManager() {
        Lazy lazy = textureManager$delegate;
        return (TextureManager)lazy.getValue();
    }

    public final void drawBlending(@NotNull TextureInstance texture, @NotNull Vector3D origin, @NotNull Rgba colorMask) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)colorMask, (String)"colorMask");
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)colorMask.getR(), (float)colorMask.getG(), (float)colorMask.getB(), (float)colorMask.getA());
        this.bindAndDraw(texture, origin, colorMask);
        GL11.glPopMatrix();
    }

    public static /* synthetic */ void drawBlending$default(TextureRenderer textureRenderer, TextureInstance textureInstance, Vector3D vector3D, Rgba rgba, int n, Object object) {
        if ((n & 4) != 0) {
            rgba = new Rgba(1.0f, 1.0f, 1.0f, 1.0f);
        }
        textureRenderer.drawBlending(textureInstance, vector3D, rgba);
    }

    private final void bindAndDraw(TextureInstance $this$bindAndDraw, Vector3D origin, Rgba colorMask) {
        this.getTextureManager().func_110577_a($this$bindAndDraw.getResourceLocation());
        $this$bindAndDraw.beforeGL();
        this.tessellate($this$bindAndDraw, origin, colorMask);
        $this$bindAndDraw.afterGL();
    }

    private final void tessellate(TextureInstance $this$tessellate, Vector3D position, Rgba colorMask) {
        double portionXFactor = 1.0 / (double)$this$tessellate.getTextureScale().getWidth();
        double portionYFactor = 1.0 / (double)$this$tessellate.getTextureScale().getHeight();
        Tessellator tessellator = Tessellator.field_78398_a;
        Intrinsics.checkNotNullExpressionValue((Object)tessellator, (String)"instance");
        TesselatorExtKt.drawQuads(tessellator, (Function1<? super Tessellator, Unit>)((Function1)arg_0 -> TextureRenderer.tessellate$lambda$1($this$tessellate, colorMask, position, portionXFactor, portionYFactor, arg_0)));
    }

    private static final TextureManager textureManager_delegate$lambda$0() {
        return Minecraft.func_71410_x().func_110434_K();
    }

    private static final Unit tessellate$lambda$1(TextureInstance $this_tessellate, Rgba $colorMask, Vector3D $position, double $portionXFactor, double $portionYFactor, Tessellator $this$drawQuads) {
        Intrinsics.checkNotNullParameter((Object)$this$drawQuads, (String)"$this$drawQuads");
        $this_tessellate.before($this$drawQuads);
        $this$drawQuads.func_78369_a($colorMask.getR(), $colorMask.getG(), $colorMask.getB(), $colorMask.getA());
        $this$drawQuads.func_78374_a((double)$position.getX(), (double)$position.getY(), $position.getZ(), (double)$this_tessellate.getUv().getU() * $portionXFactor, (double)$this_tessellate.getUv().getV() * $portionYFactor);
        $this$drawQuads.func_78374_a((double)$position.getX(), (double)($position.getY() + $this_tessellate.getScale().getHeight()), $position.getZ(), (double)$this_tessellate.getUv().getU() * $portionXFactor, (double)($this_tessellate.getUv().getV() + $this_tessellate.getUvScale().getHeight()) * $portionYFactor);
        $this$drawQuads.func_78374_a((double)($position.getX() + $this_tessellate.getScale().getWidth()), (double)($position.getY() + $this_tessellate.getScale().getHeight()), $position.getZ(), (double)($this_tessellate.getUv().getU() + $this_tessellate.getUvScale().getWidth()) * $portionXFactor, (double)($this_tessellate.getUv().getV() + $this_tessellate.getUvScale().getHeight()) * $portionYFactor);
        $this$drawQuads.func_78374_a((double)($position.getX() + $this_tessellate.getScale().getWidth()), (double)$position.getY(), $position.getZ(), (double)($this_tessellate.getUv().getU() + $this_tessellate.getUvScale().getWidth()) * $portionXFactor, (double)$this_tessellate.getUv().getV() * $portionYFactor);
        return Unit.INSTANCE;
    }
}

