/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.nativeutil;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class NativeUtil {
    private static final Logger LOGGER = Logger.getLogger(NativeUtil.class.getName());
    public static final String NATIVE_FOLDER_PATH_PREFIX = "com-weisj-darklaf-nativeutils";
    private static final int MIN_PREFIX_LENGTH = 3;
    private static Path temporaryDir;

    private NativeUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJarWithExtraResources(Class<?> loaderClass, String path, List<Resource> resources, String identifier) throws IOException {
        String libraryIdentifier = NativeUtil.getFullLibraryIdentifier(identifier);
        Path tempDir = NativeUtil.getTemporaryDirectory(libraryIdentifier);
        List<Path> resourcePaths = NativeUtil.extractResources(loaderClass, resources, tempDir);
        try {
            NativeUtil.doLoadLibraryFromJar(loaderClass, path, identifier, tempDir);
        }
        finally {
            resourcePaths.forEach(NativeUtil::releaseResource);
        }
    }

    private static List<Path> extractResources(Class<?> caller, List<Resource> resources, Path tempDir) throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>(resources.size());
        for (Resource resource : resources) {
            String filename = NativeUtil.getFileNameFromPath(resource.filePath);
            Path destinationDir = tempDir.resolve(resource.destinationDirectoryPath);
            Path destinationPath = destinationDir.resolve(Objects.requireNonNull(filename));
            try {
                Files.createDirectories(destinationDir, new FileAttribute[0]);
                NativeUtil.extractFile(caller, resource.filePath, tempDir, destinationPath);
            }
            catch (IOException e) {
                paths.forEach(NativeUtil::delete);
                throw e;
            }
            paths.add(tempDir.resolve(Objects.requireNonNull(filename)));
        }
        return paths;
    }

    public static void loadLibraryFromJar(Class<?> loaderClass, String path, String identifier) throws IOException {
        String libraryIdentifier = NativeUtil.getFullLibraryIdentifier(identifier);
        Path tempDir = NativeUtil.getTemporaryDirectory(libraryIdentifier);
        NativeUtil.doLoadLibraryFromJar(loaderClass, path, identifier, tempDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doLoadLibraryFromJar(Class<?> loaderClass, String path, String identifier, Path tempDir) throws IOException {
        String filename = NativeUtil.getFileNameFromPath(path);
        if (filename == null || filename.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        String libraryIdentifier = NativeUtil.getFullLibraryIdentifier(identifier);
        Path temp = tempDir.resolve(filename);
        if (!NativeUtil.isPosixCompliant()) {
            NativeUtil.deleteLeftoverTempFiles(tempDir, libraryIdentifier);
        }
        NativeUtil.extractFile(loaderClass, path, tempDir, temp);
        try {
            System.load(temp.toAbsolutePath().toString());
        }
        finally {
            NativeUtil.releaseResource(temp);
        }
    }

    private static void extractFile(Class<?> loaderClass, String path, Path destinationDir, Path destinationPath) throws IOException {
        try (InputStream is = loaderClass.getResourceAsStream(path);){
            if (is == null) {
                throw new FileNotFoundException("File " + path + " was not found inside JAR.");
            }
            if (!destinationDir.toFile().canWrite()) {
                throw new IOException("Can't write to temporary directory.");
            }
            if (!Files.exists(destinationPath, new LinkOption[0])) {
                Files.copy(is, destinationPath.toAbsolutePath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            NativeUtil.delete(destinationPath);
            throw e;
        }
    }

    private static void deleteLeftoverTempFiles(Path tempDir, String identifier) throws IOException {
        try (Stream<Path> files = Files.list(tempDir.getParent());){
            files.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> !tempDir.equals(p)).filter(p -> p.getFileName().toString().startsWith(identifier)).forEach(NativeUtil::deleteFolder);
        }
    }

    private static void deleteFolder(Path folder) {
        LOGGER.fine("Removing " + folder);
        try (Stream<Path> walk = Files.walk(folder, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).forEach(NativeUtil::delete);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not delete directory", e);
        }
    }

    private static String getFileNameFromPath(String path) {
        NativeUtil.checkPath(path);
        String[] parts = path.split("/");
        return parts.length > 1 ? parts[parts.length - 1] : null;
    }

    private static void checkPath(String path) {
        if (null == path || !path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
    }

    private static String getFullLibraryIdentifier(String identifier) {
        return "com-weisj-darklaf-nativeutils-" + identifier;
    }

    private static Path getTemporaryDirectory(String libraryIdentifier) throws IOException {
        if (temporaryDir == null) {
            temporaryDir = NativeUtil.createTempDirectory(libraryIdentifier);
            temporaryDir.toFile().deleteOnExit();
        }
        return temporaryDir;
    }

    private static void releaseResource(Path path) {
        if (NativeUtil.isPosixCompliant()) {
            NativeUtil.delete(path);
        } else {
            path.toFile().deleteOnExit();
        }
    }

    private static void delete(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Couldn't delete file " + path, e);
        }
    }

    private static Path createTempDirectory(String prefix) throws IOException {
        return Files.createTempDirectory(prefix + System.nanoTime(), new FileAttribute[0]);
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }

    public static class Resource {
        public final String filePath;
        public final String destinationDirectoryPath;

        public Resource(String filePath, String destinationDirectoryPath) {
            this.filePath = filePath;
            this.destinationDirectoryPath = destinationDirectoryPath;
        }
    }
}

