/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.loading;

import com.github.weisj.darklaf.components.RotatableIconAnimator;
import com.github.weisj.darklaf.properties.icons.EmptyIcon;
import com.github.weisj.darklaf.properties.icons.RotatableIcon;
import com.github.weisj.darklaf.properties.icons.TwoIcon;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class LoadingIndicator
extends JLabel {
    private final RotatableIcon loadIcon = new RotatableIcon(UIManager.getIcon("LoadIndicator.stepWorkingIcon"));
    private final Icon pausedIcon = UIManager.getIcon("LoadIndicator.stepPassiveIcon");
    private final Icon emptyIcon = EmptyIcon.create(this.loadIcon);
    private final TwoIcon displayIcon = new TwoIcon(this.loadIcon, null);
    private final RotatableIconAnimator animator = new RotatableIconAnimator(8, this.loadIcon, this);
    private boolean running;

    public LoadingIndicator(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.displayIcon.setIconGap(this.getIconTextGap());
    }

    public LoadingIndicator(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public LoadingIndicator(String text) {
        this(text, null, 10);
    }

    public LoadingIndicator(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public LoadingIndicator(Icon image) {
        this(null, image, 0);
    }

    public LoadingIndicator() {
        this("", null, 10);
    }

    public void setRunning(boolean running) {
        this.running = running;
        this.setAnimatorState(running);
    }

    private void setAnimatorState(boolean running) {
        if (running == this.animator.isRunning()) {
            return;
        }
        if (running) {
            this.animator.resume();
        } else {
            this.animator.suspend();
        }
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setAnimatorState(this.isRunning());
    }

    public boolean isRunning() {
        return this.running && this.isEnabled();
    }

    @Override
    public void setIconTextGap(int iconTextGap) {
        super.setIconTextGap(iconTextGap);
        this.displayIcon.setIconGap(this.getIconTextGap());
    }

    @Override
    public Icon getIcon() {
        this.displayIcon.setLeftIcon(this.running ? this.loadIcon : this.pausedIcon);
        this.displayIcon.setRightIcon(super.getIcon());
        return this.displayIcon;
    }

    @Override
    public Icon getDisabledIcon() {
        this.displayIcon.setLeftIcon(this.emptyIcon);
        this.displayIcon.setRightIcon(super.getDisabledIcon());
        return this.displayIcon;
    }
}

