/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import com.mitchej123.hodgepodge.core.HodgepodgeCore;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;

public class FileLogger
implements AutoCloseable {
    private final SimpleDateFormat dateFormat;
    private PrintStream printStream = null;

    public FileLogger(String filename) {
        this(HodgepodgeCore.getMcLocation(), filename);
    }

    public FileLogger(File logFolder, String filename) {
        this(logFolder, filename, null);
    }

    public FileLogger(File logFolder, String filename, String timeFormat) {
        this.dateFormat = timeFormat == null ? null : new SimpleDateFormat(timeFormat);
        if (logFolder == null) {
            throw new IllegalStateException("FileLogger logFolder cannot be null!");
        }
        if (filename == null) {
            throw new IllegalStateException("FileLogger file name cannot be null!");
        }
        logFolder.mkdirs();
        File logFile = new File(logFolder, filename);
        if (logFile.exists()) {
            logFile.delete();
        }
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.printStream = new PrintStream(new FileOutputStream(logFile, true));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void log(String message) {
        if (this.printStream == null) {
            return;
        }
        if (this.dateFormat == null) {
            this.printStream.println(message);
            return;
        }
        String time = this.dateFormat.format(System.currentTimeMillis());
        this.printStream.println("[" + time + "] " + message);
    }

    public void printStackTrace() {
        if (this.printStream == null) {
            return;
        }
        new Exception().printStackTrace(this.printStream);
    }

    @Override
    public void close() {
        if (this.printStream == null) {
            return;
        }
        this.printStream.close();
    }
}

