/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap.plugin;

import com.gtnewhorizons.retrofuturabootstrap.Main;
import com.gtnewhorizons.retrofuturabootstrap.algorithm.StableTopologicalSort;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbPluginMetadata;
import com.gtnewhorizons.retrofuturabootstrap.versioning.ArtifactVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.VisibleForTesting;

public class PluginSorter {
    protected final List<RfbPluginMetadata> plugins = new ArrayList<RfbPluginMetadata>();
    protected final Set<RfbPluginMetadata> duplicateDisables = Collections.newSetFromMap(new IdentityHashMap());
    protected boolean criticalIssuesFound = false;

    public PluginSorter(List<RfbPluginMetadata> metadata) {
        this.plugins.addAll(metadata);
        this.plugins.sort(RfbPluginMetadata.ID_AND_PIN_COMPARATOR);
    }

    public Optional<List<RfbPluginMetadata>> resolve() {
        this.handleDuplicates();
        this.handleLoadRelations();
        return this.criticalIssuesFound ? Optional.empty() : Optional.of(this.plugins);
    }

    @VisibleForTesting
    public void handleDuplicates() {
        HashMap<String, List> idLookup = new HashMap<String, List>(this.plugins.size());
        for (RfbPluginMetadata rfbPluginMetadata : this.plugins) {
            idLookup.computeIfAbsent(rfbPluginMetadata.id(), _id -> new ArrayList(1)).add(rfbPluginMetadata);
            for (RfbPluginMetadata.IdAndVersion additionalId : rfbPluginMetadata.additionalVersions()) {
                idLookup.computeIfAbsent(additionalId.id(), _id -> new ArrayList(2)).add(rfbPluginMetadata);
            }
        }
        for (Map.Entry entry : idLookup.entrySet()) {
            String id = (String)entry.getKey();
            List equalIdPlugins = (List)entry.getValue();
            if (equalIdPlugins.size() < 2) continue;
            RfbPluginMetadata newest = null;
            ArtifactVersion newestVersion = null;
            for (RfbPluginMetadata it : equalIdPlugins) {
                if (this.duplicateDisables.contains(it)) continue;
                if (newest == null) {
                    newest = it;
                    newestVersion = Objects.requireNonNull(it.version(id));
                    continue;
                }
                ArtifactVersion itVersion = Objects.requireNonNull(it.version(id));
                if (itVersion.compareTo(newestVersion) > 0) {
                    this.duplicateDisables.add(newest);
                    Main.logger.warn("Duplicate RFB plugin ID `{}` found, disabling `{}@{}` ({}) in favor of `{}@{}` ({})", new Object[]{id, newest.id(), newestVersion, newest.source(), it.id(), itVersion, it.source()});
                    newest = it;
                    newestVersion = itVersion;
                    continue;
                }
                this.duplicateDisables.add(it);
                Main.logger.warn("Duplicate RFB plugin ID `{}` found, disabling `{}@{}` ({}) in favor of `{}@{}` ({})", new Object[]{id, it.id(), itVersion, it.source(), newest.id(), newestVersion, newest.source()});
            }
        }
        this.plugins.removeIf(this.duplicateDisables::contains);
    }

    @VisibleForTesting
    public void handleLoadRelations() {
        HashMap<String, RfbPluginMetadata> pluginsById = new HashMap<String, RfbPluginMetadata>(this.plugins.size());
        HashMap<String, ArtifactVersion> versionsById = new HashMap<String, ArtifactVersion>(this.plugins.size());
        IdentityHashMap<RfbPluginMetadata, Integer> pluginToIndex = new IdentityHashMap<RfbPluginMetadata, Integer>(this.plugins.size());
        for (int index = 0; index < this.plugins.size(); ++index) {
            RfbPluginMetadata plugin = this.plugins.get(index);
            pluginToIndex.put(plugin, index);
            if (pluginsById.put(plugin.id(), plugin) != null) {
                throw new IllegalStateException("Plugins not deduplicated: " + plugin.id());
            }
            versionsById.put(plugin.id(), plugin.version());
            for (RfbPluginMetadata.IdAndVersion additionalId : plugin.additionalVersions()) {
                if (pluginsById.put(additionalId.id(), plugin) != null) {
                    throw new IllegalStateException("Plugins not deduplicated: " + additionalId.id());
                }
                versionsById.put(additionalId.id(), additionalId.version());
            }
        }
        for (RfbPluginMetadata plugin : this.plugins) {
            for (RfbPluginMetadata.IdAndVersionRange constraint : plugin.versionConstraints()) {
                String constraintId = constraint.id();
                ArtifactVersion constraintLoadedVersion = (ArtifactVersion)versionsById.get(constraintId);
                if (constraintLoadedVersion == null || constraint.version().containsVersion(constraintLoadedVersion)) continue;
                RfbPluginMetadata.IdAndVersionRange[] constraintLoaded = (RfbPluginMetadata.IdAndVersionRange[])pluginsById.get(constraintId);
                Main.logger.error("Version requirement not satisfied: `{}` ({}) requires `{}`, but version `{}` ({}) was found", new Object[]{plugin.idAndVersion(), plugin.source(), constraint.version(), constraintLoaded.idAndVersion(), constraintLoaded.source()});
                this.criticalIssuesFound = true;
            }
            for (String required : plugin.loadRequires()) {
                RfbPluginMetadata loaded = (RfbPluginMetadata)pluginsById.get(required);
                if (loaded != null) continue;
                String verReq = "any version";
                for (RfbPluginMetadata.IdAndVersionRange r : plugin.versionConstraints()) {
                    if (!r.id().equals(required)) continue;
                    verReq = r.version().toString();
                }
                Main.logger.error("Requirement not met: `{}` ({}) requires `{}@{}`, but it was not found among enabled plugins.", new Object[]{plugin.idAndVersion(), plugin.source(), required, verReq});
                this.criticalIssuesFound = true;
            }
        }
        if (this.criticalIssuesFound) {
            return;
        }
        ArrayList<List<Integer>> beforeEdges = new ArrayList<List<Integer>>(this.plugins.size());
        for (int i = 0; i < this.plugins.size(); ++i) {
            beforeEdges.add(new ArrayList());
        }
        for (RfbPluginMetadata plugin : this.plugins) {
            int otherIndex;
            RfbPluginMetadata other;
            int myIndex = (Integer)pluginToIndex.get(plugin);
            for (String otherId : plugin.loadBefore()) {
                other = (RfbPluginMetadata)pluginsById.get(otherId);
                if (other == null) continue;
                otherIndex = (Integer)pluginToIndex.get(other);
                ((List)beforeEdges.get(myIndex)).add(otherIndex);
            }
            for (String otherId : plugin.loadAfter()) {
                other = (RfbPluginMetadata)pluginsById.get(otherId);
                if (other == null) continue;
                otherIndex = (Integer)pluginToIndex.get(other);
                ((List)beforeEdges.get(otherIndex)).add(myIndex);
            }
        }
        try {
            List<RfbPluginMetadata> sorted = StableTopologicalSort.sort(this.plugins, beforeEdges);
            this.plugins.clear();
            this.plugins.addAll(sorted);
        }
        catch (StableTopologicalSort.CycleException err) {
            Set<RfbPluginMetadata> cycle = err.cyclicElements(RfbPluginMetadata.class);
            Main.logger.error("Cycle found among the following RFB plugins, aborting launch:");
            for (RfbPluginMetadata plugin : cycle) {
                Main.logger.error("{} ({})", new Object[]{plugin.idAndVersion(), plugin.source()});
            }
            this.criticalIssuesFound = true;
        }
    }
}

