/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.data;

import ca.wescook.nutrition.data.NutrientManager;
import ca.wescook.nutrition.network.Sync;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.proxy.ClientProxy;
import ca.wescook.nutrition.utility.Config;
import ca.wescook.nutrition.utility.Log;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerDataHandler {
    private static final String NBT_NUTRIENT_DATA = "Nutrients";
    private static final Map<EntityPlayer, NutrientManager> MANAGER_STORAGE = new HashMap<EntityPlayer, NutrientManager>();

    public static void saveForPlayer(EntityPlayer player, NBTTagCompound tagCompound) {
        NutrientManager manager = MANAGER_STORAGE.get(player);
        if (manager != null) {
            NBTTagCompound playerData = new NBTTagCompound();
            for (Nutrient nutrient : NutrientList.get()) {
                if (manager.get(nutrient) == null) continue;
                playerData.func_74776_a(nutrient.name, manager.get(nutrient).floatValue());
            }
            tagCompound.func_74782_a(NBT_NUTRIENT_DATA, (NBTBase)playerData);
        }
    }

    public static void initializeForPlayer(EntityPlayer player, NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b(NBT_NUTRIENT_DATA)) {
            NBTTagCompound nutrientTag = tagCompound.func_74775_l(NBT_NUTRIENT_DATA);
            HashMap<Nutrient, Float> playerNutrients = new HashMap<Nutrient, Float>();
            for (Nutrient nutrient : NutrientList.get()) {
                float value = nutrientTag.func_74764_b(nutrient.name) ? nutrientTag.func_74760_g(nutrient.name) : (float)Config.startingNutrition;
                playerNutrients.put(nutrient, Float.valueOf(value));
            }
            MANAGER_STORAGE.put(player, new NutrientManager(playerNutrients));
        }
    }

    public static NutrientManager getForPlayer(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            Log.warn("Tried to access server player data from the client! Attempting to use server player data...");
            return ClientProxy.localNutrition;
        }
        NutrientManager manager = MANAGER_STORAGE.get(player);
        if (manager == null) {
            Log.info("Creating initial nutrient data for player " + player.func_146103_bH().getName());
            manager = new NutrientManager();
            PlayerDataHandler.setForPlayer(player, manager, true);
        }
        return manager;
    }

    public static void setForPlayer(EntityPlayer player, NutrientManager manager, boolean sync) {
        if (player.field_70170_p.field_72995_K) {
            Log.warn("Tried to set server player data from the client!");
            return;
        }
        MANAGER_STORAGE.put(player, manager);
        if (sync) {
            Sync.serverRequest(player);
        }
    }

    public static void setForPlayer(EntityPlayer player, NutrientManager manager) {
        PlayerDataHandler.setForPlayer(player, manager, false);
    }
}

