/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.ore;

import java.util.List;
import mods.railcraft.common.blocks.ore.BlockOre;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.items.EntityItemFireproof;
import mods.railcraft.common.items.firestone.IItemFirestoneBurning;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemOre
extends ItemBlock
implements IItemFirestoneBurning {
    public ItemOre(Block block) {
        super(block);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public IIcon func_77617_a(int meta) {
        return EnumOre.values()[meta].getTexture(meta);
    }

    public int func_77647_b(int meta) {
        return meta;
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77960_j();
        if (damage < 0 || damage >= EnumOre.values().length) {
            return "";
        }
        return EnumOre.values()[damage].getTag();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        super.func_77624_a(stack, player, info, adv);
        String tipTag = EnumOre.fromMeta(stack.func_77960_j()).getTag() + ".tip";
        if (LocalizationPlugin.hasTag(tipTag)) {
            ToolTip tip = ToolTip.buildToolTip(tipTag, new String[0]);
            info.addAll(tip.convertToStrings());
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return stack != null && stack.func_77960_j() == EnumOre.FIRESTONE.ordinal();
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        if (!this.hasCustomEntity(stack)) {
            return null;
        }
        EntityItemFireproof entity = new EntityItemFireproof(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, stack);
        entity.field_70159_w = location.field_70159_w;
        entity.field_70181_x = location.field_70181_x;
        entity.field_70179_y = location.field_70179_y;
        entity.field_145804_b = 10;
        return entity;
    }

    @Override
    public boolean shouldBurn(@NotNull ItemStack itemStack) {
        boolean isStackEqual = InvTools.isStackEqualToBlock(itemStack, BlockOre.getBlock());
        return isStackEqual && itemStack.func_77960_j() == EnumOre.FIRESTONE.ordinal();
    }
}

