/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSmoker
extends TileMachineBase {
    private static final int SNOW_MELT_INTERVAL = 32;
    private static final Random rand = MiscTools.getRand();
    private boolean powered;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.SMOKER;
    }

    @Override
    public IIcon getIcon(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.powered) {
            if (Game.isHost(this.field_145850_b)) {
                Block blockAbove;
                if (this.clock % 32 == 0 && (blockAbove = WorldPlugin.getBlock((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) == Blocks.field_150431_aC) {
                    WorldPlugin.setBlockToAir(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                }
            } else {
                if (!WorldPlugin.blockIsAir(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
                    return;
                }
                double px = (float)this.field_145851_c + rand.nextFloat();
                double py = (float)this.field_145848_d + rand.nextFloat() * 0.5f + 1.0f;
                double pz = (float)this.field_145849_e + rand.nextFloat();
                EffectManager.instance.chimneyEffect(this.field_145850_b, px, py, pz);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        this.powered = PowerPlugin.isBlockBeingPowered(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.sendUpdateToClient();
    }

    @Override
    public boolean isSideSolid(ForgeDirection side) {
        return side != ForgeDirection.UP;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.powered = data.func_74767_n("powered");
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74757_a("powered", this.powered);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
    }
}

