/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class MultiBlockPattern {
    public final char[][][] pattern;
    private final int offsetX;
    private final int offsetY;
    private final int offsetZ;
    private final AxisAlignedBB entityCheckBounds;

    public MultiBlockPattern(char[][][] pattern) {
        this(pattern, 1, 1, 1);
    }

    public MultiBlockPattern(char[][][] pattern, int offsetX, int offsetY, int offsetZ) {
        this(pattern, offsetX, offsetY, offsetZ, null);
    }

    public MultiBlockPattern(char[][][] pattern, int offsetX, int offsetY, int offsetZ, AxisAlignedBB entityCheckBounds) {
        this.pattern = pattern;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.entityCheckBounds = entityCheckBounds;
    }

    public AxisAlignedBB getEntityCheckBounds(int masterX, int masterY, int masterZ) {
        if (this.entityCheckBounds == null) {
            return null;
        }
        return this.entityCheckBounds.func_72329_c().func_72317_d((double)masterX, (double)masterY, (double)masterZ);
    }

    public char getPatternMarkerChecked(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return 'O';
        }
        if (x >= this.getPatternWidthX() || y >= this.getPatternHeight() || z >= this.getPatternWidthZ()) {
            return 'O';
        }
        return this.getPatternMarker(x, y, z);
    }

    public char getPatternMarker(int x, int y, int z) {
        return this.pattern[y][x][z];
    }

    public int getMasterOffsetX() {
        return this.offsetX;
    }

    public int getMasterOffsetY() {
        return this.offsetY;
    }

    public int getMasterOffsetZ() {
        return this.offsetZ;
    }

    public int getPatternHeight() {
        return this.pattern.length;
    }

    public int getPatternWidthX() {
        return this.pattern[0].length;
    }

    public int getPatternWidthZ() {
        return this.pattern[0][0].length;
    }

    public int getMasterRelativeX(int posX, int patternX) {
        return this.offsetX - patternX + posX;
    }

    public int getMasterRelativeY(int posY, int patternY) {
        return this.offsetY - patternY + posY;
    }

    public int getMasterRelativeZ(int posZ, int patternZ) {
        return this.offsetZ - patternZ + posZ;
    }

    public TileEntity placeStructure(World world, int xCoord, int yCoord, int zCoord, Block block, Map<Character, Integer> blockMapping) {
        if (block == null) {
            return null;
        }
        int xWidth = this.getPatternWidthX();
        int zWidth = this.getPatternWidthZ();
        int height = this.getPatternHeight();
        int xOffset = xCoord - this.getMasterOffsetX();
        int yOffset = yCoord - this.getMasterOffsetY();
        int zOffset = zCoord - this.getMasterOffsetZ();
        TileEntity master = null;
        for (int px = 0; px < xWidth; px = (int)((byte)(px + 1))) {
            for (int py = 0; py < height; py = (int)((byte)(py + 1))) {
                for (int pz = 0; pz < zWidth; pz = (int)((byte)(pz + 1))) {
                    char marker = this.getPatternMarker(px, py, pz);
                    Integer metadata = blockMapping.get(Character.valueOf(marker));
                    if (metadata == null) continue;
                    int x = px + xOffset;
                    int y = py + yOffset;
                    int z = pz + zOffset;
                    world.func_147465_d(x, y, z, block, metadata.intValue(), 3);
                    if (px != this.getMasterOffsetX() || py != this.getMasterOffsetY() || pz != this.getMasterOffsetZ()) continue;
                    master = world.func_147438_o(x, y, z);
                }
            }
        }
        return master;
    }
}

