/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.core;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class WorldCoordinate
implements Comparable<WorldCoordinate> {
    public final int dimension;
    public final int x;
    public final int y;
    public final int z;

    public WorldCoordinate(int dimension, int x, int y, int z) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public WorldCoordinate(TileEntity tile) {
        this.dimension = tile.func_145831_w().field_73011_w.field_76574_g;
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
    }

    public static WorldCoordinate readFromNBT(NBTTagCompound data, String tag) {
        if (data.func_74764_b(tag)) {
            NBTTagCompound nbt = data.func_74775_l(tag);
            int dim = nbt.func_74762_e("dim");
            int x = nbt.func_74762_e("x");
            int y = nbt.func_74762_e("y");
            int z = nbt.func_74762_e("z");
            return new WorldCoordinate(dim, x, y, z);
        }
        return null;
    }

    public void writeToNBT(NBTTagCompound data, String tag) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("dim", this.dimension);
        nbt.func_74768_a("x", this.x);
        nbt.func_74768_a("y", this.y);
        nbt.func_74768_a("z", this.z);
        data.func_74782_a(tag, (NBTBase)nbt);
    }

    public boolean isInSameChunk(WorldCoordinate otherCoord) {
        return this.dimension == otherCoord.dimension && this.x >> 4 == otherCoord.x >> 4 && this.z >> 4 == otherCoord.z >> 4;
    }

    public boolean isEqual(int dim, int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z && this.dimension == dim;
    }

    @Override
    public int compareTo(WorldCoordinate o) {
        if (this.dimension != o.dimension) {
            return this.dimension - o.dimension;
        }
        if (this.x != o.x) {
            return this.x - o.x;
        }
        if (this.y != o.y) {
            return this.y - o.y;
        }
        if (this.z != o.z) {
            return this.z - o.z;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorldCoordinate other = (WorldCoordinate)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public int hashCode() {
        int result = this.dimension;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public String toString() {
        return "WorldCoordinate{dimension=" + this.dimension + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }
}

