/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft;

import com.pam.harvestcraft.ItemRegistry;
import com.pam.harvestcraft.PamUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ChurnRecipes {
    private static final ChurnRecipes smeltingBase = new ChurnRecipes();
    private final Map<ItemStack, ItemStack> smeltingList = new HashMap<ItemStack, ItemStack>();
    private final Map<ItemStack, Float> experienceList = new HashMap<ItemStack, Float>();

    private ChurnRecipes() {
        this.addSmelting(ItemRegistry.freshmilkItem, new ItemStack(ItemRegistry.butterItem), 0.1f);
    }

    public static ChurnRecipes smelting() {
        return smeltingBase;
    }

    public void addSmeltingRecipeForBlock(Block input, ItemStack stack, float experience) {
        this.addSmelting(Item.func_150898_a((Block)input), stack, experience);
    }

    public void addSmelting(Item input, ItemStack stack, float experience) {
        this.addSmeltingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public void addSmeltingRecipe(ItemStack input, ItemStack stack, float experience) {
        this.smeltingList.put(input, stack);
        this.experienceList.put(stack, Float.valueOf(experience));
    }

    public ItemStack getSmeltingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.smeltingList.entrySet()) {
            if (!PamUtils.areItemStacksEqualWithWildcard(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.smeltingList;
    }

    public float getSmeltingExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!PamUtils.areItemStacksEqualWithWildcard(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

