/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.MalisisDoorsSettings;
import net.malisis.doors.entity.MixedBlockTileEntity;
import net.malisis.doors.item.MixedBlockBlockItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MixedBlock
extends Block
implements ITileEntityProvider {
    public static int renderId = -1;

    public MixedBlock() {
        super(Material.field_151576_e);
        this.func_149711_c(0.7f);
        this.func_149663_c("mixed_block");
    }

    public void func_149651_a(IIconRegister reg) {
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        return side;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof MixedBlockBlockItem)) {
            return;
        }
        MixedBlockTileEntity te = TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, (IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        te.set(itemStack);
        if (MalisisDoorsSettings.enhancedMixedBlockPlacement.get().booleanValue()) {
            ForgeDirection dir = EntityUtils.getEntityFacing((Entity)player, true);
            if (!player.func_70093_af()) {
                dir = dir.getOpposite();
            }
            world.func_72921_c(x, y, z, dir.ordinal(), 3);
        } else {
            world.func_147444_c(x, y, z, (Block)this);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        MixedBlockTileEntity te = TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, (IBlockAccess)world, x, y, z);
        if (te == null) {
            return null;
        }
        return MixedBlockBlockItem.fromTileEntity(te);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        MixedBlockTileEntity te = TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, world, x, y, z);
        if (te == null || te.block1 == null || te.block2 == null) {
            return 0;
        }
        return Math.max(te.block1.func_149750_m(), te.block2.func_149750_m());
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        MixedBlockTileEntity te = TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, world, x, y, z);
        if (te == null) {
            return 0;
        }
        return te.block1 == Blocks.field_150451_bX || te.block2 == Blocks.field_150451_bX ? 15 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        MixedBlockTileEntity te = (MixedBlockTileEntity)world.func_147438_o(x, y, z);
        if (te == null || te.block1 == null || te.block2 == null) {
            return true;
        }
        Block[] blocks = new Block[]{te.block1, te.block2};
        int[] metadata = new int[]{te.metadata1, te.metadata2};
        ForgeDirection side = ForgeDirection.getOrientation((int)target.field_72310_e);
        double fxX = (double)x + world.field_73012_v.nextDouble();
        double fxY = (double)y + world.field_73012_v.nextDouble();
        double fxZ = (double)z + world.field_73012_v.nextDouble();
        switch (side) {
            case DOWN: {
                fxY = (double)y + this.func_149665_z() - (double)0.1f;
                break;
            }
            case UP: {
                fxY = (double)y + this.func_149669_A() + (double)0.1f;
                break;
            }
            case NORTH: {
                fxZ = (double)z + this.func_149706_B() - (double)0.1f;
                break;
            }
            case SOUTH: {
                fxZ = (double)z + this.func_149669_A() + (double)0.1f;
                break;
            }
            case EAST: {
                fxX = (double)x + this.func_149753_y() + (double)0.1f;
                break;
            }
            case WEST: {
                fxX = (double)x + this.func_149704_x() + (double)0.1f;
                break;
            }
        }
        int i = world.field_73012_v.nextBoolean() ? 0 : 1;
        EntityDiggingFX fx = new EntityDiggingFX(world, fxX, fxY, fxZ, 0.0, 0.0, 0.0, blocks[i], metadata[i]);
        fx.func_70543_e(0.2f).func_70541_f(0.6f);
        effectRenderer.func_78873_a((EntityFX)fx);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        int nb = 4;
        MixedBlockTileEntity te = (MixedBlockTileEntity)world.func_147438_o(x, y, z);
        if (te == null || te.block1 == null || te.block2 == null) {
            return true;
        }
        Block[] blocks = new Block[]{te.block1, te.block2};
        int[] metadata = new int[]{te.metadata1, te.metadata2};
        for (int i = 0; i < nb; ++i) {
            for (int j = 0; j < nb; ++j) {
                for (int k = 0; k < nb; ++k) {
                    double fxX = (double)x + ((double)i + 0.5) / (double)nb;
                    double fxY = (double)y + ((double)j + 0.5) / (double)nb;
                    double fxZ = (double)z + ((double)k + 0.5) / (double)nb;
                    int l = (i + j + k) % 2;
                    EntityDiggingFX fx = new EntityDiggingFX(world, fxX, fxY, fxZ, fxX - (double)x - 0.5, fxY - (double)y - 0.5, fxZ - (double)z - 0.5, blocks[l], metadata[l]);
                    effectRenderer.func_78873_a((EntityFX)fx);
                }
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new MixedBlockTileEntity();
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        MixedBlockTileEntity te;
        if (!player.field_71075_bZ.field_75098_d && (te = TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, (IBlockAccess)world, x, y, z)) != null) {
            this.func_149642_a(world, x, y, z, MixedBlockBlockItem.fromTileEntity(te));
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return renderId;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        if (world.func_147437_c(x, y, z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block != this && !(block instanceof BlockBreakable)) {
            return !block.func_149662_c();
        }
        ForgeDirection op = ForgeDirection.getOrientation((int)side).getOpposite();
        MixedBlockTileEntity current = TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, world, x + op.offsetX, y + op.offsetY, z + op.offsetZ);
        return !MixedBlock.isOpaque(world, x, y, z) && current.isOpaque();
    }

    public static boolean isOpaque(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockBreakable) {
            return true;
        }
        MixedBlockTileEntity te = TileEntityUtils.getTileEntity(MixedBlockTileEntity.class, world, x, y, z);
        return te != null && te.isOpaque();
    }
}

