/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import serverutils.lib.util.NBTUtils;

public class BlockUtils {
    public static final int UPDATE = 1;
    public static final int SEND_TO_CLIENTS = 2;
    public static final int NO_RERENDER = 4;
    public static final int RERENDER_MAIN_THREAD = 8;
    public static final int NO_OBSERVERS = 16;
    public static final int DEFAULT = 3;
    public static final int DEFAULT_AND_RERENDER = 11;
    public static final String DATA_TAG = "BlockEntityTag";

    public static void notifyBlockUpdate(World world, int posx, int posy, int posz, @Nullable Block block) {
        if (block == null) {
            block = world.func_147439_a(posx, posy, posz);
        }
        world.func_147444_c(posx, posy, posz, block);
    }

    public static boolean hasData(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b(DATA_TAG);
    }

    public static NBTTagCompound getData(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt != null ? nbt.func_74775_l(DATA_TAG) : new NBTTagCompound();
    }

    public static void removeData(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            nbt.func_82580_o(DATA_TAG);
            nbt.func_74775_l("display").func_82580_o("Lore");
            stack.func_77982_d(NBTUtils.minimize(nbt));
        }
    }
}

