/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.item;

import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import serverutils.lib.util.InvUtils;

public class ItemStackSerializer {
    public static ItemStack parseItemThrowingException(String input) throws Exception {
        if ((input = input.trim()).isEmpty() || input.equals("-") || input.equals("minecraft:air")) {
            return InvUtils.EMPTY_STACK;
        }
        if (input.startsWith("{")) {
            short id;
            NBTTagCompound nbt = (NBTTagCompound)JsonToNBT.func_150315_a((String)input);
            if (nbt.func_74771_c("Count") <= 0) {
                nbt.func_74774_a("Count", (byte)1);
            }
            return (id = nbt.func_74765_d("id")) == 0 ? ItemStackSerializer.parseItemWithName(nbt) : ItemStack.func_77949_a((NBTTagCompound)nbt);
        }
        String[] s1 = input.split(" ", 4);
        Item item = (Item)GameData.getItemRegistry().func_82594_a(new ResourceLocation(s1[0]).toString());
        if (item == null) {
            throw new NullPointerException("Unknown item: " + s1[0]);
        }
        int stackSize = 1;
        int meta = 0;
        if (s1.length >= 2) {
            stackSize = MathHelper.func_82715_a((String)s1[1], (int)1);
        }
        if (s1.length >= 3) {
            meta = s1[2].charAt(0) == '*' ? Short.MAX_VALUE : MathHelper.func_82715_a((String)s1[2], (int)0);
        }
        ItemStack itemstack = new ItemStack(item, stackSize, meta);
        if (s1.length >= 4) {
            itemstack.func_77982_d((NBTTagCompound)JsonToNBT.func_150315_a((String)s1[3]));
        }
        return itemstack == null ? InvUtils.EMPTY_STACK : itemstack;
    }

    public static ItemStack parseItem(String input) {
        try {
            return ItemStackSerializer.parseItemThrowingException(input);
        }
        catch (Exception ex) {
            return InvUtils.EMPTY_STACK;
        }
    }

    public static ItemStack parseItemWithName(NBTTagCompound nbt) {
        ItemStack stack;
        String id = nbt.func_74779_i("id");
        short dmg = nbt.func_74765_d("Damage");
        byte count = nbt.func_74771_c("Count");
        String tag = "";
        if (nbt.func_74764_b("tag")) {
            tag = nbt.func_74781_a("tag").toString();
        }
        if ((stack = GameRegistry.makeItemStack((String)id, (int)dmg, (int)count, (String)tag)) != null) {
            stack.field_77994_a = count;
        }
        return stack;
    }

    public static String toString(ItemStack stack) {
        if (stack == null) {
            return "minecraft:air";
        }
        NBTTagCompound nbt = stack.func_77955_b(new NBTTagCompound());
        if (nbt.func_74764_b("ForgeCaps")) {
            return nbt.toString();
        }
        StringBuilder builder = new StringBuilder(String.valueOf(GameData.getItemRegistry().func_148750_c((Object)stack.func_77973_b())));
        int count = stack.field_77994_a;
        int meta = stack.func_77960_j();
        NBTTagCompound tag = stack.func_77978_p();
        if (count > 1 || meta != 0 || tag != null) {
            builder.append(' ');
            builder.append(count);
        }
        if (meta != 0 || tag != null) {
            builder.append(' ');
            builder.append(meta);
        }
        if (tag != null) {
            builder.append(' ');
            builder.append(tag);
        }
        return builder.toString();
    }

    public static NBTBase write(ItemStack stack, boolean forceCompound) {
        if (stack == null) {
            return forceCompound ? new NBTTagCompound() : new NBTTagString("");
        }
        NBTTagCompound nbt = stack.func_77955_b(new NBTTagCompound());
        if (!nbt.func_74764_b("ForgeCaps") && !nbt.func_74764_b("tag")) {
            if (!forceCompound) {
                return new NBTTagString(ItemStackSerializer.toString(stack));
            }
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74778_a("item", ItemStackSerializer.toString(stack));
            return nbt1;
        }
        if (nbt.func_74771_c("Count") == 1) {
            nbt.func_82580_o("Count");
        }
        if (nbt.func_74765_d("Damage") == 0) {
            nbt.func_82580_o("Damage");
        }
        return nbt;
    }

    public static ItemStack read(@Nullable NBTBase nbtBase) {
        if (nbtBase == null) {
            return InvUtils.EMPTY_STACK;
        }
        if (nbtBase instanceof NBTTagString) {
            return ItemStackSerializer.parseItem(((NBTTagString)nbtBase).func_150285_a_());
        }
        if (!(nbtBase instanceof NBTTagCompound)) {
            return InvUtils.EMPTY_STACK;
        }
        NBTTagCompound nbt = (NBTTagCompound)nbtBase;
        if (nbt.func_150297_b("item", 8)) {
            return ItemStackSerializer.parseItem(nbt.func_74779_i("item"));
        }
        if (!nbt.func_74764_b("Count")) {
            nbt.func_74774_a("Count", (byte)1);
        }
        return ItemStack.func_77949_a((NBTTagCompound)nbt);
    }
}

