/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.nbthandlers;

import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.TextureFactory;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.nbthandlers.MTEHatchNbtConsumable;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.MTEIsaMill;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class MTEHatchMillingBalls
extends MTEHatchNbtConsumable {
    public MTEHatchMillingBalls(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 6, 4, "Dedicated Milling Ball Storage", false);
    }

    public MTEHatchMillingBalls(String aName, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, 6, 4, aDescription, false, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(TexturesGtBlock.Overlay_Bus_Milling_Balls)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(TexturesGtBlock.Overlay_Bus_Milling_Balls)};
    }

    @Override
    public String[] getDescription() {
        return (String[])ArrayUtils.add((Object[])this.mDescriptionArray, (Object)GTPPCore.GT_Tooltip.get());
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchMillingBalls(this.mName, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public String getNameGUI() {
        return "Ball Housing";
    }

    @Override
    public ArrayList<ItemStack> getItemsValidForUsageSlots() {
        return new ArrayList<ItemStack>();
    }

    @Override
    public boolean isItemValidForUsageSlot(ItemStack aStack) {
        return MTEIsaMill.isMillingBall(aStack);
    }

    @Override
    public int getInputSlotCount() {
        return 4;
    }
}

