/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.xmod.gregtech.api.gui.widget.ElectricSlotWidget;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class MTEHatchInputBattery
extends MTEHatch {
    public final RecipeMap<?> mRecipeMap = null;

    public MTEHatchInputBattery(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, MTEHatchInputBattery.getSlots(aTier), "Chargeable Item Bus for Multiblocks", new ITexture[0]);
    }

    public MTEHatchInputBattery(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aTier < 1 ? 1 : (aTier == 1 ? 4 : (aTier == 2 ? 4 : 16)), aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        int mSlots = 0;
        mSlots = this.mTier == 2 ? 4 : (this.mTier == 4 ? 16 : 16);
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Capacity: " + mSlots + " slots", GTPPCore.GT_Tooltip.get()});
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public long getMinimumStoredEU() {
        return 0L;
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxEUStore() {
        return 512L + GTValues.V[this.mTier + 1] * 16L;
    }

    @Override
    public long maxAmperesIn() {
        return 4L;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(TexturesGtBlock.Overlay_Hatch_Charger)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(TexturesGtBlock.Overlay_Hatch_Charger)};
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchInputBattery(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        MetaTileEntity mMetaTileEntity;
        IMetaTileEntity iMetaTileEntity;
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.fillStacksIntoFirstSlots();
        }
        if (aBaseMetaTileEntity.isServerSide() && (iMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity()) instanceof MetaTileEntity && (mMetaTileEntity = (MetaTileEntity)iMetaTileEntity).rechargerSlotCount() > 0 && aBaseMetaTileEntity.getStoredEU() > 0L) {
            int i;
            int k = mMetaTileEntity.rechargerSlotCount() + i;
            for (i = mMetaTileEntity.rechargerSlotStartIndex(); i < k; ++i) {
                if (aBaseMetaTileEntity.getStoredEU() <= 0L || mMetaTileEntity.mInventory[i] == null) continue;
                for (int u = 0; u < 10; ++u) {
                    aBaseMetaTileEntity.decreaseStoredEnergyUnits(GTModHandler.chargeElectricItem(mMetaTileEntity.mInventory[i], (int)Math.min(GTValues.V[this.mTier] * 15L, aBaseMetaTileEntity.getStoredEU()), (int)Math.min(Integer.MAX_VALUE, GTValues.V[u]), false, false), true);
                    if (mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                    mMetaTileEntity.mInventory[i] = null;
                }
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTimer);
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
        this.fillStacksIntoFirstSlots();
    }

    protected void fillStacksIntoFirstSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            for (int j = i + 1; j < this.mInventory.length; ++j) {
                if (this.mInventory[j] == null || this.mInventory[i] != null && !GTUtility.areStacksEqual(this.mInventory[i], this.mInventory[j])) continue;
                GTUtility.moveStackFromSlotAToSlotB((IInventory)this.getBaseMetaTileEntity(), (IInventory)this.getBaseMetaTileEntity(), j, i, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == this.getBaseMetaTileEntity().getFrontFacing() && (this.mRecipeMap == null || this.mRecipeMap.containsInput(aStack));
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == this.getBaseMetaTileEntity().getFrontFacing() && (this.mRecipeMap == null || this.mRecipeMap.containsInput(aStack));
    }

    @Override
    public int rechargerSlotCount() {
        if (this.mTier == 2) {
            return 2;
        }
        return 16;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.mTier == 2) {
            for (int i = 0; i < 4; ++i) {
                builder.widget(new ElectricSlotWidget((IItemHandlerModifiable)this.inventoryHandler, i).setPos(70 + i % 2 * 18, 25 + i / 2 * 18));
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                builder.widget(new ElectricSlotWidget((IItemHandlerModifiable)this.inventoryHandler, i).setPos(52 + i % 4 * 18, 7 + i / 4 * 18));
            }
        }
    }
}

