/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.tooltip.TooltipTier;
import gregtech.common.blocks.BlockCasings4;
import gregtech.common.misc.GTStructureChannels;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class MTEIndustrialExtractor
extends MTEExtendedPowerMultiBlockBase<MTEIndustrialExtractor>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEIndustrialExtractor> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", (String[][])new String[][]{{"CCCCC", "C   C", "C   C", "C   C", "CC~CC"}, {"CCCCC", " BBB ", " AAA ", " BBB ", "CCCCC"}, {"CCCCC", " BBB ", " ABA ", " BBB ", "CCCCC"}, {"CCCCC", " BBB ", " AAA ", " BBB ", "CCCCC"}, {"CCCCC", "C   C", "C   C", "C   C", "CCCCC"}}).addElement('C', GTStructureUtility.buildHatchAdder(MTEIndustrialExtractor.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy).casingIndex(((BlockCasings4)GregTechAPI.sBlockCasings4).getTextureIndex(1)).dot(1).buildAndChain(StructureUtility.onElementPass(MTEIndustrialExtractor::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)))).addElement('B', GTStructureChannels.ITEM_PIPE_CASING.use(StructureUtility.ofBlocksTiered(MTEIndustrialExtractor::getItemPipeTierFromMeta, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)0), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)1), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)2), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)3), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)4), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)5), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)6), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)7)), (Object)-1, MTEIndustrialExtractor::setItemPipeTier, MTEIndustrialExtractor::getItemPipeTier))).addElement('A', GTStructureUtility.chainAllGlasses()).build();
    private int itemPipeTier = -1;
    private int mCasingAmount;

    @Nullable
    private static Integer getItemPipeTierFromMeta(Block block, Integer metaID) {
        if (block != GregTechAPI.sBlockCasings11) {
            return null;
        }
        if (metaID < 0 || metaID > 7) {
            return null;
        }
        return metaID + 1;
    }

    private void setItemPipeTier(int tier) {
        this.itemPipeTier = tier;
    }

    private int getItemPipeTier() {
        return this.itemPipeTier;
    }

    public MTEIndustrialExtractor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialExtractor(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<MTEIndustrialExtractor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialExtractor(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings4, 1)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_EXTRACTOR_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_EXTRACTOR_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings4, 1)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_EXTRACTOR).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_INDUSTRIAL_EXTRACTOR_GLOW).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings4, 1))};
        return rTexture;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Extractor").addDynamicParallelInfo(8, TooltipTier.ITEM_PIPE_CASING).addStaticSpeedInfo(3.0f).addStaticEuEffInfo(0.85f).beginStructureBlock(5, 5, 5, false).addController("Front Center").addCasingInfoMin("Stainless Steel Machine Casing", 45, false).addCasingInfoExactly("Item Pipe Casing", 19, true).addCasingInfoExactly("Any Tiered Glass", 8, false).addInputBus("Any Stainless Steel Casing", 1).addOutputBus("Any Stainless Steel Casing", 1).addEnergyHatch("Any Stainless Steel Casing", 1).addMaintenanceHatch("Any Stainless Steel Casing", 1).addSubChannelUsage(GTStructureChannels.BOROGLASS).addSubChannelUsage(GTStructureChannels.ITEM_PIPE_CASING).toolTipFinisher(new String[0]);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 4, 0, elementBudget, env, false, true);
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasingAmount = 0;
        this.itemPipeTier = -1;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 4, 0)) {
            return false;
        }
        return this.mCasingAmount >= 45;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().noRecipeCaching().setSpeedBonus(0.3333333432674408).setMaxParallelSupplier(this::getTrueParallel).setEuModifier(0.85f);
    }

    @Override
    public int getMaxParallelRecipes() {
        return Math.max(8 * this.itemPipeTier, 0);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.extractorRecipes;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -10;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }
}

