/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc;

import com.gtnewhorizon.gtnhlib.util.AnimatedTooltipHandler;
import gregtech.GTMod;
import gregtech.api.enums.ChatMessage;
import gregtech.commands.GTBaseCommand;
import gregtech.common.data.GTPowerfailTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class GTPowerfailCommand
extends GTBaseCommand {
    private static final String[] SUBCOMMANDS = new String[]{"clear", "clear-dim", "list", "show", "hide", "help"};

    public GTPowerfailCommand() {
        super("powerfails", "powerfail", "pf");
    }

    public String func_71517_b() {
        return "powerfails";
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return "Usage: /powerfails <subcommand>. Valid subcommands are: " + String.join((CharSequence)", ", SUBCOMMANDS) + ".";
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_71519_b(ICommandSender sender) {
        return sender instanceof EntityPlayer;
    }

    @Override
    protected List<IChatComponent> getHelpMessages() {
        ArrayList<IChatComponent> messages = new ArrayList<IChatComponent>();
        messages.add((IChatComponent)new ChatComponentText(this.func_71518_a(null)));
        messages.add((IChatComponent)new ChatComponentText(" clear - Clears all powerfails for your team"));
        messages.add((IChatComponent)new ChatComponentText(" clear-dim - Clears all powerfails for your team in the current dimension"));
        messages.add((IChatComponent)new ChatComponentText(" list - Prints all uncleared powerfails for your team"));
        messages.add((IChatComponent)new ChatComponentText(" show - Enables in-world powerfail icons"));
        messages.add((IChatComponent)new ChatComponentText(" hide - Disables in-world powerfail icons"));
        messages.add((IChatComponent)new ChatComponentText(" help - Prints this help text"));
        messages.add((IChatComponent)new ChatComponentText(""));
        messages.add((IChatComponent)new ChatComponentText("Aliases: powerfails, powerfail, pf"));
        return messages;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        String first;
        ArrayList<String> l = new ArrayList<String>();
        String string = first = args.length == 0 ? "" : args[0].trim();
        if (first.isEmpty()) {
            l.addAll(Arrays.asList(SUBCOMMANDS));
        } else if (args.length == 1) {
            l.addAll(GTPowerfailCommand.func_71530_a((String[])args, (String[])SUBCOMMANDS));
        }
        return l;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        EntityPlayerMP player = (EntityPlayerMP)sender;
        if (args.length < 1) {
            this.sendHelpMessage(sender);
            return;
        }
        switch (args[0]) {
            case "clear": {
                GTMod.proxy.powerfailTracker.clearPowerfails(player, OptionalInt.empty());
                ChatMessage.PowerfailsCleared.send((EntityPlayer)player, new Object[0]);
                break;
            }
            case "clear-dim": {
                GTMod.proxy.powerfailTracker.clearPowerfails(player, OptionalInt.of(player.field_70170_p.field_73011_w.field_76574_g));
                ChatMessage.PowerfailsClearedDim.send((EntityPlayer)player, new Object[0]);
                break;
            }
            case "list": {
                UUID playerId = player.func_146103_bH().getId();
                List<GTPowerfailTracker.Powerfail> powerfails = GTMod.proxy.powerfailTracker.getPowerfails(playerId, OptionalInt.empty());
                GTPowerfailCommand.sendChatToPlayer(sender, "");
                if (powerfails.isEmpty()) {
                    ChatMessage.PowerfailsListNone.send((EntityPlayer)player, new Object[0]);
                    return;
                }
                ChatMessage.PowerfailsListHeader.send((EntityPlayer)player, new Object[0]);
                if (powerfails.size() > 25) {
                    for (GTPowerfailTracker.Powerfail powerfail : powerfails.subList(0, 25)) {
                        ChatMessage.PowerfailsListEntry.send((EntityPlayer)player, powerfail.toDescription());
                    }
                    ChatMessage.PowerfailsListTruncated.send((EntityPlayer)player, powerfails.size() - 25);
                    break;
                }
                for (GTPowerfailTracker.Powerfail powerfail : powerfails) {
                    ChatMessage.PowerfailsListEntry.send((EntityPlayer)player, powerfail.toDescription());
                }
                break;
            }
            default: {
                GTPowerfailCommand.sendChatToPlayer(sender, AnimatedTooltipHandler.RED + "Illegal subcommand: " + args[0]);
                this.sendHelpMessage(sender);
            }
        }
    }
}

