/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverIOBase;
import gregtech.common.covers.gui.CoverGui;
import gregtech.common.covers.gui.CoverIOBaseGui;
import gregtech.common.gui.mui1.cover.PumpUIFactory;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class CoverPump
extends CoverIOBase {
    public final int mTransferRate;

    public CoverPump(CoverContext context, int aTransferRate, ITexture coverTexture) {
        super(context, coverTexture);
        this.mTransferRate = aTransferRate;
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    protected void doTransfer(ICoverable coverable) {
        if (coverable instanceof IFluidHandler) {
            IFluidHandler current = (IFluidHandler)coverable;
            IFluidHandler toAccess = coverable.getITankContainerAtSide(this.coverSide);
            if (toAccess == null) {
                return;
            }
            this.transferFluid(current, toAccess, this.coverSide, this.coverData % 2 == 0);
        }
    }

    protected void transferFluid(IFluidHandler current, IFluidHandler toAccess, ForgeDirection coverSide, boolean export) {
        IFluidHandler source = export ? current : toAccess;
        IFluidHandler dest = export ? toAccess : current;
        ForgeDirection drainSide = export ? coverSide : coverSide.getOpposite();
        GTUtility.moveFluid(source, dest, drainSide, this.mTransferRate, this::canTransferFluid);
    }

    protected boolean canTransferFluid(FluidStack fluid) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoIn() {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (this.coverData > 1 && coverable instanceof IMachineProgress && ((IMachineProgress)((Object)coverable)).isAllowedToWork() != this.coverData % 6 < 4) {
            return false;
        }
        return this.coverData >= 6 || this.coverData % 2 != 0;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (this.coverData > 1 && coverable instanceof IMachineProgress && ((IMachineProgress)((Object)coverable)).isAllowedToWork() != this.coverData % 6 < 4) {
            return false;
        }
        return this.coverData >= 6 || this.coverData % 2 == 0;
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 1;
    }

    @Override
    @NotNull
    protected CoverGui<?> getCoverGui() {
        return new CoverIOBaseGui(this, "cover.pump");
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new PumpUIFactory(buildContext).createWindow();
    }
}

