/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client;

import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import gregtech.common.config.Client;
import gregtech.mixin.interfaces.accessors.AbstractClientPlayerAccessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

@EventBusSubscriber(side={Side.CLIENT})
@ParametersAreNonnullByDefault
public class GTCapesClientHandler {
    private static final Map<UUID, ResourceLocation> CAPE_CACHE = new HashMap<UUID, ResourceLocation>();
    private static final ResourceLocation CAPE_BRAINTECHCAPE = new ResourceLocation("gregtech:textures/BrainTechCape.png");
    private static final ResourceLocation CAPE_GREGTECHCAPE = new ResourceLocation("gregtech:textures/GregTechCape.png");
    private static final ResourceLocation CAPE_MRBRAINCAPE = new ResourceLocation("gregtech:textures/MrBrainCape.png");
    private static final ResourceLocation CAPE_GREGORIUSCAPE = new ResourceLocation("gregtech:textures/GregoriusCape.png");
    private static final ResourceLocation CAPE_DONORCAPE = new ResourceLocation("gregtech:textures/DonorCape.png");
    private static final ResourceLocation CAPE_DEVCAPE = new ResourceLocation("gregtech:textures/DevCape.png");
    private static final ResourceLocation CAPE_STEAM = new ResourceLocation("gregtech:textures/Steam.png");
    private static final ResourceLocation CAPE_TITANIUM = new ResourceLocation("gregtech:textures/Titanium.png");
    private static final ResourceLocation CAPE_NEUTRONIUM = new ResourceLocation("gregtech:textures/Neutronium.png");
    private static final ResourceLocation CAPE_STARGATE = new ResourceLocation("gregtech:textures/Stargate.png");
    private static final ResourceLocation CAPE_BLUE_GC = new ResourceLocation("galacticraftcore:textures/capes/capeBlue.png");
    private static final ResourceLocation CAPE_BROWN_GC = new ResourceLocation("galacticraftcore:textures/capes/capeBrown.png");
    private static final ResourceLocation CAPE_CYAN_GC = new ResourceLocation("galacticraftcore:textures/capes/capeCyan.png");
    private static final ResourceLocation CAPE_DARK_GRAY_GC = new ResourceLocation("galacticraftcore:textures/capes/capeDarkGray.png");
    private static final ResourceLocation CAPE_DARK_GREEN_GC = new ResourceLocation("galacticraftcore:textures/capes/capeDarkGreen.png");
    private static final ResourceLocation CAPE_LIGHT_BLUE_GC = new ResourceLocation("galacticraftcore:textures/capes/capeLightBlue.png");
    private static final ResourceLocation CAPE_LIGHT_GRAY_GC = new ResourceLocation("galacticraftcore:textures/capes/capeLightGray.png");
    private static final ResourceLocation CAPE_LIME_GC = new ResourceLocation("galacticraftcore:textures/capes/capeLime.png");
    private static final ResourceLocation CAPE_MAGENTA_GC = new ResourceLocation("galacticraftcore:textures/capes/capeMagenta.png");
    private static final ResourceLocation CAPE_ORANGE_GC = new ResourceLocation("galacticraftcore:textures/capes/capeOrange.png");
    private static final ResourceLocation CAPE_PINK_GC = new ResourceLocation("galacticraftcore:textures/capes/capePink.png");
    private static final ResourceLocation CAPE_PURPLE_GC = new ResourceLocation("galacticraftcore:textures/capes/capePurple.png");
    private static final ResourceLocation CAPE_RAINBOW_GC = new ResourceLocation("galacticraftcore:textures/capes/capeRainbow.png");
    private static final ResourceLocation CAPE_RED_GC = new ResourceLocation("galacticraftcore:textures/capes/capeRed.png");
    private static final ResourceLocation CAPE_YELLOW_GC = new ResourceLocation("galacticraftcore:textures/capes/capeYellow.png");
    private static final ResourceLocation CAPE_BLUE_GS = new ResourceLocation("galaxyspace:textures/capes/capeBlue.png");
    private static final ResourceLocation CAPE_BROWN_GS = new ResourceLocation("galaxyspace:textures/capes/capeBrown.png");
    private static final ResourceLocation CAPE_CYAN_GS = new ResourceLocation("galaxyspace:textures/capes/capeCyan.png");
    private static final ResourceLocation CAPE_DARK_GRAY_GS = new ResourceLocation("galaxyspace:textures/capes/capeDarkGray.png");
    private static final ResourceLocation CAPE_DARK_GREEN_GS = new ResourceLocation("galaxyspace:textures/capes/capeDarkGreen.png");
    private static final ResourceLocation CAPE_DEV_GS = new ResourceLocation("galaxyspace:textures/capes/capeDev.png");
    private static final ResourceLocation CAPE_GRAYC_GS = new ResourceLocation("galaxyspace:textures/capes/capeGrayC.png");
    private static final ResourceLocation CAPE_LIGHT_BLUE_GS = new ResourceLocation("galaxyspace:textures/capes/capeLightBlue.png");
    private static final ResourceLocation CAPE_LIGHT_GRAY_GS = new ResourceLocation("galaxyspace:textures/capes/capeLightGray.png");
    private static final ResourceLocation CAPE_LIME_GS = new ResourceLocation("galaxyspace:textures/capes/capeLime.png");
    private static final ResourceLocation CAPE_MAGENTA_GS = new ResourceLocation("galaxyspace:textures/capes/capeMagenta.png");
    private static final ResourceLocation CAPE_ORANGE_GS = new ResourceLocation("galaxyspace:textures/capes/capeOrange.png");
    private static final ResourceLocation CAPE_PINK_GS = new ResourceLocation("galaxyspace:textures/capes/capePink.png");
    private static final ResourceLocation CAPE_PURPLE_GS = new ResourceLocation("galaxyspace:textures/capes/capePurple.png");
    private static final ResourceLocation CAPE_RED_GS = new ResourceLocation("galaxyspace:textures/capes/capeRed.png");
    private static final ResourceLocation CAPE_YELLOW_GS = new ResourceLocation("galaxyspace:textures/capes/capeYellow.png");

    @SubscribeEvent
    public static void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        CAPE_CACHE.clear();
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.entity;
        if (entity instanceof AbstractClientPlayerAccessor) {
            AbstractClientPlayerAccessor accessor = (AbstractClientPlayerAccessor)entity;
            accessor.gt5u$setCape(CAPE_CACHE.get(event.entity.func_110124_au()));
        }
    }

    public static void setCapes(Map<UUID, String> capes) {
        Minecraft mc = Minecraft.func_71410_x();
        for (Map.Entry<UUID, String> p : capes.entrySet()) {
            UUID uuid = p.getKey();
            String capeName = p.getValue();
            ResourceLocation cape = GTCapesClientHandler.capeFromString(capeName);
            EntityPlayer player = mc.field_71441_e.func_152378_a(uuid);
            if (player instanceof AbstractClientPlayerAccessor) {
                AbstractClientPlayerAccessor accessor = (AbstractClientPlayerAccessor)player;
                accessor.gt5u$setCape(cape);
            }
            if (player == mc.field_71439_g) {
                Client.preference.selectedCape = capeName;
                ConfigurationManager.save((Class[])new Class[]{Client.class});
            }
            CAPE_CACHE.put(uuid, cape);
        }
    }

    public static void printCapes(Collection<String> capes) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Available capes: " + String.join((CharSequence)", ", capes)));
    }

    private static ResourceLocation capeFromString(@Nullable String capeName) {
        ResourceLocation resourceLocation;
        switch (capeName) {
            case "capefriedi": {
                resourceLocation = CAPE_BRAINTECHCAPE;
                break;
            }
            case "capebrain": {
                resourceLocation = CAPE_MRBRAINCAPE;
                break;
            }
            case "capegregoriust": {
                resourceLocation = CAPE_GREGORIUSCAPE;
                break;
            }
            case "capedonor": {
                resourceLocation = CAPE_DONORCAPE;
                break;
            }
            case "capedev": {
                resourceLocation = CAPE_DEVCAPE;
                break;
            }
            case "cape_steam": {
                resourceLocation = CAPE_STEAM;
                break;
            }
            case "cape_titanium": {
                resourceLocation = CAPE_TITANIUM;
                break;
            }
            case "cape_neutronium": {
                resourceLocation = CAPE_NEUTRONIUM;
                break;
            }
            case "cape_stargate": {
                resourceLocation = CAPE_STARGATE;
                break;
            }
            case "cape_gt": {
                resourceLocation = CAPE_GREGTECHCAPE;
                break;
            }
            case "capeBlueGC": {
                resourceLocation = CAPE_BLUE_GC;
                break;
            }
            case "capeBrownGC": {
                resourceLocation = CAPE_BROWN_GC;
                break;
            }
            case "capeCyanGC": {
                resourceLocation = CAPE_CYAN_GC;
                break;
            }
            case "capeDarkGrayGC": {
                resourceLocation = CAPE_DARK_GRAY_GC;
                break;
            }
            case "capeDarkGreenGC": {
                resourceLocation = CAPE_DARK_GREEN_GC;
                break;
            }
            case "capeLightBlueGC": {
                resourceLocation = CAPE_LIGHT_BLUE_GC;
                break;
            }
            case "capeLightGrayGC": {
                resourceLocation = CAPE_LIGHT_GRAY_GC;
                break;
            }
            case "capeLimeGC": {
                resourceLocation = CAPE_LIME_GC;
                break;
            }
            case "capeMagentaGC": {
                resourceLocation = CAPE_MAGENTA_GC;
                break;
            }
            case "capeOrangeGC": {
                resourceLocation = CAPE_ORANGE_GC;
                break;
            }
            case "capePinkGC": {
                resourceLocation = CAPE_PINK_GC;
                break;
            }
            case "capePurpleGC": {
                resourceLocation = CAPE_PURPLE_GC;
                break;
            }
            case "capeRainbowGC": {
                resourceLocation = CAPE_RAINBOW_GC;
                break;
            }
            case "capeRedGC": {
                resourceLocation = CAPE_RED_GC;
                break;
            }
            case "capeYellowGC": {
                resourceLocation = CAPE_YELLOW_GC;
                break;
            }
            case "capeBlueGS": {
                resourceLocation = CAPE_BLUE_GS;
                break;
            }
            case "capeBrownGS": {
                resourceLocation = CAPE_BROWN_GS;
                break;
            }
            case "capeCyanGS": {
                resourceLocation = CAPE_CYAN_GS;
                break;
            }
            case "capeDarkGrayGS": {
                resourceLocation = CAPE_DARK_GRAY_GS;
                break;
            }
            case "capeDarkGreenGS": {
                resourceLocation = CAPE_DARK_GREEN_GS;
                break;
            }
            case "capeDevGS": {
                resourceLocation = CAPE_DEV_GS;
                break;
            }
            case "capeGrayCGS": {
                resourceLocation = CAPE_GRAYC_GS;
                break;
            }
            case "capeLightBlueGS": {
                resourceLocation = CAPE_LIGHT_BLUE_GS;
                break;
            }
            case "capeLightGrayGS": {
                resourceLocation = CAPE_LIGHT_GRAY_GS;
                break;
            }
            case "capeLimeGS": {
                resourceLocation = CAPE_LIME_GS;
                break;
            }
            case "capeMagentaGS": {
                resourceLocation = CAPE_MAGENTA_GS;
                break;
            }
            case "capeOrangeGS": {
                resourceLocation = CAPE_ORANGE_GS;
                break;
            }
            case "capePinkGS": {
                resourceLocation = CAPE_PINK_GS;
                break;
            }
            case "capePurpleGS": {
                resourceLocation = CAPE_PURPLE_GS;
                break;
            }
            case "capeRedGS": {
                resourceLocation = CAPE_RED_GS;
                break;
            }
            case "capeYellowGS": {
                resourceLocation = CAPE_YELLOW_GS;
                break;
            }
            default: {
                resourceLocation = null;
            }
        }
        return resourceLocation;
    }
}

