/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.shutdown;

import gregtech.api.enums.Materials;
import gregtech.api.util.shutdown.ReasonOutOfFluid;
import gregtech.api.util.shutdown.ReasonOutOfItem;
import gregtech.api.util.shutdown.ReasonOutOfStuff;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.SimpleShutDownReason;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ShutDownReasonRegistry {
    private static final Map<String, ShutDownReason> registry = new HashMap<String, ShutDownReason>();
    @Nonnull
    public static final ShutDownReason POWER_LOSS = SimpleShutDownReason.ofCritical("power_loss");
    @Nonnull
    public static final ShutDownReason POLLUTION_FAIL = SimpleShutDownReason.ofCritical("pollution_fail");
    @Nonnull
    public static final ShutDownReason STRUCTURE_INCOMPLETE = SimpleShutDownReason.ofNormal("structure_incomplete");
    @Nonnull
    public static final ShutDownReason NO_REPAIR = SimpleShutDownReason.ofNormal("no_repair");
    @Nonnull
    public static final ShutDownReason NO_TURBINE = SimpleShutDownReason.ofNormal("no_turbine");
    @Nonnull
    public static final ShutDownReason NO_MACHINE_PART = SimpleShutDownReason.ofNormal("no_machine_part");
    @Nonnull
    public static final ShutDownReason NONE = SimpleShutDownReason.ofNormal("none");
    @Nonnull
    public static final ShutDownReason CRITICAL_NONE = SimpleShutDownReason.ofCritical("none");
    @Nonnull
    public static final ShutDownReason INSUFFICIENT_DYNAMO = SimpleShutDownReason.ofCritical("insufficient_dyamo");

    public static void register(ShutDownReason sample) {
        if (ShutDownReasonRegistry.isRegistered(sample.getID())) {
            throw new IllegalStateException(String.format("ID %s is already registered for %s", sample.getID(), registry.get(sample.getID()).getClass().getCanonicalName()));
        }
        registry.put(sample.getID(), sample);
    }

    public static ShutDownReason getSampleFromRegistry(String id) {
        if (!ShutDownReasonRegistry.isRegistered(id)) {
            throw new RuntimeException("Unknown id: " + id);
        }
        return registry.get(id);
    }

    public static boolean isRegistered(String id) {
        return registry.containsKey(id);
    }

    @Nonnull
    public static ShutDownReason outOfFluid(@Nonnull FluidStack required) {
        return new ReasonOutOfFluid(required);
    }

    @Nonnull
    public static ShutDownReason outOfItem(@Nonnull ItemStack required) {
        return new ReasonOutOfItem(required);
    }

    @Nonnull
    public static ShutDownReason outOfStuff(@Nonnull String required, int amount) {
        return new ReasonOutOfStuff(required, amount);
    }

    static {
        ShutDownReasonRegistry.register(new SimpleShutDownReason("", false));
        ShutDownReasonRegistry.register(new ReasonOutOfFluid(Materials.Water.getFluid(0L)));
        ShutDownReasonRegistry.register(new ReasonOutOfItem(new ItemStack(Items.field_151008_G, 1)));
        ShutDownReasonRegistry.register(new ReasonOutOfStuff("stuff", 1));
    }
}

