/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks.machine;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.BlockDE;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.TilePlayerDetector;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PlayerDetector
extends BlockDE
implements ITileEntityProvider {
    @SideOnly(value=Side.CLIENT)
    IIcon side_inactive;
    @SideOnly(value=Side.CLIENT)
    IIcon side_active;
    @SideOnly(value=Side.CLIENT)
    IIcon top;
    @SideOnly(value=Side.CLIENT)
    IIcon bottom;

    public PlayerDetector() {
        this.func_149663_c("playerDetector");
        this.func_149647_a(DraconicEvolution.tabBlocksItems);
        this.func_149672_a(field_149769_e);
        ModBlocks.register(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.side_inactive = iconRegister.func_94245_a(References.RESOURCESPREFIX + "player_detector_side_inactive");
        this.side_active = iconRegister.func_94245_a(References.RESOURCESPREFIX + "player_detector_side_active");
        this.top = iconRegister.func_94245_a(References.RESOURCESPREFIX + "machine_top_0");
        this.bottom = iconRegister.func_94245_a(References.RESOURCESPREFIX + "machine_side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TilePlayerDetector detector;
        if (side == 0) {
            return this.bottom;
        }
        if (side == 1) {
            return this.top;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        IIcon side_icon = tile instanceof TilePlayerDetector && (detector = (TilePlayerDetector)tile).shouldOutput() ? this.side_active : this.side_inactive;
        return side_icon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0) {
            return this.bottom;
        }
        if (side == 1) {
            return this.top;
        }
        return this.side_active;
    }

    public boolean func_149747_d(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TilePlayerDetector();
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return side >= 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149748_c(world, x, y, z, side);
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TilePlayerDetector detector;
        TileEntity tile = world.func_147438_o(x, y, z);
        return tile instanceof TilePlayerDetector && (detector = (TilePlayerDetector)tile).shouldOutput() ? 15 : 0;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TilePlayerDetector) {
            TilePlayerDetector detector = (TilePlayerDetector)tile;
            int range = detector.getRange();
            range = player.func_70093_af() ? --range : ++range;
            detector.setRange(range);
            if (world.field_72995_K) {
                player.func_145747_a(new ChatComponentTranslation("msg.range.txt", new Object[0]).func_150257_a((IChatComponent)new ChatComponentText(" " + detector.getRange())));
            }
        }
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockBroken, int metadata) {
        super.func_149749_a(world, x, y, z, blockBroken, metadata);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            world.func_147441_b(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ, blockBroken, direction.getOpposite().ordinal());
        }
    }
}

