/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import vswe.stevesfactory.components.IItemBufferSubElement;

public class SlotStackInventoryHolder
implements IItemBufferSubElement {
    private ItemStack itemStack;
    private IInventory inventory;
    private int slot;
    private int sizeLeft;

    public SlotStackInventoryHolder(ItemStack itemStack, IInventory inventory, int slot) {
        this.itemStack = itemStack;
        this.inventory = inventory;
        this.slot = slot;
        this.sizeLeft = itemStack.field_77994_a;
    }

    @Override
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public int getSlot() {
        return this.slot;
    }

    @Override
    public void remove() {
        if (this.itemStack.field_77994_a == 0) {
            this.getInventory().func_70299_a(this.getSlot(), null);
        }
    }

    @Override
    public void onUpdate() {
        this.getInventory().func_70296_d();
    }

    @Override
    public int getSizeLeft() {
        return Math.min(this.itemStack.field_77994_a, this.sizeLeft);
    }

    @Override
    public void reduceAmount(int val) {
        this.itemStack.field_77994_a -= val;
        this.sizeLeft -= val;
    }

    public SlotStackInventoryHolder getSplitElement(int elementAmount, int id, boolean fair) {
        int amountLeft;
        SlotStackInventoryHolder element = new SlotStackInventoryHolder(this.itemStack, this.inventory, this.slot);
        int oldAmount = this.getSizeLeft();
        int amount = oldAmount / elementAmount;
        if (!fair && id < (amountLeft = oldAmount % elementAmount)) {
            ++amount;
        }
        element.sizeLeft = amount;
        return element;
    }
}

