/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.util;

import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
public class SoundUnpack
implements IFMLLoadingPlugin,
IFMLCallHook {
    public void load() throws IOException, URISyntaxException {
        File f = new File("mods" + File.separator + "OpenSecurity" + File.separator + "sounds" + File.separator + "alarms" + File.separator);
        f.mkdirs();
        String path = "assets/opensecurity/sounds/alarms/";
        System.out.println("Extracting sounds from: assets/opensecurity/sounds/alarms/");
        File jarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        if (jarFile.isFile()) {
            JarFile jar = null;
            jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith("assets/opensecurity/sounds/alarms/") || !name.endsWith(".ogg")) continue;
                InputStream oggStream = SoundUnpack.class.getClassLoader().getResourceAsStream(name);
                Path p = Paths.get(name, new String[0]);
                String file = p.getFileName().toString();
                System.out.println("Extracting file: " + file);
                try (FileOutputStream fos = new FileOutputStream(f + File.separator + file);){
                    int r;
                    byte[] buf = new byte[2048];
                    while (-1 != (r = oggStream.read(buf))) {
                        fos.write(buf, 0, r);
                    }
                }
            }
            jar.close();
        } else {
            System.out.println("ERROR: Can't detect valid JAR");
        }
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return this.getClass().getName();
    }

    public void injectData(Map<String, Object> data) {
    }

    public Void call() {
        try {
            this.load();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getAccessTransformerClass() {
        return null;
    }
}

