/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.mothership;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.mothership.Mothership;
import de.katzenpapst.amunra.mothership.MothershipWorldProvider;
import de.katzenpapst.amunra.world.SkyProviderDynamic;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class SkyProviderMothership
extends SkyProviderDynamic {
    protected CelestialBody mothershipParent;
    protected boolean isInTransit = false;
    protected int jetDirection = 0;
    protected float transitOffset = 0.0f;
    protected long curWorldTime = -1L;
    protected final double skyBoxLength = 100.0;
    protected final double cylinderLength = this.skyBoxLength * 12.0;
    protected final double angleWidth = 0.5 / this.skyBoxLength;
    protected final int numStarLines;
    protected final float starLineSpeed = 20.0f;

    public SkyProviderMothership(IGalacticraftWorldProvider worldProvider) {
        super(worldProvider);
        this.numStarLines = AmunRa.config.mothershipNumStarLines;
        this.hasHorizon = false;
    }

    protected void initStarLines(int list, double radius) {
        GL11.glPushMatrix();
        GL11.glNewList((int)list, (int)4864);
        Random rand = new Random();
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        double size = 0.5;
        double skyRadius = 100.0;
        for (int starIndex = 0; starIndex < 400; ++starIndex) {
            double theta = rand.nextDouble() * Math.PI * 2.0;
            double angleWidth = 0.005;
            double x1 = Math.cos(theta - 0.005) * 100.0;
            double y1 = Math.sin(theta - 0.005) * 100.0;
            double x2 = Math.cos(theta + 0.005) * 100.0;
            double y2 = Math.sin(theta + 0.005) * 100.0;
            double zBase = rand.nextDouble() * 100.0 * 2.0 - 100.0;
            double length = rand.nextDouble() * 20.0;
            tess.func_78377_a(x1, y1, zBase);
            tess.func_78377_a(x1, y1, zBase + length);
            tess.func_78377_a(x2, y2, zBase + length);
            tess.func_78377_a(x2, y2, zBase);
        }
        tess.func_78381_a();
        GL11.glEndList();
        GL11.glPopMatrix();
    }

    @Override
    protected void renderSystem(float partialTicks, WorldClient world, Tessellator tess, Minecraft mc) {
        super.renderSystem(partialTicks, world, tess, mc);
        GL11.glPushMatrix();
        if (this.rType != SkyProviderDynamic.RenderType.STAR && !AmunRa.config.isSun(this.mothershipParent)) {
            if (!this.isAsteroidBelt) {
                GL11.glRotatef((float)(180.0f - this.currentCelestialAngle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                this.renderPlanetByAngle(tess, this.mothershipParent, 0.0, 20.0, 10.0, SkyProviderMothership.fixAngle((float)((double)this.currentCelestialAngle * (Math.PI * 2))));
            }
        } else {
            GL11.glRotatef((float)(-this.currentCelestialAngle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            this.renderPlanetByAngle(tess, this.mothershipParent, 0.0, 20.0, 15.0, 0.0);
        }
        GL11.glPopMatrix();
    }

    @Override
    protected boolean excludeBodyFromRendering(CelestialBody body) {
        return body.equals((Object)this.mothershipParent);
    }

    @Override
    protected void initVars() {
        if (((Mothership)this.curBody).isInTransit()) {
            this.curBodyPlanet = null;
            this.curSystem = null;
            this.mothershipParent = null;
            this.isInTransit = true;
            this.curWorldTime = -1L;
            this.jetDirection = ((MothershipWorldProvider)this.worldProvider).getTheoreticalTransitData() != null ? ((MothershipWorldProvider)this.worldProvider).getTheoreticalTransitData().direction : -1;
            this.clearAsteroidRenderList();
        } else {
            this.mothershipParent = ((Mothership)this.curBody).getParent();
            if (this.mothershipParent instanceof Planet) {
                this.rType = SkyProviderDynamic.RenderType.PLANET;
                this.curBodyPlanet = ((Mothership)this.curBody).getParent();
                this.curSystem = ((Planet)this.mothershipParent).getParentSolarSystem();
                this.curBodyDistance = this.mothershipParent.getRelativeDistanceFromCenter().unScaledDistance;
                this.sunSize = 1.0f / this.curBodyDistance;
            } else if (this.mothershipParent instanceof Moon) {
                this.rType = SkyProviderDynamic.RenderType.MOON;
                this.curBodyPlanet = ((Moon)this.mothershipParent).getParentPlanet();
                this.curSystem = ((Moon)this.mothershipParent).getParentPlanet().getParentSolarSystem();
                this.curBodyDistance = this.curBodyPlanet.getRelativeDistanceFromCenter().unScaledDistance;
                this.sunSize = 1.0f / this.curBodyDistance;
            } else if (this.mothershipParent instanceof Star) {
                this.rType = SkyProviderDynamic.RenderType.STAR;
                this.curBodyPlanet = this.curBody;
                this.curSystem = ((Star)this.mothershipParent).getParentSolarSystem();
                this.curBodyDistance = this.curBody.getRelativeDistanceFromCenter().unScaledDistance;
                this.sunSize = 5.0f;
            }
            this.checkAsteroidRendering(this.mothershipParent);
            this.isInTransit = false;
        }
        this.hasAtmosphere = false;
    }

    @Override
    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        if (this.isInTransit != ((Mothership)this.curBody).isInTransit()) {
            this.initVars();
        }
        if (!this.isInTransit) {
            super.render(partialTicks, world, mc);
        } else {
            this.renderTransitSky(partialTicks, world, mc);
        }
    }

    protected void renderTransitSky(float partialTicks, WorldClient world, Minecraft mc) {
        if (this.curWorldTime == -1L) {
            this.curWorldTime = world.func_72820_D();
        }
        this.transitOffset = partialTicks + (float)world.func_72820_D() - (float)this.curWorldTime;
        this.renderStarLines(this.transitOffset);
    }

    protected void renderStarLines(float curTime) {
        float angle = 0.0f;
        switch (this.jetDirection) {
            case 0: {
                angle = 180.0f;
                break;
            }
            case 1: {
                angle = 90.0f;
                break;
            }
            case 2: {
                angle = 0.0f;
                break;
            }
            case 3: {
                angle = 270.0f;
                break;
            }
            case -1: {
                if (((MothershipWorldProvider)this.worldProvider).getTheoreticalTransitData() != null) {
                    this.jetDirection = ((MothershipWorldProvider)this.worldProvider).getTheoreticalTransitData().direction;
                }
                return;
            }
        }
        Random starLineRand = new Random(10842L);
        GL11.glPushMatrix();
        GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        for (int starIndex = 0; starIndex < 400; ++starIndex) {
            double theta = starLineRand.nextDouble() * Math.PI * 2.0;
            double zBase = MathHelper.func_82716_a((Random)starLineRand, (double)0.0, (double)(this.cylinderLength * 2.0));
            zBase += (double)(curTime * this.starLineSpeed);
            zBase = zBase % (this.cylinderLength * 2.0) - this.cylinderLength;
            double x1 = Math.cos(theta - this.angleWidth) * this.skyBoxLength;
            double y1 = Math.sin(theta - this.angleWidth) * this.skyBoxLength;
            double x2 = Math.cos(theta + this.angleWidth) * this.skyBoxLength;
            double y2 = Math.sin(theta + this.angleWidth) * this.skyBoxLength;
            double length = starLineRand.nextDouble() * 20.0;
            if (zBase < -this.skyBoxLength || zBase + length > this.skyBoxLength) {
                x1 = x1 / zBase * this.skyBoxLength;
                y1 = y1 / zBase * this.skyBoxLength;
                x2 = x2 / zBase * this.skyBoxLength;
                y2 = y2 / zBase * this.skyBoxLength;
            }
            tess.func_78377_a(x1, y1, zBase);
            tess.func_78377_a(x1, y1, zBase + length);
            tess.func_78377_a(x2, y2, zBase + length);
            tess.func_78377_a(x2, y2, zBase);
        }
        tess.func_78381_a();
        GL11.glPopMatrix();
    }
}

