/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.helper;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerID {
    protected UUID userUUID;
    protected String userName;

    public PlayerID(UUID userUUID, String userName) {
        this.userUUID = userUUID;
        this.userName = userName;
    }

    public PlayerID(EntityPlayer player) {
        this.userUUID = player.func_110124_au();
        this.userName = player.getDisplayName();
    }

    public PlayerID(NBTTagCompound nbt) {
        String uuid = nbt.func_74779_i("uuid");
        this.userUUID = UUID.fromString(uuid);
        this.userName = nbt.func_74779_i("name");
    }

    public UUID getUUID() {
        return this.userUUID;
    }

    public String getName() {
        return this.userName;
    }

    public NBTTagCompound getNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("uuid", this.userUUID.toString());
        nbt.func_74778_a("name", this.userName);
        return nbt;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PlayerID)) {
            return false;
        }
        PlayerID playerID = (PlayerID)other;
        return playerID.userUUID.equals(this.userUUID);
    }

    public int hashCode() {
        return this.userUUID.hashCode();
    }

    public boolean isSameUser(EntityPlayer player) {
        return player == null ? false : this.userUUID.equals(player.func_110124_au());
    }
}

