/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.helper;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;

public class NbtHelper {
    public static NBTTagCompound getAsNBT(AxisAlignedBB aabb) {
        NBTTagCompound result = new NBTTagCompound();
        NbtHelper.writeToNBT(result, aabb);
        return result;
    }

    public static void writeToNBT(NBTTagCompound nbt, AxisAlignedBB aabb) {
        nbt.func_74780_a("minX", aabb.field_72340_a);
        nbt.func_74780_a("minY", aabb.field_72338_b);
        nbt.func_74780_a("minZ", aabb.field_72339_c);
        nbt.func_74780_a("maxX", aabb.field_72336_d);
        nbt.func_74780_a("maxY", aabb.field_72337_e);
        nbt.func_74780_a("maxZ", aabb.field_72334_f);
    }

    public static AxisAlignedBB readAABB(NBTTagCompound nbt) {
        return AxisAlignedBB.func_72330_a((double)nbt.func_74769_h("minX"), (double)nbt.func_74769_h("minY"), (double)nbt.func_74769_h("minZ"), (double)nbt.func_74769_h("maxX"), (double)nbt.func_74769_h("maxY"), (double)nbt.func_74769_h("maxZ"));
    }

    public static ItemStack[] readInventory(NBTTagCompound nbt, int inventorySize) {
        NBTTagList itemTag = nbt.func_150295_c("Items", 10);
        ItemStack[] result = new ItemStack[inventorySize];
        for (int i = 0; i < itemTag.func_74745_c(); ++i) {
            NBTTagCompound stackNbt = itemTag.func_150305_b(i);
            int slotNr = stackNbt.func_74771_c("Slot") & 0xFF;
            if (slotNr >= inventorySize) continue;
            result[slotNr] = ItemStack.func_77949_a((NBTTagCompound)stackNbt);
        }
        return result;
    }

    public static void writeInventory(NBTTagCompound nbt, ItemStack[] inventory) {
        NBTTagList list = new NBTTagList();
        int length = inventory.length;
        for (int i = 0; i < length; ++i) {
            if (inventory[i] == null) continue;
            NBTTagCompound stackNbt = new NBTTagCompound();
            stackNbt.func_74774_a("Slot", (byte)i);
            inventory[i].func_77955_b(stackNbt);
            list.func_74742_a((NBTBase)stackNbt);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }
}

