/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.network;

import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.ClientCache;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.TransferCache;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.utils.VPByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;

public class ProspectionSharing
implements IMessage {
    private static final int BYTES_OVERHEAD = 10;
    final List<OreVeinPosition> oreVeins = new ArrayList<OreVeinPosition>();
    final List<UndergroundFluidPosition> undergroundFluids = new ArrayList<UndergroundFluidPosition>();
    private int bytesUsed = 10;
    boolean isFirstMessage = false;
    boolean isLastMessage = false;

    public int putOreVeins(List<OreVeinPosition> oreVeins) {
        int availableBytes = VP.uploadSizePerPacketInBytes - this.bytesUsed;
        int maxAddedOreVeins = availableBytes / 14;
        int addedOreVeins = Math.min(oreVeins.size(), maxAddedOreVeins);
        this.oreVeins.addAll(oreVeins.subList(0, addedOreVeins));
        this.bytesUsed += addedOreVeins * 14;
        return addedOreVeins;
    }

    public int putOreUndergroundFluids(List<UndergroundFluidPosition> undergroundFluids) {
        int availableBytes = VP.uploadSizePerPacketInBytes - this.bytesUsed;
        int maxAddedUndergroundFluids = availableBytes / 272;
        int addedUndergroundFluids = Math.min(undergroundFluids.size(), maxAddedUndergroundFluids);
        this.undergroundFluids.addAll(undergroundFluids.subList(0, addedUndergroundFluids));
        this.bytesUsed += addedUndergroundFluids * 272;
        return addedUndergroundFluids;
    }

    public void setFirstMessage(boolean isFirstMessage) {
        this.isFirstMessage = isFirstMessage;
    }

    public void setLastMessage(boolean isLastMessage) {
        this.isLastMessage = isLastMessage;
    }

    public int getBytes() {
        return 10 + 14 * this.oreVeins.size() + 272 * this.undergroundFluids.size();
    }

    public void fromBytes(ByteBuf buf) {
        this.isFirstMessage = buf.readByte() > 0;
        this.isLastMessage = buf.readByte() > 0;
        this.oreVeins.addAll(VPByteBufUtils.ReadOreVeinPositions(buf));
        this.undergroundFluids.addAll(VPByteBufUtils.ReadUndergroundFluidPositions(buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.isFirstMessage ? 1 : 0);
        buf.writeByte(this.isLastMessage ? 1 : 0);
        VPByteBufUtils.WriteOreVeinPositions(buf, this.oreVeins);
        VPByteBufUtils.WriteUndergroundFluidPositions(buf, this.undergroundFluids);
    }

    public static class ClientHandler
    implements IMessageHandler<ProspectionSharing, IMessage> {
        private static List<OreVeinPosition> oreVeins;
        private static List<UndergroundFluidPosition> undergroundFluids;

        public IMessage onMessage(ProspectionSharing message, MessageContext ctx) {
            if (message.isFirstMessage) {
                oreVeins = new ArrayList<OreVeinPosition>();
                undergroundFluids = new ArrayList<UndergroundFluidPosition>();
            }
            if (oreVeins == null || undergroundFluids == null) {
                return null;
            }
            oreVeins.addAll(message.oreVeins);
            undergroundFluids.addAll(message.undergroundFluids);
            if (message.isLastMessage) {
                ClientCache.instance.putOreVeins(oreVeins);
                ClientCache.instance.putUndergroundFluids(undergroundFluids);
            }
            return null;
        }
    }

    public static class ServerHandler
    implements IMessageHandler<ProspectionSharing, IMessage> {
        private static final Map<EntityPlayerMP, List<OreVeinPosition>> oreVeins = new HashMap<EntityPlayerMP, List<OreVeinPosition>>();
        private static final Map<EntityPlayerMP, List<UndergroundFluidPosition>> undergroundFluids = new HashMap<EntityPlayerMP, List<UndergroundFluidPosition>>();

        public IMessage onMessage(ProspectionSharing message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (message.getBytes() > VP.uploadSizePerPacketInBytes) {
                player.field_71135_a.func_147360_c("Do not spam the server! Change your VisualProcessing configuration back to the servers!");
            }
            if (message.isFirstMessage) {
                oreVeins.put(player, new ArrayList());
                undergroundFluids.put(player, new ArrayList());
            }
            if (!oreVeins.containsKey(player) || !undergroundFluids.containsKey(player)) {
                return null;
            }
            oreVeins.get(player).addAll(message.oreVeins);
            undergroundFluids.get(player).addAll(message.undergroundFluids);
            if (message.isLastMessage) {
                TransferCache.instance.addClientProspectionData(player.getPersistentID().toString(), oreVeins.get(player), undergroundFluids.get(player));
                oreVeins.remove(player);
                undergroundFluids.remove(player);
            }
            return null;
        }
    }
}

