/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.utils;

import com.gtnewhorizon.gtnhlib.util.data.BlockMeta;
import com.gtnewhorizon.gtnhlib.util.data.IMod;
import com.gtnewhorizon.gtnhlib.util.data.ImmutableBlockMeta;
import com.gtnewhorizon.gtnhlib.util.data.ImmutableItemMeta;
import com.gtnewhorizon.gtnhlib.util.data.ItemMeta;
import com.recursive_pineapple.matter_manipulator.common.building.BlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.ImmutableBlockSpec;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class LazyBlockSpec
implements ImmutableItemMeta,
ImmutableBlockMeta {
    private volatile boolean loaded = false;
    protected boolean isBlock;
    protected boolean present;
    protected volatile ImmutableItemMeta im;
    protected volatile ImmutableBlockMeta bm;

    public static LazyBlockSpec ofBlock(final IMod mod, final String blockName, final int meta) {
        return new LazyBlockSpec(){
            {
                this.isBlock = true;
            }

            @Override
            protected void init() {
                this.present = mod.isModLoaded();
                if (!this.present) {
                    return;
                }
                Block block = GameRegistry.findBlock((String)mod.getID(), (String)blockName);
                Item item = Item.func_150898_a((Block)block);
                this.bm = new BlockMeta(block, meta);
                this.im = new ItemMeta(item, block.func_149692_a(meta));
            }
        };
    }

    public static LazyBlockSpec ofItem(final IMod mod, final String itemName, final int meta) {
        return new LazyBlockSpec(){
            {
                this.isBlock = false;
            }

            @Override
            protected void init() {
                this.present = mod.isModLoaded();
                if (!this.present) {
                    return;
                }
                Item item = GameRegistry.findItem((String)mod.getID(), (String)itemName);
                Block block = Block.func_149634_a((Item)item);
                this.im = new ItemMeta(item, meta);
                this.bm = new BlockMeta(block, item.func_77647_b(meta));
            }
        };
    }

    public static LazyBlockSpec ofBlock(final IMod mod, final String blockName, final int blockMeta, final String itemName, final int itemMeta) {
        return new LazyBlockSpec(){
            {
                this.isBlock = true;
            }

            @Override
            protected void init() {
                this.present = mod.isModLoaded();
                if (!this.present) {
                    return;
                }
                this.bm = new BlockMeta(GameRegistry.findBlock((String)mod.getID(), (String)blockName), blockMeta);
                this.im = new ItemMeta(GameRegistry.findItem((String)mod.getID(), (String)itemName), itemMeta);
            }
        };
    }

    private void ensureInited() {
        if (!this.loaded) {
            this.init();
            this.loaded = true;
        }
    }

    protected abstract void init();

    @NotNull
    public Block getBlock() {
        this.ensureInited();
        if (!this.present) {
            return null;
        }
        return this.bm.getBlock();
    }

    public int getBlockMeta() {
        this.ensureInited();
        if (!this.present) {
            return 0;
        }
        return this.bm.getBlockMeta();
    }

    @NotNull
    public Item getItem() {
        this.ensureInited();
        if (!this.present) {
            return null;
        }
        return this.im.getItem();
    }

    public int getItemMeta() {
        this.ensureInited();
        if (!this.present) {
            return 0;
        }
        return this.im.getItemMeta();
    }

    public BlockSpec toSpec() {
        this.ensureInited();
        if (!this.present) {
            return null;
        }
        if (this.isBlock) {
            return new BlockSpec().setObject(this.getBlock(), this.getBlockMeta());
        }
        return new BlockSpec().setObject(this.getItem(), this.getItemMeta());
    }

    public boolean matches(ItemStack stack) {
        this.ensureInited();
        return this.present && super.matches(stack);
    }

    public boolean matches(Item item, int meta) {
        this.ensureInited();
        return this.present && super.matches(item, meta);
    }

    public boolean matches(Block block, int meta) {
        this.ensureInited();
        return this.present && super.matches(block, meta);
    }

    public boolean matches(ImmutableBlockSpec spec) {
        this.ensureInited();
        if (!this.present) {
            return false;
        }
        if (this.isBlock) {
            return this.bm.matches(spec.getBlock(), spec.getBlockMeta());
        }
        return this.im.matches(spec.getItem(), spec.getItemMeta());
    }
}

