/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.persist;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class StaticEnumJsonAdapter<T extends Enum<T>>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    private final Class<T> clazz;
    private final T[] values;

    public StaticEnumJsonAdapter(Class<T> clazz) {
        this.clazz = clazz;
        this.values = (Enum[])clazz.getEnumConstants();
    }

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!(json instanceof JsonPrimitive)) {
            throw new JsonParseException("expected number: " + json);
        }
        JsonPrimitive primitive = (JsonPrimitive)json;
        if (primitive.isNumber()) {
            int index = primitive.getAsInt();
            if (index < 0 || index >= this.values.length) {
                throw new JsonParseException("illegal enum index: " + index);
            }
            return this.values[index];
        }
        try {
            return Enum.valueOf(this.clazz, primitive.getAsString());
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException("illegal enum variant: '" + primitive.getAsString() + "'", (Throwable)e);
        }
    }

    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive((Number)((Enum)src).ordinal());
    }
}

