/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.networking;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.recursive_pineapple.matter_manipulator.MMMod;
import com.recursive_pineapple.matter_manipulator.common.networking.MMPacket;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

@ChannelHandler.Sharable
public class Network
extends MessageToMessageCodec<FMLProxyPacket, MMPacket> {
    private final EnumMap<Side, FMLEmbeddedChannel> mChannel;
    private final MMPacket[] mSubChannels;

    public Network(String channelName, MMPacket ... packetTypes) {
        this.mChannel = NetworkRegistry.INSTANCE.newChannel(channelName, new ChannelHandler[]{this, new HandlerShared()});
        byte lastPId = packetTypes[packetTypes.length - 1].getPacketID();
        this.mSubChannels = new MMPacket[lastPId + 1];
        for (MMPacket packetType : packetTypes) {
            byte pId = packetType.getPacketID();
            if (this.mSubChannels[pId] != null) {
                throw new IllegalArgumentException("Duplicate Packet ID! " + pId);
            }
            this.mSubChannels[pId] = packetType;
        }
    }

    protected void encode(ChannelHandlerContext aContext, MMPacket aPacket, List<Object> aOutput) {
        ByteBuf tBuf = Unpooled.buffer().writeByte((int)aPacket.getPacketID());
        aPacket.encode(tBuf);
        aOutput.add(new FMLProxyPacket(tBuf, (String)aContext.channel().attr(NetworkRegistry.FML_CHANNEL).get()));
    }

    protected void decode(ChannelHandlerContext aContext, FMLProxyPacket aPacket, List<Object> aOutput) {
        ByteArrayDataInput aData = ByteStreams.newDataInput((byte[])aPacket.payload().array());
        MMPacket tPacket = this.mSubChannels[aData.readByte()].decode(aData);
        tPacket.setINetHandler(aPacket.handler());
        aOutput.add(tPacket);
    }

    public void sendToPlayer(MMPacket aPacket, EntityPlayerMP aPlayer) {
        if (aPacket == null) {
            MMMod.LOG.info("packet null");
            return;
        }
        if (aPlayer == null) {
            MMMod.LOG.info("player null");
            return;
        }
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)aPlayer);
        this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
    }

    public void sendToAllAround(MMPacket aPacket, NetworkRegistry.TargetPoint aPosition) {
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)aPosition);
        this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
    }

    public void sendToAll(MMPacket aPacket) {
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
    }

    public void sendToServer(MMPacket aPacket) {
        this.mChannel.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.mChannel.get(Side.CLIENT).writeAndFlush((Object)aPacket);
    }

    public void sendPacketToAllPlayersInRange(World aWorld, MMPacket aPacket, int aX, int aZ) {
        if (!aWorld.field_72995_K) {
            for (Object tObject : aWorld.field_73010_i) {
                if (!(tObject instanceof EntityPlayerMP)) break;
                EntityPlayerMP tPlayer = (EntityPlayerMP)tObject;
                Chunk tChunk = aWorld.func_72938_d(aX, aZ);
                if (!tPlayer.func_71121_q().func_73040_p().func_72694_a(tPlayer, tChunk.field_76635_g, tChunk.field_76647_h)) continue;
                this.sendToPlayer(aPacket, tPlayer);
            }
        }
    }

    @ChannelHandler.Sharable
    static final class HandlerShared
    extends SimpleChannelInboundHandler<MMPacket> {
        HandlerShared() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, MMPacket aPacket) {
            EntityPlayer aPlayer = MMMod.proxy.getThePlayer();
            aPacket.process((IBlockAccess)(aPlayer == null ? null : aPlayer.field_70170_p));
        }
    }
}

