/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Workers;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockRailBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.ISuppliesModule;
import vswe.stevescarts.Modules.Workers.ModuleWorker;
import vswe.stevescarts.Slots.SlotBase;
import vswe.stevescarts.Slots.SlotBridge;

public class ModuleBridge
extends ModuleWorker
implements ISuppliesModule {
    public ModuleBridge(MinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 80;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotBridge(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public byte getWorkPriority() {
        return 98;
    }

    @Override
    public boolean work() {
        Vec3 next = this.getNextblock();
        int x = (int)next.field_72450_a;
        int y = (int)next.field_72448_b;
        int z = (int)next.field_72449_c;
        int yLocation = this.getCart().getYTarget() > y ? y : (this.getCart().getYTarget() < y ? y - 2 : y - 1);
        if (!BlockRailBase.func_150049_b_((World)this.getCart().field_70170_p, (int)x, (int)y, (int)z) && !BlockRailBase.func_150049_b_((World)this.getCart().field_70170_p, (int)x, (int)(y - 1), (int)z)) {
            if (this.doPreWork()) {
                if (this.tryBuildBridge(x, yLocation, z, false)) {
                    this.startWorking(22);
                    this.setBridge(true);
                    return true;
                }
            } else if (this.tryBuildBridge(x, yLocation, z, true)) {
                this.stopWorking();
            }
        }
        this.setBridge(false);
        return false;
    }

    private boolean tryBuildBridge(int i, int j, int k, boolean flag) {
        Block b = this.getCart().field_70170_p.func_147439_a(i, j, k);
        if ((this.countsAsAir(i, j, k) || b instanceof BlockLiquid) && this.isValidForTrack(i, j + 1, k, false)) {
            for (int m = 0; m < this.getInventorySize(); ++m) {
                if (this.getStack(m) == null || !SlotBridge.isBridgeMaterial(this.getStack(m))) continue;
                if (flag) {
                    this.getCart().field_70170_p.func_147465_d(i, j, k, Block.func_149634_a((Item)this.getStack(m).func_77973_b()), ((ItemBlock)this.getStack(m).func_77973_b()).func_77647_b(this.getStack(m).func_77960_j()), 3);
                    if (!this.getCart().hasCreativeSupplies()) {
                        --this.getStack((int)m).field_77994_a;
                        if (this.getStack((int)m).field_77994_a == 0) {
                            this.setStack(m, null);
                        }
                        this.getCart().func_70296_d();
                    }
                }
                return true;
            }
            if (this.isValidForTrack(i, j, k, true) || this.isValidForTrack(i, j + 1, k, true) || !this.isValidForTrack(i, j + 2, k, true)) {
                // empty if block
            }
        }
        return false;
    }

    @Override
    public void initDw() {
        this.addDw(0, 0);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    private void setBridge(boolean val) {
        this.updateDw(0, val ? 1 : 0);
    }

    public boolean needBridge() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getNeedBridge();
        }
        return this.getDw(0) != 0;
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item == null || !SlotBridge.isBridgeMaterial(item)) continue;
            return true;
        }
        return false;
    }
}

