/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util.achievements;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import gregapi.data.IL;
import gregtech.api.enums.ItemList;
import java.util.HashMap;
import mods.railcraft.common.carts.EntityLocomotiveElectric;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ItemLocomotive;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.integration.railcraft.tile.TileLocomotiveRelay;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;

public class ComputronicsAchievements {
    public HashMap<String, Achievement> achievementMap = new HashMap();

    public void initialize() {
        this.initializeAchievements();
        AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage("Computronics", this.achievementMap.values().toArray(new Achievement[this.achievementMap.size()])));
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    private void initializeAchievements() {
        if (Computronics.itemTape != null) {
            this.registerAchievement(EnumAchievements.Tape, 0, 0, new ItemStack((Item)Computronics.itemTape, 1, 0), null, false, true);
            this.registerAchievement(EnumAchievements.Tape_Star, 4, 0, new ItemStack((Item)Computronics.itemTape, 1, 8), this.getAchievement(EnumAchievements.Tape), false, false);
            if (Mods.hasVersion("gregtech", "[MC1710]")) {
                this.registerAchievement(EnumAchievements.Tape_IG, 8, 2, new ItemStack((Item)Computronics.itemTape, 1, 9), this.getAchievement(EnumAchievements.Tape_Star), true, false);
                this.registerAchievement(EnumAchievements.Tape_IG_Dropped, 8, 10, ItemList.IC2_Scrap.get(1L, new Object[0]), this.getAchievement(EnumAchievements.Tape_IG), true, false);
            } else if (Mods.hasVersion("gregtech", "[GT6-MC1710]")) {
                this.registerAchievement(EnumAchievements.Tape_IG, 8, 2, new ItemStack((Item)Computronics.itemTape, 1, 9), this.getAchievement(EnumAchievements.Tape_Star), true, false);
                this.registerAchievement(EnumAchievements.Tape_IG_Dropped, 8, 10, IL.IC2_Scrap.get(1L, new Object[0]), this.getAchievement(EnumAchievements.Tape_IG), true, false);
            }
        }
        if (Mods.isLoaded("Railcraft")) {
            RailcraftAchievements.initializeRCAchievements();
        }
    }

    private Achievement registerAchievement(EnumAchievements key, int x, int y, ItemStack icon, Achievement requirement, boolean special, boolean independent) {
        Achievement achievement = new Achievement("computronics." + key.getKey(), "computronics." + key.getKey(), x, y, icon, requirement);
        if (special) {
            achievement.func_75987_b();
        }
        if (independent) {
            achievement.func_75966_h();
        }
        achievement.func_75971_g();
        this.achievementMap.put(key.getKey(), achievement);
        return achievement;
    }

    private void triggerAchievement(EntityPlayer player, EnumAchievements key) {
        if (player != null && this.achievementMap.containsKey(key.getKey())) {
            player.func_71029_a((StatBase)this.achievementMap.get(key.getKey()));
        }
    }

    public Achievement getAchievement(EnumAchievements key) {
        if (this.achievementMap.containsKey(key.getKey())) {
            return this.achievementMap.get(key.getKey());
        }
        return null;
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        ItemStack stack = event.crafting;
        EntityPlayer player = event.player;
        if (player == null || stack == null) {
            return;
        }
        if (Computronics.itemTape != null && stack.func_77973_b() == Computronics.itemTape) {
            switch (stack.func_77960_j()) {
                case 9: {
                    this.triggerAchievement(player, EnumAchievements.Tape_IG);
                    break;
                }
                case 4: 
                case 8: {
                    this.triggerAchievement(player, EnumAchievements.Tape_Star);
                    break;
                }
                default: {
                    this.triggerAchievement(player, EnumAchievements.Tape);
                    break;
                }
            }
        } else if (Mods.isLoaded("Railcraft")) {
            RailcraftAchievements.onCrafting(stack, player);
        }
    }

    @SubscribeEvent
    public void onLeftClickEntity(AttackEntityEvent event) {
        if (Mods.isLoaded("Railcraft")) {
            RailcraftAchievements.onLeftClickEntity(event);
        }
    }

    @SubscribeEvent
    public void onItemDropped(ItemTossEvent event) {
        if (event == null || event.player == null || event.entityItem == null || event.entityItem.field_70170_p != null && event.entityItem.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.player;
        EntityItem item = event.entityItem;
        ItemStack stack = item.func_92059_d();
        if (stack != null && Computronics.itemTape != null && stack.func_77973_b() == Computronics.itemTape && stack.func_77960_j() == 9) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound data = stack.func_77978_p();
            data.func_74778_a("computronics:dropplayer", player.func_70005_c_());
            stack.func_77982_d(data);
        }
    }

    @SubscribeEvent
    public void onItemDespawn(ItemExpireEvent event) {
        String playername;
        NBTTagCompound data;
        if (event == null || event.entityItem == null || event.entityItem.field_70170_p != null && event.entityItem.field_70170_p.field_72995_K) {
            return;
        }
        EntityItem item = event.entityItem;
        ItemStack stack = item.func_92059_d();
        if (stack != null && Computronics.itemTape != null && stack.func_77973_b() == Computronics.itemTape && stack.func_77960_j() == 9 && stack.func_77942_o() && (data = stack.func_77978_p()).func_74764_b("computronics:dropplayer") && (playername = data.func_74779_i("computronics:dropplayer")) != null && !playername.isEmpty()) {
            for (Object o : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                if (!(o instanceof EntityPlayer) || !((EntityPlayer)o).func_70005_c_().equals(playername)) continue;
                this.triggerAchievement((EntityPlayer)o, EnumAchievements.Tape_IG_Dropped);
                ((EntityPlayer)o).func_145747_a((IChatComponent)new ChatComponentText("Test"));
                data.func_82580_o("computronics:dropplayer");
                if (data.func_82582_d()) {
                    stack.func_77982_d(null);
                    continue;
                }
                stack.func_77982_d(data);
            }
        }
    }

    private static class RailcraftAchievements {
        private RailcraftAchievements() {
        }

        private static void initializeRCAchievements() {
            Computronics.instance.achievements.registerAchievement(EnumAchievements.Locomotive, 0, 4, EnumCart.LOCO_ELECTRIC.getCartItem(), null, false, true);
            Computronics.instance.achievements.registerAchievement(EnumAchievements.Relay, 2, 6, new ItemStack((Item)Computronics.railcraft.relaySensor), Computronics.instance.achievements.getAchievement(EnumAchievements.Locomotive), false, false);
        }

        private static void onCrafting(ItemStack stack, EntityPlayer player) {
            if (stack.func_77973_b() instanceof ItemLocomotive && ItemLocomotive.getModel((ItemStack)stack).equals(ItemLocomotive.getModel((ItemStack)EnumCart.LOCO_ELECTRIC.getCartItem()))) {
                Computronics.instance.achievements.triggerAchievement(player, EnumAchievements.Locomotive);
            }
        }

        private static void onLeftClickEntity(AttackEntityEvent event) {
            if (Mods.isLoaded("Railcraft") && event != null && event.target != null && event.target instanceof EntityLocomotiveElectric) {
                NBTTagCompound data;
                EntityPlayer player = event.entityPlayer;
                EntityLocomotiveElectric loco = (EntityLocomotiveElectric)event.target;
                if (player == null) {
                    return;
                }
                ItemStack stack = player.func_71045_bC();
                if (stack == null) {
                    return;
                }
                if (player.func_70093_af() && stack.func_77973_b() == Computronics.railcraft.relaySensor && stack.func_77942_o() && (data = stack.func_77978_p()) != null && data.func_74764_b("bound") && data.func_74767_n("bound")) {
                    int z;
                    int y;
                    int x = data.func_74762_e("relayX");
                    if (!player.field_70170_p.func_72899_e(x, y = data.func_74762_e("relayY"), z = data.func_74762_e("relayZ"))) {
                        return;
                    }
                    if (loco.field_70170_p.func_147438_o(x, y, z) != null && loco.field_70170_p.func_147438_o(x, y, z) instanceof TileLocomotiveRelay) {
                        TileLocomotiveRelay relay = (TileLocomotiveRelay)loco.field_70170_p.func_147438_o(x, y, z);
                        if (loco.field_71093_bK == relay.func_145831_w().field_73011_w.field_76574_g && loco.func_70092_e((double)relay.field_145851_c, (double)relay.field_145848_d, (double)relay.field_145849_e) <= Config.LOCOMOTIVE_RELAY_RANGE * Config.LOCOMOTIVE_RELAY_RANGE) {
                            Computronics.instance.achievements.triggerAchievement(player, EnumAchievements.Relay);
                        }
                    }
                }
            }
        }
    }

    private static enum EnumAchievements {
        Tape("gotTape"),
        Tape_Star("gotStarTape"),
        Tape_IG("gotIGTape"),
        Tape_IG_Dropped("droppedIGTape"),
        Locomotive("gotLoco"),
        Relay("gotRelay");

        String key;

        private EnumAchievements(String key) {
            this.key = key;
        }

        private String getKey() {
            return this.key;
        }
    }
}

