/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.Item;
import li.cil.oc.client.KeyBindings;
import li.cil.oc.util.ItemCosts;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import pl.asie.computronics.util.StringUtil;

public class OCUtils {
    private static final int maxWidth = 220;
    private static final EnumRarity[] rarities = new EnumRarity[]{EnumRarity.common, EnumRarity.uncommon, EnumRarity.rare, EnumRarity.epic};

    public static NBTTagCompound dataTag(ItemStack stack) {
        NBTTagCompound nbt;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(nbt = stack.func_77978_p()).func_74764_b("oc:data")) {
            nbt.func_74782_a("oc:data", (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l("oc:data");
    }

    @SideOnly(value=Side.CLIENT)
    public static void addTooltip(ItemStack stack, List tooltip, boolean advanced) {
        NBTTagCompound data;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String key = stack.func_77977_a() + ".tip";
        String tip = StringUtil.localize(key);
        if (!tip.equals(key)) {
            String[] lines = tip.split("\n");
            if (font == null) {
                Collections.addAll(tooltip, lines);
            } else {
                boolean shouldShorten;
                boolean bl = shouldShorten = font.func_78256_a(tip) > 220 && !KeyBindings.showExtendedTooltips();
                if (shouldShorten) {
                    tooltip.add(StringUtil.localizeAndFormat("oc:tooltip.TooLong", KeyBindings.getKeyBindingName((KeyBinding)KeyBindings.extendedTooltip())));
                } else {
                    for (String line : lines) {
                        List list = font.func_78271_c(line, 220);
                        tooltip.addAll(list);
                    }
                }
            }
        }
        if (ItemCosts.hasCosts((ItemStack)stack)) {
            if (KeyBindings.showMaterialCosts()) {
                ItemCosts.addTooltip((ItemStack)stack, (List)tooltip);
            } else {
                tooltip.add(StringUtil.localizeAndFormat("oc:tooltip.MaterialCosts", KeyBindings.getKeyBindingName((KeyBinding)KeyBindings.materialCosts())));
            }
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("oc:data") && (data = stack.func_77978_p().func_74775_l("oc:data")).func_74764_b("node") && data.func_74775_l("node").func_74764_b("address")) {
            tooltip.add(EnumChatFormatting.DARK_GRAY + data.func_74775_l("node").func_74779_i("address").substring(0, 13) + "..." + EnumChatFormatting.GRAY);
        }
        if (advanced) {
            Item item = Driver.driverFor((ItemStack)stack);
            tooltip.add(StringUtil.localizeAndFormat("oc:tooltip.Tier", item != null ? item.tier(stack) + 1 : 0));
        }
    }

    public static EnumRarity getRarityByTier(ItemStack stack) {
        Item item = Driver.driverFor((ItemStack)stack);
        int tier = item != null ? Math.min(Math.max(item.tier(stack), 0), rarities.length - 1) : 0;
        return rarities[tier];
    }

    public static EnumRarity getRarityByTier(int tier) {
        return rarities[Math.min(Math.max(tier, 0), rarities.length - 1)];
    }

    public static final class Vendors {
        public static final String ACME = "ACME Co.";
        public static final String BuildCraft = "BuildCraft, Inc.";
        public static final String DFKI = "DFKI GmbH";
        public static final String Hosencorp = "Hosencorp AG";
        public static final String HuggingCreeper = "Hugging Creeper Industries";
        public static final String Lumiose = "Lumiose Lighting";
        public static final String NSA = "National Security Agency";
        public static final String Railcraft = "Railcraft, Inc.";
        public static final String Siekierka = "Siekierka Innovations";
        public static final String Soluna = "Soluna Technologies";
        public static final String Trumbour = "Trumbour Technology";
        public static final String Yanaki = "Yanaki Sound Systems";

        private Vendors() {
        }
    }

    public static class Device {
        private final String Class;
        private final String Description;
        private final String Vendor;
        private final String Product;
        private final String[] other;

        public Device(String Class2, String Description, String Vendor, String Product, String ... other) {
            this.Class = Class2;
            this.Description = Description;
            this.Vendor = Vendor;
            this.Product = Product;
            this.other = other;
        }

        public Map<String, String> deviceInfo() {
            HashMap<String, String> deviceInfo = new HashMap<String, String>();
            deviceInfo.put("class", this.Class);
            deviceInfo.put("description", this.Description);
            deviceInfo.put("vendor", this.Vendor);
            deviceInfo.put("product", this.Product);
            int i = 0;
            while (i + 1 < this.other.length) {
                deviceInfo.put(this.other[i], this.other[i + 1]);
                i += 2;
            }
            return deviceInfo;
        }
    }
}

