/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import java.util.function.BiFunction;
import net.glease.tc4tweak.asm.ASMUtils;
import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class HashCodeVisitor
extends ClassVisitor {
    private final String targetName;
    private String className;
    private boolean visited;

    public static BiFunction<Integer, ClassVisitor, ClassVisitor> factory(String targetName) {
        return (api, cv) -> new HashCodeVisitor((int)api, (ClassVisitor)cv, targetName);
    }

    public HashCodeVisitor(int api, ClassVisitor cv) {
        this(api, cv, "hash");
    }

    public HashCodeVisitor(int api, ClassVisitor cv, String targetName) {
        super(api, cv);
        this.targetName = targetName;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, this.className, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("hashCode") && desc.equals("()I")) {
            TC4Transformer.log.debug("Replacing hashCode()I");
            ASMUtils.writeOverwrite("net/glease/tc4tweak/asm/ASMCallhookServer", this.targetName, mv, this.className, desc);
            this.visited = true;
            return null;
        }
        return mv;
    }

    public void visitEnd() {
        if (!this.visited) {
            TC4Transformer.log.debug("Adding {}#hashCode()I", new Object[]{this.className});
            MethodVisitor mv = super.visitMethod(1, "hashCode", "()I", null, null);
            ASMUtils.writeOverwrite("net/glease/tc4tweak/asm/ASMCallhookServer", this.targetName, mv, this.className, null);
            this.visited = true;
        }
        super.visitEnd();
    }
}

