/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import stevesaddons.api.IHiddenInventory;
import stevesaddons.api.IHiddenTank;
import stevesaddons.components.AdvancedOutputItemCounter;
import stevesaddons.components.AdvancedSlotInventoryHolder;
import stevesaddons.components.ComponentMenuRFCondition;
import stevesaddons.components.ComponentMenuTargetRF;
import stevesaddons.components.ComponentMenuTriggered;
import stevesaddons.components.EnergyFacingHolder;
import stevesaddons.components.RFBufferElement;
import stevesaddons.helpers.StevesEnum;
import stevesaddons.tileentities.TileEntityRFNode;
import vswe.stevesfactory.blocks.ConnectionBlock;
import vswe.stevesfactory.blocks.ConnectionBlockType;
import vswe.stevesfactory.blocks.TileEntityCreative;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.components.CommandExecutor;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.ComponentMenuCamouflageInside;
import vswe.stevesfactory.components.ComponentMenuCamouflageItems;
import vswe.stevesfactory.components.ComponentMenuCamouflageShape;
import vswe.stevesfactory.components.ComponentMenuCamouflageSides;
import vswe.stevesfactory.components.ComponentMenuContainer;
import vswe.stevesfactory.components.ComponentMenuContainerScrap;
import vswe.stevesfactory.components.ComponentMenuContainerTypes;
import vswe.stevesfactory.components.ComponentMenuCrafting;
import vswe.stevesfactory.components.ComponentMenuCraftingPriority;
import vswe.stevesfactory.components.ComponentMenuListOrder;
import vswe.stevesfactory.components.ComponentMenuPulse;
import vswe.stevesfactory.components.ComponentMenuRedstoneOutput;
import vswe.stevesfactory.components.ComponentMenuRedstoneSidesEmitter;
import vswe.stevesfactory.components.ComponentMenuSignText;
import vswe.stevesfactory.components.ComponentMenuSplit;
import vswe.stevesfactory.components.ComponentMenuStuff;
import vswe.stevesfactory.components.ComponentMenuTarget;
import vswe.stevesfactory.components.ComponentMenuTargetInventory;
import vswe.stevesfactory.components.ComponentMenuTargetTank;
import vswe.stevesfactory.components.ComponentMenuVariable;
import vswe.stevesfactory.components.ComponentMenuVariableLoop;
import vswe.stevesfactory.components.ConditionSettingChecker;
import vswe.stevesfactory.components.Connection;
import vswe.stevesfactory.components.ConnectionOption;
import vswe.stevesfactory.components.CraftingBufferFluidElement;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.IConditionStuffMenu;
import vswe.stevesfactory.components.IItemBufferElement;
import vswe.stevesfactory.components.IItemBufferSubElement;
import vswe.stevesfactory.components.ItemBufferElement;
import vswe.stevesfactory.components.ItemSetting;
import vswe.stevesfactory.components.LiquidBufferElement;
import vswe.stevesfactory.components.LiquidSetting;
import vswe.stevesfactory.components.OutputLiquidCounter;
import vswe.stevesfactory.components.Setting;
import vswe.stevesfactory.components.SlotInventoryHolder;
import vswe.stevesfactory.components.SlotSideTarget;
import vswe.stevesfactory.components.SlotStackInventoryHolder;
import vswe.stevesfactory.components.StackTankHolder;
import vswe.stevesfactory.components.Variable;
import vswe.stevesfactory.components.VariableColor;

public class CommandExecutorRF
extends CommandExecutor {
    private TileEntityManager manager;
    private List<RFBufferElement> rfBuffer;
    private List<CraftingBufferFluidElement> craftingBufferHigh;
    private List<CraftingBufferFluidElement> craftingBufferLow;
    private List<Integer> usedCommands;
    public static final int MAX_FLUID_TRANSFER = 10000000;

    public CommandExecutorRF(TileEntityManager manager) {
        super(manager);
        this.manager = manager;
        this.itemBuffer = new ArrayList();
        this.craftingBufferHigh = new ArrayList<CraftingBufferFluidElement>();
        this.craftingBufferLow = new ArrayList<CraftingBufferFluidElement>();
        this.rfBuffer = new ArrayList<RFBufferElement>();
        this.liquidBuffer = new ArrayList();
        this.usedCommands = new ArrayList<Integer>();
    }

    private CommandExecutorRF(TileEntityManager manager, List<ItemBufferElement> itemBufferSplit, List<CraftingBufferFluidElement> craftingBufferHighSplit, List<CraftingBufferFluidElement> craftingBufferLowSplit, List<LiquidBufferElement> liquidBufferSplit, List<RFBufferElement> rfBuffer, List<Integer> usedCommandCopy) {
        super(manager);
        this.manager = manager;
        this.itemBuffer = itemBufferSplit;
        this.craftingBufferHigh = craftingBufferHighSplit;
        this.craftingBufferLow = craftingBufferLowSplit;
        this.usedCommands = usedCommandCopy;
        this.rfBuffer = rfBuffer;
        this.liquidBuffer = liquidBufferSplit;
    }

    public void executeTriggerCommand(FlowComponent command, EnumSet<ConnectionOption> validTriggerOutputs) {
        for (Variable variable : this.manager.getVariables()) {
            if (!variable.isValid() || variable.hasBeenExecuted() && ((ComponentMenuVariable)variable.getDeclaration().getMenus().get(0)).getVariableMode() != ComponentMenuVariable.VariableMode.LOCAL) continue;
            this.executeCommand(variable.getDeclaration(), 0);
            variable.setExecuted(true);
        }
        this.executeChildCommands(command, validTriggerOutputs);
    }

    private void executeChildCommands(FlowComponent command, EnumSet<ConnectionOption> validTriggerOutputs) {
        for (int i = 0; i < command.getConnectionSet().getConnections().length; ++i) {
            Connection connection = command.getConnection(i);
            ConnectionOption option = command.getConnectionSet().getConnections()[i];
            if (connection == null || option.isInput() || !validTriggerOutputs.contains(option)) continue;
            this.executeCommand((FlowComponent)this.manager.getFlowItems().get(connection.getComponentId()), connection.getConnectionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(FlowComponent command, int connectionId) {
        if (!this.usedCommands.contains(command.getId())) {
            try {
                this.usedCommands.add(command.getId());
                switch (command.getType().ordinal()) {
                    case 0: {
                        ComponentMenuTriggered trigger = (ComponentMenuTriggered)((Object)command.getMenus().get(6));
                        trigger.setCountdown();
                        return;
                    }
                    case 1: {
                        List<SlotInventoryHolder> inputInventory = this.getInventories((ComponentMenu)command.getMenus().get(0));
                        if (inputInventory == null) break;
                        this.getValidSlots((ComponentMenu)command.getMenus().get(1), inputInventory, true);
                        this.getItems((ComponentMenu)command.getMenus().get(2), inputInventory);
                        break;
                    }
                    case 2: {
                        List<SlotInventoryHolder> outputInventory = this.getInventories((ComponentMenu)command.getMenus().get(0));
                        if (outputInventory == null) break;
                        this.getValidSlots((ComponentMenu)command.getMenus().get(1), outputInventory, true);
                        this.insertItems((ComponentMenu)command.getMenus().get(2), outputInventory);
                        break;
                    }
                    case 3: {
                        List<SlotInventoryHolder> conditionInventory = this.getInventories((ComponentMenu)command.getMenus().get(0));
                        if (conditionInventory != null) {
                            this.getValidSlots((ComponentMenu)command.getMenus().get(1), conditionInventory, false);
                            if (this.searchForStuff((ComponentMenu)command.getMenus().get(2), conditionInventory, false)) {
                                this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_TRUE));
                            } else {
                                this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_FALSE));
                            }
                            return;
                        }
                        return;
                    }
                    case 4: {
                        if (!ComponentMenuSplit.isSplitConnection((FlowComponent)command) || !this.splitFlow((ComponentMenu)command.getMenus().get(0))) break;
                        return;
                    }
                    case 5: {
                        List<SlotInventoryHolder> inputTank = this.getTanks((ComponentMenu)command.getMenus().get(0));
                        if (inputTank == null) break;
                        this.getValidTanks((ComponentMenu)command.getMenus().get(1), inputTank);
                        this.getLiquids((ComponentMenu)command.getMenus().get(2), inputTank);
                        break;
                    }
                    case 6: {
                        List<SlotInventoryHolder> outputTank = this.getTanks((ComponentMenu)command.getMenus().get(0));
                        if (outputTank == null) break;
                        this.getValidTanks((ComponentMenu)command.getMenus().get(1), outputTank);
                        this.insertLiquids((ComponentMenu)command.getMenus().get(2), outputTank);
                        break;
                    }
                    case 7: {
                        List<SlotInventoryHolder> conditionTank = this.getTanks((ComponentMenu)command.getMenus().get(0));
                        if (conditionTank != null) {
                            this.getValidTanks((ComponentMenu)command.getMenus().get(1), conditionTank);
                            if (this.searchForStuff((ComponentMenu)command.getMenus().get(2), conditionTank, true)) {
                                this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_TRUE));
                            } else {
                                this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_FALSE));
                            }
                            return;
                        }
                        return;
                    }
                    case 8: {
                        List<SlotInventoryHolder> emitters = this.getEmitters((ComponentMenu)command.getMenus().get(0));
                        if (emitters == null) break;
                        for (SlotInventoryHolder emitter : emitters) {
                            emitter.getEmitter().updateState((ComponentMenuRedstoneSidesEmitter)command.getMenus().get(1), (ComponentMenuRedstoneOutput)command.getMenus().get(2), (ComponentMenuPulse)command.getMenus().get(3));
                        }
                        break;
                    }
                    case 9: {
                        List<SlotInventoryHolder> nodes = this.getNodes((ComponentMenu)command.getMenus().get(0));
                        if (nodes != null) {
                            if (this.evaluateRedstoneCondition(nodes, command)) {
                                this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_TRUE));
                            } else {
                                this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_FALSE));
                            }
                            return;
                        }
                        return;
                    }
                    case 10: {
                        List<SlotInventoryHolder> tiles = this.getTiles((ComponentMenu)command.getMenus().get(2));
                        if (tiles == null) break;
                        this.updateVariable(tiles, (ComponentMenuVariable)command.getMenus().get(0), (ComponentMenuListOrder)command.getMenus().get(3));
                        break;
                    }
                    case 11: {
                        this.updateForLoop(command, (ComponentMenuVariableLoop)command.getMenus().get(0), (ComponentMenuContainerTypes)command.getMenus().get(1), (ComponentMenuListOrder)command.getMenus().get(2));
                        this.executeChildCommands(command, EnumSet.of(ConnectionOption.STANDARD_OUTPUT));
                        return;
                    }
                    case 12: {
                        CraftingBufferFluidElement element = new CraftingBufferFluidElement(this, (ComponentMenuCrafting)command.getMenus().get(0), (ComponentMenuContainerScrap)command.getMenus().get(2));
                        if (((ComponentMenuCraftingPriority)command.getMenus().get(1)).shouldPrioritizeCrafting()) {
                            this.craftingBufferHigh.add(element);
                            break;
                        }
                        this.craftingBufferLow.add(element);
                        break;
                    }
                    case 13: {
                        if (connectionId < command.getChildrenInputNodes().size()) {
                            this.executeChildCommands((FlowComponent)command.getChildrenInputNodes().get(connectionId), EnumSet.allOf(ConnectionOption.class));
                        }
                        return;
                    }
                    case 14: {
                        FlowComponent parent = command.getParent();
                        if (parent != null) {
                            for (int var28 = 0; var28 < parent.getChildrenOutputNodes().size(); ++var28) {
                                if (!command.equals(parent.getChildrenOutputNodes().get(var28))) continue;
                                Connection var30 = parent.getConnection(parent.getConnectionSet().getInputCount() + var28);
                                if (var30 != null) {
                                    this.executeCommand((FlowComponent)this.manager.getFlowItems().get(var30.getComponentId()), var30.getConnectionId());
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 15: {
                        List<SlotInventoryHolder> camouflage = this.getCamouflage((ComponentMenu)command.getMenus().get(0));
                        if (camouflage == null) break;
                        ComponentMenuCamouflageShape var29 = (ComponentMenuCamouflageShape)command.getMenus().get(1);
                        ComponentMenuCamouflageInside var31 = (ComponentMenuCamouflageInside)command.getMenus().get(2);
                        ComponentMenuCamouflageSides var32 = (ComponentMenuCamouflageSides)command.getMenus().get(3);
                        ComponentMenuCamouflageItems items = (ComponentMenuCamouflageItems)command.getMenus().get(4);
                        if (!items.isFirstRadioButtonSelected() && !((Setting)items.getSettings().get(0)).isValid()) break;
                        ItemStack itemStack = items.isFirstRadioButtonSelected() ? null : ((ItemSetting)items.getSettings().get(0)).getItem();
                        for (SlotInventoryHolder slotInventoryHolder : camouflage) {
                            slotInventoryHolder.getCamouflage().setBounds(var29);
                            for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                                if (!var32.isSideRequired(i)) continue;
                                slotInventoryHolder.getCamouflage().setItem(itemStack, i, var31.getCurrentType());
                            }
                        }
                        break;
                    }
                    case 16: {
                        List<SlotInventoryHolder> sign = this.getSign((ComponentMenu)command.getMenus().get(0));
                        if (sign == null) break;
                        for (SlotInventoryHolder slotInventoryHolder : sign) {
                            slotInventoryHolder.getSign().updateSign((ComponentMenuSignText)command.getMenus().get(1));
                        }
                        break;
                    }
                    case 17: {
                        List<SlotInventoryHolder> inputStorage = this.getRFInput((ComponentMenu)command.getMenus().get(0));
                        if (inputStorage == null) break;
                        this.getInputRF((ComponentMenu)command.getMenus().get(1), inputStorage);
                        break;
                    }
                    case 18: {
                        List<SlotInventoryHolder> outputStorage = this.getRFOutput((ComponentMenu)command.getMenus().get(0));
                        if (outputStorage == null) break;
                        this.insertRF((ComponentMenu)command.getMenus().get(1), outputStorage);
                        break;
                    }
                    case 19: {
                        List<SlotInventoryHolder> conditionStorage = this.getRFStorage((ComponentMenu)command.getMenus().get(0));
                        if (conditionStorage == null) break;
                        this.getValidRFStorage((ComponentMenu)command.getMenus().get(1), conditionStorage);
                        if (this.searchForPower((ComponentMenuRFCondition)((Object)command.getMenus().get(2)), conditionStorage)) {
                            this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_TRUE));
                        } else {
                            this.executeChildCommands(command, EnumSet.of(ConnectionOption.CONDITION_FALSE));
                        }
                        return;
                    }
                }
                this.executeChildCommands(command, EnumSet.allOf(ConnectionOption.class));
            }
            finally {
                this.usedCommands.remove((Object)command.getId());
            }
        }
    }

    private List<SlotInventoryHolder> getEmitters(ComponentMenu componentMenu) {
        return CommandExecutorRF.getContainers(this.manager, componentMenu, ConnectionBlockType.EMITTER);
    }

    private List<SlotInventoryHolder> getInventories(ComponentMenu componentMenu) {
        return CommandExecutorRF.getContainers(this.manager, componentMenu, ConnectionBlockType.INVENTORY);
    }

    private List<SlotInventoryHolder> getTanks(ComponentMenu componentMenu) {
        return CommandExecutorRF.getContainers(this.manager, componentMenu, ConnectionBlockType.TANK);
    }

    private List<SlotInventoryHolder> getRFInput(ComponentMenu componentMenu) {
        return CommandExecutorRF.getContainers(this.manager, componentMenu, StevesEnum.RF_PROVIDER);
    }

    private List<SlotInventoryHolder> getRFOutput(ComponentMenu componentMenu) {
        return CommandExecutorRF.getContainers(this.manager, componentMenu, StevesEnum.RF_RECEIVER);
    }

    private List<SlotInventoryHolder> getRFStorage(ComponentMenu componentMenu) {
        return CommandExecutorRF.getContainers(this.manager, componentMenu, StevesEnum.RF_CONNECTION);
    }

    private List<SlotInventoryHolder> getNodes(ComponentMenu componentMenu) {
        return CommandExecutorRF.getContainers(this.manager, componentMenu, ConnectionBlockType.NODE);
    }

    private List<SlotInventoryHolder> getCamouflage(ComponentMenu componentMenu) {
        return CommandExecutorRF.getContainers(this.manager, componentMenu, ConnectionBlockType.CAMOUFLAGE);
    }

    private List<SlotInventoryHolder> getSign(ComponentMenu componentMenu) {
        return CommandExecutorRF.getContainers(this.manager, componentMenu, ConnectionBlockType.SIGN);
    }

    private List<SlotInventoryHolder> getTiles(ComponentMenu componentMenu) {
        return CommandExecutorRF.getContainers(this.manager, componentMenu, null);
    }

    public static List<SlotInventoryHolder> getContainers(TileEntityManager manager, ComponentMenu componentMenu, ConnectionBlockType type) {
        int i;
        if (!(componentMenu instanceof ComponentMenuContainer)) {
            return null;
        }
        ComponentMenuContainer menuContainer = (ComponentMenuContainer)componentMenu;
        if (menuContainer.getSelectedInventories().size() == 0) {
            return null;
        }
        ArrayList<SlotInventoryHolder> ret = new ArrayList<SlotInventoryHolder>();
        List inventories = manager.getConnectedInventories();
        Variable[] variables = manager.getVariables();
        for (i = 0; i < variables.length; ++i) {
            Variable selected = variables[i];
            if (!selected.isValid()) continue;
            Iterator iterator = menuContainer.getSelectedInventories().iterator();
            while (iterator.hasNext()) {
                int val = (Integer)iterator.next();
                if (val != i) continue;
                List selection = selected.getContainers();
                Iterator i$1 = selection.iterator();
                while (i$1.hasNext()) {
                    int selected1 = (Integer)i$1.next();
                    CommandExecutorRF.addContainer(inventories, ret, selected1, menuContainer, type, ((ComponentMenuContainerTypes)selected.getDeclaration().getMenus().get(1)).getValidTypes());
                }
                break block1;
            }
        }
        for (i = 0; i < menuContainer.getSelectedInventories().size(); ++i) {
            int var14 = (Integer)menuContainer.getSelectedInventories().get(i) - VariableColor.values().length;
            CommandExecutorRF.addContainer(inventories, ret, var14, menuContainer, type, EnumSet.allOf(ConnectionBlockType.class));
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    private static void addContainer(List<ConnectionBlock> inventories, List<SlotInventoryHolder> ret, int selected, ComponentMenuContainer menuContainer, ConnectionBlockType requestType, EnumSet<ConnectionBlockType> variableType) {
        ConnectionBlock connection;
        if (selected >= 0 && selected < inventories.size() && (connection = inventories.get(selected)).isOfType(requestType) && connection.isOfAnyType(variableType) && !connection.getTileEntity().func_145837_r() && !CommandExecutorRF.containsTe(ret, connection.getTileEntity())) {
            ret.add(new AdvancedSlotInventoryHolder(selected, connection.getTileEntity(), menuContainer.getOption()));
        }
    }

    private static boolean containsTe(List<SlotInventoryHolder> lst, TileEntity te) {
        SlotInventoryHolder slotInventoryHolder;
        Iterator<SlotInventoryHolder> i$ = lst.iterator();
        do {
            if (!i$.hasNext()) {
                return false;
            }
            slotInventoryHolder = i$.next();
        } while (slotInventoryHolder.getTile().field_145851_c != te.field_145851_c || slotInventoryHolder.getTile().field_145848_d != te.field_145848_d || slotInventoryHolder.getTile().field_145849_e != te.field_145849_e || !slotInventoryHolder.getTile().getClass().equals(te.getClass()));
        return true;
    }

    private void getValidSlots(ComponentMenu componentMenu, List<SlotInventoryHolder> inventories, boolean sided) {
        ComponentMenuTargetInventory menuTarget = (ComponentMenuTargetInventory)componentMenu;
        for (SlotInventoryHolder slotInventoryHolder : inventories) {
            if (slotInventoryHolder.getTile() instanceof IHiddenInventory) continue;
            IInventory inventory = slotInventoryHolder.getInventory();
            Map validSlots = slotInventoryHolder.getValidSlots();
            for (int side = 0; side < ComponentMenuTarget.directions.length; ++side) {
                int end;
                int start;
                int[] inventoryValidSlots;
                if (!menuTarget.isActive(side)) continue;
                if (sided && inventory instanceof ISidedInventory) {
                    inventoryValidSlots = ((ISidedInventory)inventory).func_94128_d(side);
                } else {
                    inventoryValidSlots = new int[inventory.func_70302_i_()];
                    start = 0;
                    while (start < inventoryValidSlots.length) {
                        inventoryValidSlots[start] = start++;
                    }
                }
                if (menuTarget.useAdvancedSetting(side)) {
                    start = menuTarget.getStart(side);
                    end = menuTarget.getEnd(side);
                } else {
                    start = 0;
                    end = inventory.func_70302_i_();
                }
                if (start > end) continue;
                for (int inventoryValidSlot : inventoryValidSlots) {
                    if (inventoryValidSlot < start || inventoryValidSlot > end) continue;
                    SlotSideTarget target = (SlotSideTarget)validSlots.get(inventoryValidSlot);
                    if (target == null) {
                        validSlots.put(inventoryValidSlot, new SlotSideTarget(inventoryValidSlot, side));
                        continue;
                    }
                    target.addSide(side);
                }
            }
        }
    }

    private void getValidRFStorage(ComponentMenu componentMenu, List<SlotInventoryHolder> cells) {
        ComponentMenuTargetRF menuTarget = (ComponentMenuTargetRF)componentMenu;
        ArrayList<SlotInventoryHolder> result = new ArrayList<SlotInventoryHolder>();
        block0: for (SlotInventoryHolder cell1 : cells) {
            IEnergyConnection cell = (IEnergyConnection)cell1.getTile();
            if (cell == null || cell1.getTile() instanceof TileEntityRFNode || !(cell instanceof IEnergyReceiver) && !(cell instanceof IEnergyProvider)) continue;
            for (int side = 0; side < ComponentMenuTarget.directions.length; ++side) {
                if (!menuTarget.isActive(side) || !cell.canConnectEnergy(ForgeDirection.getOrientation((int)side))) continue;
                result.add(cell1);
                continue block0;
            }
        }
        cells = result;
    }

    private boolean searchForPower(ComponentMenuRFCondition componentMenu, List<SlotInventoryHolder> cells) {
        int total = 0;
        block0: for (SlotInventoryHolder cell1 : cells) {
            IEnergyConnection cell = (IEnergyConnection)cell1.getTile();
            if (!(cell instanceof IEnergyReceiver) && !(cell instanceof IEnergyProvider)) continue;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int stored = cell instanceof IEnergyReceiver ? ((IEnergyReceiver)cell).getEnergyStored(dir) : ((IEnergyProvider)cell).getEnergyStored(dir);
                if (stored <= 0) continue;
                total += stored;
                continue block0;
            }
        }
        return total < componentMenu.getAmount() == componentMenu.isLessThan();
    }

    private void getInputRF(ComponentMenu componentMenu, List<SlotInventoryHolder> inputStorage) {
        ComponentMenuTargetRF menuTarget = (ComponentMenuTargetRF)componentMenu;
        List<Integer> validSides = this.getValidSides(menuTarget);
        block0: for (SlotInventoryHolder anInputStorage : inputStorage) {
            IEnergyProvider cell = (IEnergyProvider)anInputStorage.getTile();
            if (cell == null) continue;
            for (int side : validSides) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                int extractEnergy = cell.extractEnergy(dir, Integer.MAX_VALUE, true);
                if (extractEnergy <= 0) continue;
                this.rfBuffer.add(new RFBufferElement(componentMenu.getParent(), anInputStorage, new EnergyFacingHolder(cell, dir)));
                continue block0;
            }
        }
    }

    private List<Integer> getValidSides(ComponentMenuTargetRF menuTarget) {
        ArrayList<Integer> validDirections = new ArrayList<Integer>();
        for (int side = 0; side < ComponentMenuTarget.directions.length; ++side) {
            if (!menuTarget.isActive(side)) continue;
            validDirections.add(side);
        }
        return validDirections;
    }

    private void insertRF(ComponentMenu componentMenu, List<SlotInventoryHolder> outputStorage) {
        ComponentMenuTargetRF menuTarget = (ComponentMenuTargetRF)componentMenu;
        long bufferSize = 0L;
        for (RFBufferElement rfElement : this.rfBuffer) {
            bufferSize += (long)rfElement.getMaxExtract();
        }
        List<Integer> validSides = this.getValidSides(menuTarget);
        ArrayList<IEnergyReceiver> validOutputs = new ArrayList<IEnergyReceiver>();
        block1: for (SlotInventoryHolder holder : outputStorage) {
            IEnergyReceiver cell = (IEnergyReceiver)holder.getTile();
            if (cell == null) continue;
            for (int side : validSides) {
                int maxReceive = cell.receiveEnergy(ForgeDirection.getOrientation((int)side), Integer.MAX_VALUE, true);
                if (maxReceive <= 0) continue;
                validOutputs.add(cell);
                continue block1;
            }
        }
        this.insertRF(validSides.toArray(new Integer[validSides.size()]), validOutputs, bufferSize);
    }

    private void insertRF(Integer[] directions, List<IEnergyReceiver> validOutputs, long bufferSize) {
        int n;
        Iterator<IEnergyReceiver> itr = validOutputs.iterator();
        while (itr.hasNext()) {
            int side;
            IEnergyReceiver cell = itr.next();
            int maxReceive = 0;
            Integer[] integerArray = directions;
            int n2 = integerArray.length;
            for (n = 0; n < n2 && (maxReceive = cell.receiveEnergy(ForgeDirection.getOrientation((int)(side = integerArray[n].intValue())), Integer.MAX_VALUE, true)) <= 0; ++n) {
            }
            if (maxReceive != 0) continue;
            itr.remove();
        }
        int inserted = validOutputs.size();
        Iterator<IEnergyReceiver> itr2 = validOutputs.iterator();
        while (itr2.hasNext() && !this.rfBuffer.isEmpty()) {
            IEnergyReceiver cell = itr2.next();
            int maxReceive = (int)(bufferSize / (long)inserted);
            Integer[] integerArray = directions;
            n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int side = integerArray[i];
                int insert = cell.receiveEnergy(ForgeDirection.getOrientation((int)side), maxReceive, false);
                if (insert <= 0) continue;
                if (insert < maxReceive) {
                    itr2.remove();
                }
                this.removeRF(insert);
                bufferSize -= (long)insert;
                break;
            }
            --inserted;
        }
        if (bufferSize > 0L && validOutputs.size() > 0 && !this.rfBuffer.isEmpty()) {
            this.insertRF(directions, validOutputs, bufferSize);
        }
    }

    private void removeRF(int amount) {
        int remove = amount / this.rfBuffer.size();
        Iterator<RFBufferElement> itr = this.rfBuffer.iterator();
        while (itr.hasNext()) {
            int removed = itr.next().removeRF(remove);
            if (removed < remove) {
                itr.remove();
            }
            amount -= removed;
        }
        if (amount > 0 && remove > 0 && this.rfBuffer.size() > 0) {
            this.removeRF(amount);
        }
    }

    private boolean isSlotValid(IInventory inventory, ItemStack item, SlotSideTarget slot, boolean isInput) {
        if (item == null) {
            return false;
        }
        if (inventory instanceof ISidedInventory) {
            boolean hasValidSide = false;
            Iterator iterator = slot.getSides().iterator();
            while (iterator.hasNext()) {
                int side = (Integer)iterator.next();
                if (isInput && ((ISidedInventory)inventory).func_102008_b(slot.getSlot(), item, side)) {
                    hasValidSide = true;
                    break;
                }
                if (isInput || !((ISidedInventory)inventory).func_102007_a(slot.getSlot(), item, side)) continue;
                hasValidSide = true;
                break;
            }
            if (!hasValidSide) {
                return false;
            }
        }
        return isInput || inventory.func_94041_b(slot.getSlot(), item);
    }

    private boolean isSlotValid(IInventory inventory, ItemStack item, SlotSideTarget slot) {
        if (item == null) {
            return false;
        }
        if (inventory instanceof ISidedInventory) {
            Iterator iterator = slot.getSides().iterator();
            while (iterator.hasNext()) {
                int side = (Integer)iterator.next();
                if (!((ISidedInventory)inventory).func_102008_b(slot.getSlot(), item, side) && !((ISidedInventory)inventory).func_102007_a(slot.getSlot(), item, side)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void getItems(ComponentMenu componentMenu, List<SlotInventoryHolder> inventories) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        for (SlotInventoryHolder inventory : inventories) {
            Setting setting;
            if (inventory.getTile() instanceof IHiddenInventory) {
                IHiddenInventory node = (IHiddenInventory)inventory.getTile();
                node.addItemsToBuffer(menuItem, inventory, this.itemBuffer, this);
                continue;
            }
            if (inventory.getInventory() instanceof TileEntityCreative) {
                if (!menuItem.useWhiteList()) continue;
                for (SlotSideTarget slot : inventory.getValidSlots().values()) {
                    for (Setting setting1 : menuItem.getSettings()) {
                        setting = setting1;
                        ItemStack item = ((ItemSetting)setting).getItem();
                        if (item == null) continue;
                        item = item.func_77946_l();
                        item.field_77994_a = setting.isLimitedByAmount() ? setting.getAmount() : setting.getDefaultAmount();
                        this.addItemToBuffer(menuItem, inventory, setting, item, slot);
                    }
                }
                continue;
            }
            for (SlotSideTarget slot : inventory.getValidSlots().values()) {
                ItemStack itemStack = inventory.getInventory().func_70301_a(slot.getSlot());
                if (!this.isSlotValid(inventory.getInventory(), itemStack, slot, true)) continue;
                setting = this.isItemValid(((ComponentMenuStuff)componentMenu).getSettings(), itemStack);
                this.addItemToBuffer(menuItem, inventory, setting, itemStack, slot);
            }
        }
    }

    private void addItemToBuffer(ComponentMenuStuff menuItem, SlotInventoryHolder inventory, Setting setting, ItemStack itemStack, SlotSideTarget slot) {
        if (menuItem.useWhiteList() == (setting != null) || setting != null && setting.isLimitedByAmount()) {
            FlowComponent owner = menuItem.getParent();
            SlotStackInventoryHolder target = new SlotStackInventoryHolder(itemStack, inventory.getInventory(), slot.getSlot());
            boolean added = false;
            for (ItemBufferElement itemBufferElement : this.itemBuffer) {
                if (!itemBufferElement.addTarget(owner, setting, inventory, target)) continue;
                added = true;
                break;
            }
            if (!added) {
                this.itemBuffer.add(new ItemBufferElement(owner, setting, inventory, menuItem.useWhiteList(), target));
            }
        }
    }

    private void getValidTanks(ComponentMenu componentMenu, List<SlotInventoryHolder> tanks) {
        ComponentMenuTargetTank menuTarget = (ComponentMenuTargetTank)componentMenu;
        for (SlotInventoryHolder slotHolder : tanks) {
            Map validTanks = slotHolder.getValidSlots();
            if (slotHolder.getTile() instanceof IHiddenTank) {
                SlotSideTarget var13 = (SlotSideTarget)validTanks.get(0);
                if (var13 == null) {
                    validTanks.put(0, new SlotSideTarget(0, 0));
                    continue;
                }
                var13.addSide(0);
                continue;
            }
            IFluidHandler tank = slotHolder.getTank();
            if (tank == null) continue;
            for (int side = 0; side < ComponentMenuTarget.directions.length; ++side) {
                SlotSideTarget var13;
                if (!menuTarget.isActive(side)) continue;
                if (menuTarget.useAdvancedSetting(side)) {
                    boolean target = true;
                    FluidTankInfo[] infos = tank.getTankInfo(ComponentMenuTarget.directions[side]);
                    if (infos == null) continue;
                    for (FluidTankInfo fluidTankInfo : infos) {
                        if (fluidTankInfo.fluid == null || fluidTankInfo.fluid.amount <= 0) continue;
                        target = false;
                        break;
                    }
                    if (target != menuTarget.requireEmpty(side)) continue;
                }
                if ((var13 = (SlotSideTarget)validTanks.get(0)) == null) {
                    validTanks.put(0, new SlotSideTarget(0, side));
                    continue;
                }
                var13.addSide(side);
            }
        }
    }

    private void getLiquids(ComponentMenu componentMenu, List<SlotInventoryHolder> tanks) {
        for (SlotInventoryHolder tank : tanks) {
            ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
            if (tank.getTile() instanceof IHiddenTank) {
                IHiddenTank node = (IHiddenTank)tank.getTile();
                node.addFluidsToBuffer(menuItem, tank, this.liquidBuffer, this);
                continue;
            }
            if (tank.getTank() instanceof TileEntityCreative) {
                if (!menuItem.useWhiteList()) continue;
                Iterator itr = tank.getValidSlots().values().iterator();
                while (itr.hasNext()) {
                    itr.next();
                    for (Setting setting : menuItem.getSettings()) {
                        Fluid fluid = ((LiquidSetting)setting).getFluid();
                        if (fluid == null) continue;
                        FluidStack stack = new FluidStack(fluid, setting.isLimitedByAmount() ? setting.getAmount() : setting.getDefaultAmount());
                        this.addLiquidToBuffer(menuItem, tank, setting, stack, 0);
                    }
                }
                continue;
            }
            for (SlotSideTarget slot : tank.getValidSlots().values()) {
                ArrayList<FluidTankInfo> tankInfos = new ArrayList<FluidTankInfo>();
                for (Integer side : slot.getSides()) {
                    FluidTankInfo[] currentTankInfos = tank.getTank().getTankInfo(ForgeDirection.VALID_DIRECTIONS[side]);
                    if (currentTankInfos == null) continue;
                    FluidTankInfo[] arr$ = currentTankInfos;
                    int len$ = currentTankInfos.length;
                    for (int i$3 = 0; i$3 < len$; ++i$3) {
                        FluidStack var23;
                        FluidTankInfo fluidTankInfo = arr$[i$3];
                        if (fluidTankInfo == null) continue;
                        boolean alreadyUsed = false;
                        for (FluidTankInfo setting : tankInfos) {
                            if (!FluidStack.areFluidStackTagsEqual((FluidStack)setting.fluid, (FluidStack)fluidTankInfo.fluid) || setting.capacity != fluidTankInfo.capacity) continue;
                            alreadyUsed = true;
                        }
                        if (alreadyUsed || (var23 = fluidTankInfo.fluid) == null) continue;
                        var23 = var23.copy();
                        Setting var24 = this.isLiquidValid(componentMenu, var23);
                        this.addLiquidToBuffer(menuItem, tank, var24, var23, side);
                    }
                    for (FluidTankInfo fluidTankInfo : tank.getTank().getTankInfo(ForgeDirection.VALID_DIRECTIONS[side])) {
                        if (fluidTankInfo == null) continue;
                        tankInfos.add(fluidTankInfo);
                    }
                }
            }
        }
    }

    private void addLiquidToBuffer(ComponentMenuStuff menuItem, SlotInventoryHolder tank, Setting setting, FluidStack fluidStack, int side) {
        if (menuItem.useWhiteList() == (setting != null) || setting != null && setting.isLimitedByAmount()) {
            FlowComponent owner = menuItem.getParent();
            StackTankHolder target = new StackTankHolder(fluidStack, tank.getTank(), ForgeDirection.VALID_DIRECTIONS[side]);
            boolean added = false;
            for (LiquidBufferElement liquidBufferElement : this.liquidBuffer) {
                if (!liquidBufferElement.addTarget(owner, setting, tank, target)) continue;
                added = true;
                break;
            }
            if (!added) {
                LiquidBufferElement itemBufferElement1 = new LiquidBufferElement(owner, setting, tank, menuItem.useWhiteList(), target);
                this.liquidBuffer.add(itemBufferElement1);
            }
        }
    }

    public Setting isItemValid(List<Setting> settings, ItemStack itemStack) {
        Setting setting;
        Iterator<Setting> itr = settings.iterator();
        do {
            if (itr.hasNext()) continue;
            return null;
        } while (!((ItemSetting)(setting = itr.next())).isEqualForCommandExecutor(itemStack));
        return setting;
    }

    public Setting isLiquidValid(ComponentMenu componentMenu, FluidStack fluidStack) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        if (fluidStack != null) {
            int fluidId = fluidStack.getFluidID();
            for (Setting setting : menuItem.getSettings()) {
                if (!setting.isValid() || ((LiquidSetting)setting).getLiquidId() != fluidId) continue;
                return setting;
            }
        }
        return null;
    }

    private void insertItems(ComponentMenu componentMenu, List<SlotInventoryHolder> inventories) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        ArrayList<AdvancedOutputItemCounter> outputCounters = new ArrayList<AdvancedOutputItemCounter>();
        for (SlotInventoryHolder inventoryHolder : inventories) {
            if (!inventoryHolder.isShared()) {
                outputCounters.clear();
            }
            for (CraftingBufferFluidElement craftingBufferElement : this.craftingBufferHigh) {
                this.insertItemsFromInputBufferElement(menuItem, inventories, outputCounters, inventoryHolder, craftingBufferElement);
            }
            for (ItemBufferElement itemBufferElement : this.itemBuffer) {
                this.insertItemsFromInputBufferElement(menuItem, inventories, outputCounters, inventoryHolder, (IItemBufferElement)itemBufferElement);
            }
            for (CraftingBufferFluidElement craftingBufferElement : this.craftingBufferLow) {
                this.insertItemsFromInputBufferElement(menuItem, inventories, outputCounters, inventoryHolder, craftingBufferElement);
            }
        }
    }

    private void insertItemsFromInputBufferElement(ComponentMenuStuff menuItem, List<SlotInventoryHolder> inventories, List<AdvancedOutputItemCounter> outputCounters, SlotInventoryHolder inventoryHolder, IItemBufferElement itemBufferElement) {
        IItemBufferSubElement subElement;
        itemBufferElement.prepareSubElements();
        IInventory inventory = inventoryHolder.getInventory();
        block0: while ((subElement = itemBufferElement.getSubElement()) != null) {
            ItemStack itemStack = subElement.getItemStack();
            Setting setting = this.isItemValid(menuItem.getSettings(), itemStack);
            if (menuItem.useWhiteList() == (setting == null) && (setting == null || !setting.isLimitedByAmount())) continue;
            AdvancedOutputItemCounter outputItemCounter = null;
            for (AdvancedOutputItemCounter slot : outputCounters) {
                if (!slot.areSettingsSame(setting)) continue;
                outputItemCounter = slot;
                break;
            }
            if (outputItemCounter == null) {
                outputItemCounter = new AdvancedOutputItemCounter(this.itemBuffer, inventories, inventory, setting, menuItem.useWhiteList());
                outputCounters.add(outputItemCounter);
            }
            if (inventoryHolder.getTile() instanceof IHiddenInventory) {
                IHiddenInventory hidden = (IHiddenInventory)inventoryHolder.getTile();
                int moveCount = Math.min(hidden.getInsertable(itemStack), itemStack.field_77994_a);
                if (moveCount <= 0) continue;
                moveCount = Math.min(subElement.getSizeLeft(), moveCount);
                moveCount = outputItemCounter.retrieveItemCount(moveCount);
                if ((moveCount = itemBufferElement.retrieveItemCount(moveCount)) <= 0) continue;
                itemBufferElement.decreaseStackSize(moveCount);
                outputItemCounter.modifyStackSize(moveCount);
                ItemStack toInsert = itemStack.func_77946_l();
                toInsert.field_77994_a = moveCount;
                hidden.insertItemStack(toInsert);
                subElement.reduceAmount(moveCount);
                if (subElement.getSizeLeft() == 0) {
                    subElement.remove();
                    itemBufferElement.removeSubElement();
                }
                subElement.onUpdate();
                continue;
            }
            for (AdvancedOutputItemCounter slot : inventoryHolder.getValidSlots().values()) {
                boolean newItem;
                if (!this.isSlotValid(inventory, itemStack, (SlotSideTarget)slot, false)) continue;
                ItemStack itemInSlot = inventory.func_70301_a(slot.getSlot());
                boolean bl = newItem = itemInSlot == null;
                if (!newItem && (!itemInSlot.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)itemInSlot) || !itemStack.func_77985_e())) continue;
                int itemCountInSlot = newItem ? 0 : itemInSlot.field_77994_a;
                int moveCount = Math.min(subElement.getSizeLeft(), Math.min(inventory.func_70297_j_(), itemStack.func_77976_d()) - itemCountInSlot);
                moveCount = outputItemCounter.retrieveItemCount(moveCount);
                if ((moveCount = itemBufferElement.retrieveItemCount(moveCount)) <= 0) continue;
                if (newItem) {
                    itemInSlot = itemStack.func_77946_l();
                    itemInSlot.field_77994_a = 0;
                }
                itemBufferElement.decreaseStackSize(moveCount);
                outputItemCounter.modifyStackSize(moveCount);
                itemInSlot.field_77994_a += moveCount;
                subElement.reduceAmount(moveCount);
                if (newItem) {
                    inventory.func_70299_a(slot.getSlot(), itemInSlot);
                }
                boolean done = false;
                if (subElement.getSizeLeft() == 0) {
                    subElement.remove();
                    itemBufferElement.removeSubElement();
                    done = true;
                }
                inventory.func_70296_d();
                subElement.onUpdate();
                if (!done) continue;
                continue block0;
            }
        }
        itemBufferElement.releaseSubElements();
    }

    private void insertLiquids(ComponentMenu componentMenu, List<SlotInventoryHolder> tanks) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        ArrayList<OutputLiquidCounter> outputCounters = new ArrayList<OutputLiquidCounter>();
        for (SlotInventoryHolder tankHolder : tanks) {
            if (!tankHolder.isShared()) {
                outputCounters.clear();
            }
            IFluidHandler tank = tankHolder.getTank();
            for (LiquidBufferElement liquidBufferElement : this.liquidBuffer) {
                Iterator liquidIterator = liquidBufferElement.getHolders().iterator();
                while (liquidIterator.hasNext()) {
                    StackTankHolder holder = (StackTankHolder)liquidIterator.next();
                    FluidStack fluidStack = holder.getFluidStack();
                    Setting setting = this.isLiquidValid(componentMenu, fluidStack);
                    if (menuItem.useWhiteList() == (setting == null) && (setting == null || !setting.isLimitedByAmount())) continue;
                    OutputLiquidCounter outputLiquidCounter = null;
                    for (OutputLiquidCounter slot : outputCounters) {
                        if (!slot.areSettingsSame(setting)) continue;
                        outputLiquidCounter = slot;
                        break;
                    }
                    if (outputLiquidCounter == null) {
                        outputLiquidCounter = new OutputLiquidCounter(this.liquidBuffer, tanks, tankHolder, setting, menuItem.useWhiteList());
                        outputCounters.add(outputLiquidCounter);
                    }
                    block4: for (OutputLiquidCounter slot : tankHolder.getValidSlots().values()) {
                        Iterator iterator = slot.getSides().iterator();
                        while (iterator.hasNext()) {
                            int side = (Integer)iterator.next();
                            FluidStack temp = fluidStack.copy();
                            temp.amount = holder.getSizeLeft();
                            int amount = tank.fill(ForgeDirection.VALID_DIRECTIONS[side], temp, false);
                            amount = liquidBufferElement.retrieveItemCount(amount);
                            if ((amount = outputLiquidCounter.retrieveItemCount(amount)) <= 0) continue;
                            FluidStack resource = fluidStack.copy();
                            resource.amount = amount;
                            resource = holder.getTank().drain(holder.getSide(), resource, true);
                            if (resource == null || resource.amount <= 0) continue;
                            tank.fill(ForgeDirection.VALID_DIRECTIONS[side], resource, true);
                            liquidBufferElement.decreaseStackSize(resource.amount);
                            outputLiquidCounter.modifyStackSize(resource.amount);
                            holder.reduceAmount(resource.amount);
                            if (holder.getSizeLeft() != 0) continue;
                            liquidIterator.remove();
                            continue block4;
                        }
                    }
                }
            }
        }
    }

    private boolean searchForStuff(ComponentMenu componentMenu, List<SlotInventoryHolder> inventories, boolean useLiquids) {
        if (!inventories.get(0).isShared()) {
            boolean var7 = inventories.get(0).getSharedOption() == 1;
            for (int i = 0; i < inventories.size(); ++i) {
                HashMap<Integer, ConditionSettingChecker> conditionSettingCheckerMap = new HashMap<Integer, ConditionSettingChecker>();
                this.calculateConditionData(componentMenu, inventories.get(i), conditionSettingCheckerMap, useLiquids);
                if (this.checkConditionResult(componentMenu, conditionSettingCheckerMap)) {
                    if (var7) continue;
                    return true;
                }
                if (!var7) continue;
                return false;
            }
            return var7;
        }
        HashMap<Integer, ConditionSettingChecker> useAnd = new HashMap<Integer, ConditionSettingChecker>();
        for (int i = 0; i < inventories.size(); ++i) {
            this.calculateConditionData(componentMenu, inventories.get(i), useAnd, useLiquids);
        }
        return this.checkConditionResult(componentMenu, useAnd);
    }

    private void calculateConditionData(ComponentMenu componentMenu, SlotInventoryHolder inventoryHolder, Map<Integer, ConditionSettingChecker> conditionSettingCheckerMap, boolean useLiquid) {
        if (useLiquid) {
            this.calculateConditionDataLiquid(componentMenu, inventoryHolder, conditionSettingCheckerMap);
        } else {
            this.calculateConditionDataItem(componentMenu, inventoryHolder, conditionSettingCheckerMap);
        }
    }

    private void calculateConditionDataItem(ComponentMenu componentMenu, SlotInventoryHolder inventoryHolder, Map<Integer, ConditionSettingChecker> conditionSettingCheckerMap) {
        if (inventoryHolder.getTile() instanceof IHiddenInventory) {
            ((IHiddenInventory)inventoryHolder.getTile()).isItemValid(((ComponentMenuStuff)componentMenu).getSettings(), conditionSettingCheckerMap);
        } else {
            for (SlotSideTarget slot : inventoryHolder.getValidSlots().values()) {
                Setting setting;
                ItemStack itemStack = inventoryHolder.getInventory().func_70301_a(slot.getSlot());
                if (!this.isSlotValid(inventoryHolder.getInventory(), itemStack, slot)) continue;
                if (inventoryHolder.getInventory() instanceof IDeepStorageUnit) {
                    itemStack = ((IDeepStorageUnit)inventoryHolder.getInventory()).getStoredItemType();
                }
                if ((setting = this.isItemValid(((ComponentMenuStuff)componentMenu).getSettings(), itemStack)) == null) continue;
                ConditionSettingChecker conditionSettingChecker = conditionSettingCheckerMap.get(setting.getId());
                if (conditionSettingChecker == null) {
                    conditionSettingChecker = new ConditionSettingChecker(setting);
                    conditionSettingCheckerMap.put(setting.getId(), conditionSettingChecker);
                }
                conditionSettingChecker.addCount(itemStack.field_77994_a);
            }
        }
    }

    private void calculateConditionDataLiquid(ComponentMenu componentMenu, SlotInventoryHolder tank, Map<Integer, ConditionSettingChecker> conditionSettingCheckerMap) {
        for (SlotSideTarget slot : tank.getValidSlots().values()) {
            ArrayList<FluidTankInfo> tankInfos = new ArrayList<FluidTankInfo>();
            Iterator iterator = slot.getSides().iterator();
            while (iterator.hasNext()) {
                int side = (Integer)iterator.next();
                FluidTankInfo[] currentTankInfos = tank.getTile() instanceof IHiddenTank ? ((IHiddenTank)tank.getTile()).getTank().getTankInfo(null) : tank.getTank().getTankInfo(ForgeDirection.VALID_DIRECTIONS[side]);
                if (currentTankInfos == null) continue;
                for (FluidTankInfo fluidTankInfo : currentTankInfos) {
                    FluidStack var18;
                    FluidTankInfo setting2;
                    if (fluidTankInfo == null) continue;
                    boolean alreadyUsed = false;
                    for (FluidTankInfo setting2 : tankInfos) {
                        if (!FluidStack.areFluidStackTagsEqual((FluidStack)setting2.fluid, (FluidStack)fluidTankInfo.fluid) || setting2.capacity != fluidTankInfo.capacity) continue;
                        alreadyUsed = true;
                    }
                    if (alreadyUsed || (setting2 = this.isLiquidValid(componentMenu, var18 = fluidTankInfo.fluid)) == null) continue;
                    ConditionSettingChecker conditionSettingChecker = conditionSettingCheckerMap.get(setting2.getId());
                    if (conditionSettingChecker == null) {
                        conditionSettingChecker = new ConditionSettingChecker((Setting)setting2);
                        conditionSettingCheckerMap.put(setting2.getId(), conditionSettingChecker);
                    }
                    conditionSettingChecker.addCount(var18.amount);
                }
                for (FluidTankInfo fluidTankInfo : currentTankInfos) {
                    if (fluidTankInfo == null) continue;
                    tankInfos.add(fluidTankInfo);
                }
            }
        }
    }

    private boolean checkConditionResult(ComponentMenu componentMenu, Map<Integer, ConditionSettingChecker> conditionSettingCheckerMap) {
        ComponentMenuStuff menuItem = (ComponentMenuStuff)componentMenu;
        IConditionStuffMenu menuCondition = (IConditionStuffMenu)componentMenu;
        for (Setting setting : menuItem.getSettings()) {
            if (!setting.isValid()) continue;
            ConditionSettingChecker conditionSettingChecker = conditionSettingCheckerMap.get(setting.getId());
            if (conditionSettingChecker != null && conditionSettingChecker.isTrue()) {
                if (menuCondition.requiresAll()) continue;
                return true;
            }
            if (!menuCondition.requiresAll()) continue;
            return false;
        }
        return menuCondition.requiresAll();
    }

    private boolean splitFlow(ComponentMenu componentMenu) {
        ComponentMenuSplit split = (ComponentMenuSplit)componentMenu;
        if (!split.useSplit()) {
            return false;
        }
        int amount = componentMenu.getParent().getConnectionSet().getOutputCount();
        if (!split.useEmpty()) {
            ConnectionOption[] usedId = componentMenu.getParent().getConnectionSet().getConnections();
            for (int connections = 0; connections < usedId.length; ++connections) {
                ConnectionOption i = usedId[connections];
                if (i.isInput() || componentMenu.getParent().getConnection(connections) != null) continue;
                --amount;
            }
        }
        int var14 = 0;
        ConnectionOption[] var15 = componentMenu.getParent().getConnectionSet().getConnections();
        for (int var16 = 0; var16 < var15.length; ++var16) {
            ConnectionOption connectionOption = var15[var16];
            Connection connection = componentMenu.getParent().getConnection(var16);
            if (connectionOption.isInput() || connection == null) continue;
            ArrayList<ItemBufferElement> itemBufferSplit = new ArrayList<ItemBufferElement>();
            ArrayList<LiquidBufferElement> liquidBufferSplit = new ArrayList<LiquidBufferElement>();
            for (ItemBufferElement newExecutor : this.itemBuffer) {
                itemBufferSplit.add(newExecutor.getSplitElement(amount, var14, split.useFair()));
            }
            for (LiquidBufferElement var18 : this.liquidBuffer) {
                liquidBufferSplit.add(var18.getSplitElement(amount, var14, split.useFair()));
            }
            ArrayList<Integer> var17 = new ArrayList<Integer>();
            for (int usedCommand : this.usedCommands) {
                var17.add(usedCommand);
            }
            CommandExecutorRF var20 = new CommandExecutorRF(this.manager, itemBufferSplit, new ArrayList<CraftingBufferFluidElement>(this.craftingBufferHigh), new ArrayList<CraftingBufferFluidElement>(this.craftingBufferLow), liquidBufferSplit, this.rfBuffer, var17);
            var20.executeCommand((FlowComponent)this.manager.getFlowItems().get(connection.getComponentId()), connection.getConnectionId());
            ++var14;
        }
        return true;
    }

    private boolean evaluateRedstoneCondition(List<SlotInventoryHolder> nodes, FlowComponent component) {
        return TileEntityManager.redstoneCondition.isTriggerPowered(nodes, component, true);
    }

    private void updateVariable(List<SlotInventoryHolder> tiles, ComponentMenuVariable menuVariable, ComponentMenuListOrder menuOrder) {
        ComponentMenuVariable.VariableMode mode = menuVariable.getVariableMode();
        Variable variable = this.manager.getVariables()[menuVariable.getSelectedVariable()];
        if (variable.isValid()) {
            boolean remove;
            boolean bl = remove = mode == ComponentMenuVariable.VariableMode.REMOVE;
            if (!remove && mode != ComponentMenuVariable.VariableMode.ADD) {
                variable.clearContainers();
            }
            List<Integer> idList = new ArrayList<Integer>();
            for (SlotInventoryHolder validTypes : tiles) {
                idList.add(validTypes.getId());
            }
            if (!menuVariable.isDeclaration()) {
                idList = this.applyOrder(idList, menuOrder);
            }
            List inventories1 = this.manager.getConnectedInventories();
            EnumSet validTypes1 = ((ComponentMenuContainerTypes)variable.getDeclaration().getMenus().get(1)).getValidTypes();
            for (int id : idList) {
                if (remove) {
                    variable.remove(id);
                    continue;
                }
                if (id < 0 || id >= inventories1.size() || !((ConnectionBlock)inventories1.get(id)).isOfAnyType(validTypes1)) continue;
                variable.add(id);
            }
        }
    }

    private void updateForLoop(FlowComponent command, ComponentMenuVariableLoop variableMenu, ComponentMenuContainerTypes typesMenu, ComponentMenuListOrder orderMenu) {
        Variable list = variableMenu.getListVariable();
        Variable element = variableMenu.getElementVariable();
        if (list.isValid() && element.isValid()) {
            List<Integer> selection = this.applyOrder(list.getContainers(), orderMenu);
            EnumSet validTypes = typesMenu.getValidTypes();
            validTypes.addAll(((ComponentMenuContainerTypes)element.getDeclaration().getMenus().get(1)).getValidTypes());
            List inventories = this.manager.getConnectedInventories();
            for (int selected : selection) {
                ConnectionBlock inventory;
                if (selected < 0 || selected >= inventories.size() || !(inventory = (ConnectionBlock)inventories.get(selected)).isOfAnyType(validTypes)) continue;
                element.clearContainers();
                element.add(selected);
                this.executeChildCommands(command, EnumSet.of(ConnectionOption.FOR_EACH));
            }
        }
    }

    private List<Integer> applyOrder(List<Integer> original, ComponentMenuListOrder orderMenu) {
        ArrayList<Integer> ret = new ArrayList<Integer>(original);
        if (orderMenu.getOrder() == ComponentMenuListOrder.LoopOrder.RANDOM) {
            Collections.shuffle(ret);
        } else if (orderMenu.getOrder() == ComponentMenuListOrder.LoopOrder.NORMAL) {
            if (!orderMenu.isReversed()) {
                Collections.reverse(ret);
            }
        } else {
            Collections.sort(ret, orderMenu.getComparator());
        }
        if (!orderMenu.useAll()) {
            int len = orderMenu.getAmount();
            while (ret.size() > len) {
                ret.remove(ret.size() - 1);
            }
        }
        return ret;
    }
}

