/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.base;

import greymerk.roguelike.dungeon.base.DungeonRoom;
import greymerk.roguelike.dungeon.base.IDungeonRoom;
import greymerk.roguelike.util.IWeighted;
import java.util.Random;

public class DungeonWeightedChoice
implements IWeighted<DungeonRoom>,
Comparable<IWeighted<?>> {
    DungeonRoom type;
    int chance;

    public DungeonWeightedChoice(DungeonRoom type, int chance) {
        this.type = type;
        this.chance = chance;
    }

    public boolean choose(Random rand) {
        return rand.nextInt(this.chance) == 0;
    }

    public IDungeonRoom getInstance() {
        return DungeonRoom.getInstance(this.type);
    }

    @Override
    public int compareTo(IWeighted<?> other) {
        if (this.chance < other.getWeight()) {
            return -1;
        }
        if (this.chance > other.getWeight()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getWeight() {
        return this.chance;
    }

    @Override
    public DungeonRoom get(Random rand) {
        return this.type;
    }
}

