/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.microblock.ItemSaw;
import cpw.mods.fml.common.registry.GameRegistry;
import gcewing.projectblue.ControlItem;
import gcewing.projectblue.ControlPanelItem;
import gcewing.projectblue.ControlPanelMaterial;
import gcewing.projectblue.ProjectBlue;
import gcewing.projectblue.SprayCanItem;
import gcewing.projectblue.nei.INEIRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.RecipeSorter;

public class ControlPanelRecipes {
    public static final int coverMeta = 1;
    public static final int hollowCoverMeta = 257;
    public static List<RecipeBase> recipes = new ArrayList<RecipeBase>();

    public static boolean isEmpty(InventoryCrafting ic, int c, int r) {
        return ic.func_70463_b(c, r) == null;
    }

    public static boolean isSaw(InventoryCrafting ic, int c, int r) {
        return ControlPanelRecipes.isSaw(ic.func_70463_b(c, r));
    }

    public static boolean isSaw(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemSaw;
    }

    public static boolean isHollowCover(InventoryCrafting ic, int c, int r) {
        return ControlPanelRecipes.isHollowCover(ic.func_70463_b(c, r));
    }

    public static boolean isHollowCover(ItemStack stack) {
        return stack != null && stack.func_77973_b() == ProjectBlue.itemMicroPart && stack.func_77960_j() == 257;
    }

    public static boolean isFullSizeControl(InventoryCrafting ic, int c, int r) {
        return ControlPanelRecipes.miniatureStackFor(ic, r, c) != null;
    }

    public static boolean isFullSizeControl(ItemStack stack) {
        return ControlPanelRecipes.miniatureStackFor(stack) != null;
    }

    public static boolean isControlPanel(ItemStack stack) {
        return stack.func_77973_b() instanceof ControlPanelItem;
    }

    public static ItemStack miniatureStackFor(InventoryCrafting ic, int c, int r) {
        return ControlPanelRecipes.miniatureStackFor(ic.func_70463_b(c, r));
    }

    public static ItemStack miniatureStackFor(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        int meta = stack.func_77960_j();
        if (item instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150442_at) {
                return new ItemStack(ProjectBlue.miniatureLever, 1, 16);
            }
            if (block == Blocks.field_150430_aB) {
                return new ItemStack(ProjectBlue.miniatureButton, 1, 16);
            }
            if (block == Blocks.field_150471_bO) {
                return new ItemStack(ProjectBlue.miniatureButton, 1, 17);
            }
        }
        if (item == ProjectBlue.itemPartFixture) {
            return new ItemStack(ProjectBlue.miniatureLamp, 1, meta);
        }
        if (item == ProjectBlue.itemMicroPart && meta == 1) {
            return ControlPanelMaterial.forStack(stack).newStack(ProjectBlue.miniatureCover);
        }
        return null;
    }

    public static ItemStack fullSizeStackFor(ItemStack stack) {
        Item item = stack.func_77973_b();
        int meta = stack.func_77960_j();
        if (item == ProjectBlue.miniatureLever && meta == 16) {
            return new ItemStack(Blocks.field_150442_at);
        }
        if (item == ProjectBlue.miniatureButton && meta == 16) {
            return new ItemStack(Blocks.field_150430_aB);
        }
        if (item == ProjectBlue.miniatureButton && meta == 17) {
            return new ItemStack(Blocks.field_150471_bO);
        }
        if (item == ProjectBlue.miniatureLamp) {
            return new ItemStack(ProjectBlue.itemPartFixture, 1, meta);
        }
        if (item == ProjectBlue.miniatureCover) {
            return ControlPanelMaterial.forStack(stack).newStack(ProjectBlue.itemMicroPart, 1);
        }
        return null;
    }

    public static String materialAt(InventoryCrafting ic, int c, int r) {
        ItemStack stack = ic.func_70463_b(c, r);
        return ControlPanelItem.getMaterial(stack);
    }

    static boolean isPaintableControl(InventoryCrafting ic, int c, int r) {
        return ControlPanelRecipes.isPaintableControl(ic.func_70463_b(c, r));
    }

    static boolean isPaintableControl(ItemStack stack) {
        Item item;
        if (stack != null && (item = stack.func_77973_b()) instanceof ControlItem) {
            switch (((ControlItem)item).type) {
                case LEVER: 
                case BUTTON: {
                    return true;
                }
            }
        }
        return false;
    }

    static boolean isPaintedControl(ItemStack stack) {
        return ControlPanelRecipes.isPaintableControl(stack) && stack.func_77960_j() < 16;
    }

    static boolean isSprayCan(InventoryCrafting ic, int c, int r) {
        return ControlPanelRecipes.isSprayCan(ic.func_70463_b(c, r));
    }

    static boolean isSprayCan(ItemStack stack) {
        if (stack != null) {
            return stack.func_77973_b() instanceof SprayCanItem;
        }
        return false;
    }

    static void addRecipe(RecipeBase r) {
        recipes.add(r);
        GameRegistry.addRecipe((IRecipe)r);
    }

    public static void registerRecipes() {
        RecipeSorter.register((String)"projectblue:controlpanel", RecipeBase.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        ControlPanelRecipes.addRecipe(new CraftControlPanel());
        ControlPanelRecipes.addRecipe(new CraftMiniatureItem());
        ControlPanelRecipes.addRecipe(new PaintControl());
    }

    static class PaintControl
    extends RecipeBase {
        PaintControl() {
        }

        public boolean func_77569_a(InventoryCrafting ic, World world) {
            return ControlPanelRecipes.isPaintableControl(ic, 0, 0) && ControlPanelRecipes.isSprayCan(ic, 1, 0);
        }

        public ItemStack func_77572_b(InventoryCrafting ic) {
            ItemStack ctrl = ic.func_70463_b(0, 0);
            ItemStack paint = ic.func_70463_b(1, 0);
            SprayCanItem can = (SprayCanItem)paint.func_77973_b();
            return new ItemStack(ctrl.func_77973_b(), 1, can.getColor(paint));
        }

        @Override
        public void addCraftingToNEI(INEIRecipeHandler h, ItemStack result) {
            if (ControlPanelRecipes.isPaintedControl(result)) {
                Item item = result.func_77973_b();
                int color = result.func_77960_j();
                ItemStack paint = ProjectBlue.sprayCan.newStack(1, color);
                this.addRecipeToNEI(h, new ItemStack(item, 1, 16), paint);
            }
        }

        @Override
        public void addUsageToNEI(INEIRecipeHandler h, ItemStack ingredient) {
            if (ControlPanelRecipes.isSprayCan(ingredient)) {
                this.addRecipeToNEI(h, new ItemStack(ProjectBlue.miniatureLever, 1, 16), ingredient);
                this.addRecipeToNEI(h, new ItemStack(ProjectBlue.miniatureButton, 1, 16), ingredient);
                this.addRecipeToNEI(h, new ItemStack(ProjectBlue.miniatureButton, 1, 17), ingredient);
            } else if (ControlPanelRecipes.isPaintableControl(ingredient)) {
                for (int i = 0; i < 16; ++i) {
                    ItemStack paint = ProjectBlue.sprayCan.newStack(1, i);
                    this.addRecipeToNEI(h, ingredient, paint);
                }
            }
        }

        void addRecipeToNEI(INEIRecipeHandler h, ItemStack ctrl, ItemStack paint) {
            Item item = ctrl.func_77973_b();
            int color = ProjectBlue.sprayCan.getColor(paint);
            ItemStack result = new ItemStack(item, 1, color);
            h.addShapedRecipe(2, 1, result, ctrl, paint);
        }
    }

    static class CraftMiniatureItem
    extends RecipeBase {
        CraftMiniatureItem() {
        }

        public boolean func_77569_a(InventoryCrafting ic, World world) {
            return ControlPanelRecipes.isSaw(ic, 0, 0) && ControlPanelRecipes.isEmpty(ic, 0, 1) && ControlPanelRecipes.isEmpty(ic, 1, 0) && ControlPanelRecipes.isFullSizeControl(ic, 1, 1);
        }

        public ItemStack func_77572_b(InventoryCrafting ic) {
            ItemStack stack = ControlPanelRecipes.miniatureStackFor(ic, 1, 1);
            if (stack != null) {
                stack.field_77994_a = 8;
            }
            return stack;
        }

        @Override
        public void addCraftingToNEI(INEIRecipeHandler h, ItemStack result) {
            ItemStack ingredient = ControlPanelRecipes.fullSizeStackFor(result);
            if (ingredient != null) {
                this.addRecipeToNEI(h, null, ingredient);
            }
        }

        @Override
        public void addUsageToNEI(INEIRecipeHandler h, ItemStack ingredient) {
            if (ControlPanelRecipes.isSaw(ingredient)) {
                ControlPanelMaterial base = ControlPanelMaterial.forName("tile.wood");
                this.addRecipeToNEI(h, ingredient, new ItemStack(Blocks.field_150442_at));
                this.addRecipeToNEI(h, ingredient, new ItemStack(Blocks.field_150430_aB));
                this.addRecipeToNEI(h, ingredient, new ItemStack(Blocks.field_150471_bO));
                this.addRecipeToNEI(h, ingredient, base.newStack(ProjectBlue.itemMicroPart, 1));
                for (int i = 0; i < 16; ++i) {
                    this.addRecipeToNEI(h, ingredient, new ItemStack(ProjectBlue.itemPartFixture, 1, i));
                }
            } else if (ControlPanelRecipes.isFullSizeControl(ingredient)) {
                this.addRecipeToNEI(h, null, ingredient);
            }
        }

        void addRecipeToNEI(INEIRecipeHandler h, ItemStack saw, ItemStack ingredient) {
            if (saw == null) {
                saw = ProjectBlue.stackStoneSaw;
            }
            ItemStack result = ControlPanelRecipes.miniatureStackFor(ingredient);
            result.field_77994_a = 8;
            h.addShapedRecipe(2, 2, result, saw, null, null, ingredient);
        }
    }

    static class CraftControlPanel
    extends RecipeBase {
        CraftControlPanel() {
        }

        public boolean func_77569_a(InventoryCrafting ic, World world) {
            return ControlPanelRecipes.isSaw(ic, 0, 0) && ControlPanelRecipes.isEmpty(ic, 0, 1) && ControlPanelRecipes.isEmpty(ic, 1, 0) && ControlPanelRecipes.isHollowCover(ic, 1, 1);
        }

        public ItemStack func_77572_b(InventoryCrafting ic) {
            String material = ControlPanelRecipes.materialAt(ic, 1, 1);
            ControlPanelMaterial base = ControlPanelMaterial.forName(material);
            return base.newStack();
        }

        @Override
        public void addCraftingToNEI(INEIRecipeHandler h, ItemStack result) {
            if (ControlPanelRecipes.isControlPanel(result)) {
                this.addRecipeToNEI(h, null, ControlPanelMaterial.forStack(result));
            }
        }

        @Override
        public void addUsageToNEI(INEIRecipeHandler h, ItemStack ingredient) {
            if (ControlPanelRecipes.isSaw(ingredient)) {
                this.addRecipeToNEI(h, ingredient, ControlPanelMaterial.forName("tile.wood"));
            } else if (ControlPanelRecipes.isHollowCover(ingredient)) {
                this.addRecipeToNEI(h, null, ControlPanelMaterial.forStack(ingredient));
            }
        }

        void addRecipeToNEI(INEIRecipeHandler h, ItemStack saw, ControlPanelMaterial base) {
            if (saw == null) {
                saw = ProjectBlue.stackStoneSaw;
            }
            ItemStack cover = base.newStack(ProjectBlue.itemMicroPart, 257);
            ItemStack panel = base.newStack();
            h.addShapedRecipe(2, 2, panel, saw, null, null, cover);
        }
    }

    public static abstract class RecipeBase
    implements IRecipe {
        public int func_77570_a() {
            return 4;
        }

        public ItemStack func_77571_b() {
            return null;
        }

        public void addCraftingToNEI(INEIRecipeHandler h, ItemStack result) {
        }

        public void addUsageToNEI(INEIRecipeHandler h, ItemStack ingredient) {
        }
    }
}

