/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.content;

import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class PanelGeneric
implements IGuiPanel {
    private final IGuiRect transform;
    private boolean enabled = true;
    private IGuiTexture texture;
    private IGuiColor color;
    private List<String> tooltip = null;

    public PanelGeneric(IGuiRect rect, IGuiTexture texture) {
        this(rect, texture, null);
    }

    public PanelGeneric(IGuiRect rect, IGuiTexture texture, IGuiColor color) {
        this.transform = rect;
        this.texture = texture;
        this.color = color;
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    public void setTexture(IGuiTexture texture, IGuiColor color) {
        this.texture = texture;
        this.color = color;
    }

    @Override
    public IGuiRect getTransform() {
        return this.transform;
    }

    @Override
    public void initPanel() {
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        if (this.texture != null) {
            GL11.glPushMatrix();
            if (this.color != null) {
                this.texture.drawTexture(this.transform.getX(), this.transform.getY(), this.transform.getWidth(), this.transform.getHeight(), 0.0f, partialTick, this.color);
            } else {
                this.texture.drawTexture(this.transform.getX(), this.transform.getY(), this.transform.getWidth(), this.transform.getHeight(), 0.0f, partialTick);
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public boolean onMouseClick(int mx, int my, int button) {
        return false;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int button) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        return false;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        if (this.transform.contains(mx, my)) {
            return this.tooltip;
        }
        return null;
    }
}

