/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import openmods.calc.Environment;
import openmods.calc.Frame;
import openmods.calc.types.multi.CallableValue;
import openmods.calc.types.multi.MetaObject;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypeUserdata;
import openmods.calc.types.multi.TypedFunction;
import openmods.calc.types.multi.TypedValue;
import openmods.reflection.FieldAccess;
import openmods.utils.CachedFactory;
import openmods.utils.OptionalInt;

public class StructWrapper {
    private final Map<String, MemberValueProvider> members;
    private final Object target;
    private static final CachedFactory<Class<?>, Map<String, MemberValueProvider>> membersCache = new CachedFactory<Class<?>, Map<String, MemberValueProvider>>(){

        /*
         * WARNING - void declaration
         */
        @Override
        protected Map<String, MemberValueProvider> create(Class<?> cls) {
            void var5_7;
            ImmutableMap.Builder members = ImmutableMap.builder();
            Field[] fieldArray = cls.getFields();
            int n = fieldArray.length;
            boolean bl = false;
            while (var5_7 < n) {
                Field f = fieldArray[var5_7];
                ExposeProperty annotation = f.getAnnotation(ExposeProperty.class);
                if (annotation != null) {
                    if (annotation.raw()) {
                        StructWrapper.appendRawFieldMember((ImmutableMap.Builder<String, MemberValueProvider>)members, f);
                    } else {
                        StructWrapper.appendFieldMember((ImmutableMap.Builder<String, MemberValueProvider>)members, f);
                    }
                }
                ++var5_7;
            }
            HashMultimap methods = HashMultimap.create();
            for (Method m : cls.getMethods()) {
                ExposeProperty annotation = m.getAnnotation(ExposeProperty.class);
                if (annotation != null) {
                    if (annotation.raw()) {
                        StructWrapper.appendRawGetterMember((ImmutableMap.Builder<String, MemberValueProvider>)members, m);
                        continue;
                    }
                    StructWrapper.appendGetterMember((ImmutableMap.Builder<String, MemberValueProvider>)members, m);
                    continue;
                }
                if (!m.isAnnotationPresent(ExposeMethod.class)) continue;
                methods.put((Object)m.getName(), (Object)m);
            }
            for (Map.Entry entry : methods.asMap().entrySet()) {
                TypedFunction.Builder builder = TypedFunction.builder();
                for (Method m : (Collection)entry.getValue()) {
                    builder.addVariant(m);
                }
                StructWrapper.appendFunctionMember((ImmutableMap.Builder<String, MemberValueProvider>)members, (String)entry.getKey(), builder.build(cls));
            }
            return members.build();
        }
    };

    private StructWrapper(Map<String, MemberValueProvider> members, Object target) {
        this.members = members;
        this.target = target;
    }

    public Optional<TypedValue> getValue(TypeDomain domain, String key) {
        MemberValueProvider valueProvider = this.members.get(key);
        if (valueProvider == null) {
            return Optional.absent();
        }
        return Optional.of((Object)valueProvider.getValue(domain, this.target));
    }

    public Iterable<String> keys() {
        return this.members.keySet();
    }

    private static void appendFunctionMember(ImmutableMap.Builder<String, MemberValueProvider> members, String name, final TypedFunction.IUnboundCallable function) {
        members.put((Object)name, (Object)new MemberValueProvider(){

            @Override
            public TypedValue getValue(final TypeDomain domain, final Object target) {
                return domain.create(CallableValue.class, new CallableValue(){

                    @Override
                    public void call(TypedValue self, OptionalInt argumentsCount, OptionalInt returnsCount, Frame<TypedValue> frame) {
                        function.call(domain, target, frame, argumentsCount, returnsCount);
                    }
                });
            }
        });
    }

    private static void appendGetterMember(ImmutableMap.Builder<String, MemberValueProvider> members, final Method m) {
        Preconditions.checkState((m.getParameterTypes().length == 0 ? 1 : 0) != 0, (Object)"Getter method must have no parameters");
        m.setAccessible(true);
        members.put((Object)m.getName(), (Object)new MemberValueProvider(){

            @Override
            public TypedValue getValue(TypeDomain domain, Object target) {
                return this.wrapMethodValue(m, domain, target);
            }

            private <T> TypedValue wrapMethodValue(Method m2, TypeDomain domain, Object target) {
                try {
                    Object value = m2.invoke(target, new Object[0]);
                    Class<?> cls = m2.getReturnType();
                    return domain.create(cls, value);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    private static void appendRawGetterMember(ImmutableMap.Builder<String, MemberValueProvider> members, final Method m) {
        Preconditions.checkState((m.getParameterTypes().length == 0 ? 1 : 0) != 0, (Object)"Getter method must have no parameters");
        Preconditions.checkState((m.getReturnType() == TypedValue.class ? 1 : 0) != 0, (Object)"Raw getter must return TypedValue");
        m.setAccessible(true);
        members.put((Object)m.getName(), (Object)new MemberValueProvider(){

            @Override
            public TypedValue getValue(TypeDomain domain, Object target) {
                try {
                    return (TypedValue)m.invoke(target, new Object[0]);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    private static void appendFieldMember(ImmutableMap.Builder<String, MemberValueProvider> members, Field f) {
        final FieldAccess field = FieldAccess.create(f);
        members.put((Object)f.getName(), (Object)new MemberValueProvider(){

            @Override
            public TypedValue getValue(TypeDomain domain, Object target) {
                return this.wrapFieldValue(field, domain, target);
            }

            private <T> TypedValue wrapFieldValue(FieldAccess<T> field2, TypeDomain domain, Object target) {
                T value = field2.get(target);
                return domain.create(field2.getType(), value);
            }
        });
    }

    private static void appendRawFieldMember(ImmutableMap.Builder<String, MemberValueProvider> members, Field f) {
        Preconditions.checkState((f.getType() == TypedValue.class ? 1 : 0) != 0, (String)"Invalid field %s type", (Object[])new Object[]{f});
        final FieldAccess field = FieldAccess.create(f);
        members.put((Object)f.getName(), (Object)new MemberValueProvider(){

            @Override
            public TypedValue getValue(TypeDomain domain, Object target) {
                return (TypedValue)field.get(target);
            }
        });
    }

    public static <T> StructWrapper create(Class<? super T> cls, T target) {
        Map<String, MemberValueProvider> members = membersCache.getOrCreate(cls);
        return new StructWrapper(members, target);
    }

    public static <T> TypedValue create(TypeDomain domain, Class<? super T> cls, T target) {
        return domain.create(StructWrapper.class, StructWrapper.create(cls, target));
    }

    public static StructWrapper create(Object target) {
        Map<String, MemberValueProvider> members = membersCache.getOrCreate(target.getClass());
        return new StructWrapper(members, target);
    }

    public static TypedValue create(TypeDomain domain, Object target) {
        return domain.create(StructWrapper.class, StructWrapper.create(target));
    }

    public static void register(Environment<TypedValue> env) {
        TypedValue nullValue = env.nullValue();
        TypeDomain domain = nullValue.domain;
        TypedValue structType = domain.create(TypeUserdata.class, new TypeUserdata("object", StructWrapper.class));
        env.setGlobalSymbol("object", structType);
        domain.registerType(StructWrapper.class, "object", MetaObject.builder().set(new MetaObject.SlotAttr(){

            @Override
            public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                TypeDomain domain = self.domain;
                return self.as(StructWrapper.class).getValue(domain, key);
            }
        }).set(new MetaObject.SlotDir(){

            @Override
            public Iterable<String> dir(TypedValue self, Frame<TypedValue> frame) {
                return self.as(StructWrapper.class).keys();
            }
        }).build());
    }

    private static interface MemberValueProvider {
        public TypedValue getValue(TypeDomain var1, Object var2);
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExposeProperty {
        public boolean raw() default false;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExposeMethod {
    }
}

