/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import openmods.calc.ExecutableList;
import openmods.calc.IExecutable;
import openmods.calc.NoopExecutable;
import openmods.calc.Operator;
import openmods.calc.OperatorDictionary;
import openmods.calc.SymbolCall;
import openmods.calc.SymbolGet;
import openmods.calc.Value;
import openmods.calc.parsing.IExecutableListBuilder;
import openmods.calc.parsing.IValueParser;
import openmods.calc.parsing.InvalidTokenException;
import openmods.calc.parsing.Token;
import openmods.utils.OptionalInt;

public class DefaultExecutableListBuilder<E>
implements IExecutableListBuilder<E> {
    private final IValueParser<E> valueParser;
    private final OperatorDictionary<E> operators;
    private final List<IExecutable<E>> buffer = Lists.newArrayList();

    public DefaultExecutableListBuilder(IValueParser<E> valueParser, OperatorDictionary<E> operators) {
        this.valueParser = valueParser;
        this.operators = operators;
    }

    protected void addToBuffer(IExecutable<E> executable) {
        this.buffer.add(executable);
    }

    @Override
    public void appendValue(E value) {
        this.addToBuffer(Value.create(value));
    }

    @Override
    public void appendValue(Token token) {
        try {
            E parsedValue = this.valueParser.parseToken(token);
            this.appendValue(parsedValue);
        }
        catch (Throwable t) {
            throw new InvalidTokenException(token, t);
        }
    }

    private Operator<E> getAnyOperator(String id) {
        Operator op = this.operators.getBinaryOperator(id);
        if (op != null) {
            return op;
        }
        op = this.operators.getUnaryOperator(id);
        if (op != null) {
            return op;
        }
        throw new IllegalArgumentException("Invalid operator: " + id);
    }

    @Override
    public void appendOperator(String id) {
        this.addToBuffer(this.getAnyOperator(id));
    }

    @Override
    public void appendSymbolGet(String id) {
        this.addToBuffer(new SymbolGet(id));
    }

    @Override
    public void appendSymbolCall(String id, OptionalInt argCount, OptionalInt returnCount) {
        this.addToBuffer(new SymbolCall(id, argCount, returnCount));
    }

    @Override
    public void appendExecutable(IExecutable<E> executable) {
        if (!(executable instanceof NoopExecutable)) {
            if (executable instanceof ExecutableList) {
                ArrayList flattenedList = Lists.newArrayList();
                ((ExecutableList)executable).deepFlatten(flattenedList);
                for (IExecutable e : flattenedList) {
                    this.addToBuffer(e);
                }
            } else {
                this.addToBuffer(executable);
            }
        }
    }

    @Override
    public IExecutable<E> build() {
        return ExecutableList.wrap(this.buffer);
    }
}

